/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.report.handlers;

import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.tree.ReportTreeEntity;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.report.ReportEntity;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class RefreshReportHandler {
    @Inject
    private IEventBroker eventBroker;

    @PostConstruct
    public void registerEventHandler(IEventBroker eventBroker) {
        eventBroker.subscribe("EXPLORER/REFRESH_SELECTED_ITEM", new EventHandler(){

            public void handleEvent(Event event) {
                if (ProjectController.getInstance().getCurrentProject() == null) {
                    return;
                }
                Object object = event.getProperty("org.eclipse.e4.data");
                if (object != null && object instanceof ReportTreeEntity) {
                    try {
                        RefreshReportHandler.this.excute((ReportTreeEntity)object);
                    }
                    catch (Exception e) {
                        LoggerSingleton.logError((Throwable)e);
                    }
                }
            }
        });
    }

    protected void excute(ReportTreeEntity reportTreeEntity) throws Exception {
        if (reportTreeEntity.getObject() == null) {
            ITreeEntity parentEntity = reportTreeEntity.getParent();
            if (parentEntity != null && parentEntity instanceof FolderTreeEntity) {
                this.eventBroker.post("EXPLORER/REFRESH_SELECTED_ITEM", (Object)parentEntity);
            } else {
                FolderEntity folder = FolderController.getInstance().getReportRoot(ProjectController.getInstance().getCurrentProject());
                this.eventBroker.post("EXPLORER/REFRESH_SELECTED_ITEM", (Object)new FolderTreeEntity(folder, null));
            }
        } else {
            ReportEntity report = reportTreeEntity.getObject();
            FolderController.getInstance().refreshFolder(report.getParentFolder());
            this.eventBroker.post("REPORT/UPDATED", (Object)new Object[]{report.getId(), report});
        }
    }
}

