/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.report.handlers;

import com.kms.katalon.composer.components.dialogs.CWizardDialog;
import com.kms.katalon.composer.components.impl.tree.ReportCollectionTreeEntity;
import com.kms.katalon.composer.components.impl.tree.ReportTreeEntity;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.components.wizard.RenameWizard;
import com.kms.katalon.composer.report.constants.ComposerReportMessageConstants;
import com.kms.katalon.composer.report.constants.StringConstants;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ReportController;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.report.ReportCollectionEntity;
import com.kms.katalon.entity.report.ReportEntity;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class RenameReportHandler {
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private EPartService partService;
    @Named(value="activeShell")
    private Shell parentShell;

    @PostConstruct
    public void registerEventHandler() {
        this.eventBroker.subscribe("EXPLORER/RENAME_SELECTED_ITEM", new EventHandler(){

            public void handleEvent(Event event) {
                Object object = event.getProperty("org.eclipse.e4.data");
                if (object instanceof ReportTreeEntity) {
                    RenameReportHandler.this.execute((ReportTreeEntity)object);
                    return;
                }
                if (object instanceof ReportCollectionTreeEntity) {
                    RenameReportHandler.this.execute((ReportCollectionTreeEntity)object);
                    return;
                }
            }
        });
    }

    private void execute(ReportCollectionTreeEntity reportCollectionTreeEntity) {
        try {
            if (reportCollectionTreeEntity.getObject() == null) {
                return;
            }
            ReportCollectionEntity collectionReport = reportCollectionTreeEntity.getObject();
            List existingNames = FolderController.getInstance().getChildrenNames(collectionReport.getParentFolder());
            String newNameValue = this.openRenameWizard((ITreeEntity)reportCollectionTreeEntity, existingNames);
            if (StringUtils.isEmpty((CharSequence)newNameValue)) {
                return;
            }
            String oldName = collectionReport.getName();
            if (StringUtils.equals((CharSequence)newNameValue, (CharSequence)oldName)) {
                return;
            }
            try {
                ReportController.getInstance().renameReportCollection(collectionReport, newNameValue);
                this.eventBroker.send("EXPLORER/REFRESH_TREE_ENTITY", (Object)reportCollectionTreeEntity.getParent());
                this.eventBroker.post("EXPLORER/SET_SELECTED_ITEM", (Object)reportCollectionTreeEntity);
                this.eventBroker.post("REPORT/COLLECTION/RENAMED", (Object)collectionReport);
                this.partService.saveAll(false);
            }
            catch (Exception ex) {
                collectionReport.setName(oldName);
                LoggerSingleton.logError((Throwable)ex);
                MessageDialog.openError((Shell)this.parentShell, (String)StringConstants.ERROR, (String)ComposerReportMessageConstants.ERR_MSG_UNABLE_RENAME_REPORT);
                return;
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    public List<String> getChildrenReportDisplayNames(FolderEntity folder) throws Exception {
        List children = FolderController.getInstance().getChildren(folder);
        ArrayList<String> childrenNames = new ArrayList<String>();
        for (FileEntity child : children) {
            if (!(child instanceof ReportEntity)) continue;
            childrenNames.add(((ReportEntity)child).getDisplayName());
        }
        return childrenNames;
    }

    private void execute(ReportTreeEntity reportTreeEntity) {
        try {
            if (reportTreeEntity.getObject() == null) {
                return;
            }
            ReportEntity report = reportTreeEntity.getObject();
            List<String> existingNames = this.getChildrenReportDisplayNames(report.getParentFolder());
            String newNameValue = this.openRenameWizard((ITreeEntity)reportTreeEntity, existingNames);
            if (newNameValue == null) {
                return;
            }
            String oldName = report.getDisplayName();
            try {
                if (StringUtils.isNotEmpty((CharSequence)newNameValue) && !StringUtils.equals((CharSequence)oldName, (CharSequence)newNameValue)) {
                    report = ReportController.getInstance().renameReport(report, newNameValue);
                    this.eventBroker.send("EXPLORER/REFRESH_TREE_ENTITY", (Object)reportTreeEntity.getParent());
                    this.eventBroker.post("EXPLORER/SET_SELECTED_ITEM", (Object)reportTreeEntity);
                    this.eventBroker.post("REPORT/RENAMED", (Object)report);
                    this.partService.saveAll(false);
                }
            }
            catch (Exception ex) {
                report.setDisplayName(oldName);
                LoggerSingleton.logError((Throwable)ex);
                MessageDialog.openError((Shell)this.parentShell, (String)StringConstants.ERROR, (String)ComposerReportMessageConstants.ERR_MSG_UNABLE_RENAME_REPORT);
                return;
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private String openRenameWizard(ITreeEntity treeEntity, List<String> existingNames) {
        RenameWizard renameWizard = new RenameWizard(treeEntity, existingNames);
        CWizardDialog wizardDialog = new CWizardDialog(this.parentShell, (IWizard)renameWizard);
        if (wizardDialog.open() != 0) {
            return null;
        }
        return renameWizard.getNewNameValue();
    }
}

