/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.report.parts;

import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.impl.control.StyledTextMessage;
import com.kms.katalon.composer.components.impl.util.ControlUtils;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.components.util.ImageUtil;
import com.kms.katalon.composer.report.constants.ComposerReportMessageConstants;
import com.kms.katalon.composer.report.constants.ImageConstants;
import com.kms.katalon.composer.report.constants.StringConstants;
import com.kms.katalon.composer.report.dialog.AdvancedSearchTestLogDialog;
import com.kms.katalon.composer.report.integration.ReportComposerIntegrationFactory;
import com.kms.katalon.composer.report.parts.ReportPart;
import com.kms.katalon.composer.report.parts.integration.ReportTestCaseIntegrationViewBuilder;
import com.kms.katalon.composer.report.parts.integration.TestCaseChangedEventListener;
import com.kms.katalon.composer.report.parts.integration.TestCaseLogDetailsIntegrationView;
import com.kms.katalon.composer.report.parts.integration.TestLogIntegrationColumn;
import com.kms.katalon.composer.report.provider.ReportPartTestStepLabelProvider;
import com.kms.katalon.composer.report.provider.ReportTestStepTableViewerFilter;
import com.kms.katalon.composer.report.provider.ReportTestStepTreeViewer;
import com.kms.katalon.composer.report.provider.ReportTreeTableContentProvider;
import com.kms.katalon.constants.GlobalStringConstants;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.TestCaseController;
import com.kms.katalon.core.logging.model.ILogRecord;
import com.kms.katalon.core.logging.model.MessageLogRecord;
import com.kms.katalon.core.logging.model.TestCaseLogRecord;
import com.kms.katalon.core.logging.model.TestSuiteLogRecord;
import com.kms.katalon.core.util.internal.DateUtil;
import com.kms.katalon.core.util.internal.PathUtil;
import com.kms.katalon.core.webui.util.OSUtil;
import com.kms.katalon.entity.report.ReportEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;
import org.osgi.framework.Bundle;

public class ReportPartTestLogView {
    private static final int IMAGE_VIEW_TAB_ITEM_IDX = 1;
    private Button btnFilterTestStepInfo;
    private Button btnFilterTestStepPassed;
    private Button btnFilterTestStepFailed;
    private Button btnFilterTestStepError;
    private Button btnFilterTestStepIncomplete;
    private Button btnFilterTestStepWarning;
    private Button btnFilterTestStepNotRun;
    private StyledText txtTestLogSearch;
    private CLabel lblTestLogSearch;
    private CLabel lblTestLogAdvancedSearch;
    private ReportTestStepTreeViewer treeViewerTestSteps;
    private StyledText txtSTestCaseId;
    private StyledText txtSTestCaseStartTime;
    private StyledText txtSTestCaseEndTime;
    private StyledText txtSTestCaseElapsedTime;
    private StyledText txtSTestCaseDescription;
    private StyledText txtSTestCaseMessage;
    private Composite compositeTestCaseLogIntegration;
    private ToolBar testCaseLogIntegrationToolbar;
    private Composite compositeSTLInformation;
    private StyledText txtSTLStartTime;
    private StyledText txtSTLEndTime;
    private StyledText txtSTLElapsedTime;
    private StyledText txtSTLDescription;
    private StyledText txtSTLMessage;
    private StyledText txtSTLName;
    private ScrolledComposite compositeSTLSImageView;
    private Canvas selectedTestLogCanvas;
    private Image selectedTestLogImage;
    private Image drawnImage;
    private StyledText txtSTLStackTrace;
    private ReportPart parentPart;
    private TestCaseLogDetailsIntegrationView selectedReportTestCaseIntegrationView;
    private ToolItem tltmCollapseAllLogs;
    private ToolItem tltmExpandAllLogs;
    private ReportTestStepTableViewerFilter testStepFilter;
    private boolean isSearching;
    private ToolBar testLogToolbar;
    private CTabFolder tabFolder;
    private CTabItem tbtmTestLog;
    private Composite compositeTestCaseInformation;
    private List<TestCaseChangedEventListener> testCaseChangedEventListeners;
    private ToolItem tltmResetImageSize;
    private ToolItem tltmFitScreen;
    private CTabFolder selectedTestLogTabFolder;
    private ToolBar imageToolbar;
    private ImageScreenMode imageScreenMode = ImageScreenMode.FIT_SCREEN;

    public ReportPartTestLogView(ReportPart parentPart) {
        this.parentPart = parentPart;
        this.isSearching = false;
        this.testCaseChangedEventListeners = new ArrayList<TestCaseChangedEventListener>();
    }

    public void registerControlModifyListener() {
        this.compositeTestCaseInformation.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                ReportPartTestLogView.this.compositeTestCaseInformation.layout(true, true);
            }
        });
        this.compositeSTLInformation.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                ReportPartTestLogView.this.compositeSTLInformation.layout(true, true);
            }
        });
        this.compositeSTLSImageView.addListener(37, new Listener(){

            public void handleEvent(Event event) {
                int wheelCount = event.count;
                wheelCount = (int)Math.ceil((float)wheelCount / 3.0f);
                while (wheelCount < 0) {
                    ReportPartTestLogView.this.compositeSTLSImageView.getVerticalBar().setIncrement(4);
                    ++wheelCount;
                }
                while (wheelCount > 0) {
                    ReportPartTestLogView.this.compositeSTLSImageView.getVerticalBar().setIncrement(-4);
                    --wheelCount;
                }
            }
        });
        this.treeViewerTestSteps.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ReportPartTestLogView.this.updateSelectedTestStep(ReportPartTestLogView.this.getSelectedTestStep());
            }
        });
        this.treeViewerTestSteps.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection thisSelection;
                Object selectedNode;
                TreeViewer viewer;
                viewer.setExpandedState(selectedNode, !(viewer = (TreeViewer)event.getViewer()).getExpandedState(selectedNode = (thisSelection = (IStructuredSelection)event.getSelection()).getFirstElement()));
            }
        });
        this.tltmCollapseAllLogs.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReportPartTestLogView.this.treeViewerTestSteps.getTree().setRedraw(false);
                ReportPartTestLogView.this.treeViewerTestSteps.collapseAll();
                ReportPartTestLogView.this.treeViewerTestSteps.getTree().setRedraw(true);
            }
        });
        this.tltmExpandAllLogs.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReportPartTestLogView.this.treeViewerTestSteps.expandAll();
            }
        });
        this.btnFilterTestStepInfo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReportPartTestLogView.this.testStepFilter.showInfo(ReportPartTestLogView.this.btnFilterTestStepInfo.getSelection());
                ReportPartTestLogView.this.treeViewerTestSteps.refresh(true);
                ReportPartTestLogView.this.updateSelectedTestStep(ReportPartTestLogView.this.getSelectedTestStep());
            }
        });
        this.btnFilterTestStepPassed.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReportPartTestLogView.this.testStepFilter.showPassed(ReportPartTestLogView.this.btnFilterTestStepPassed.getSelection());
                ReportPartTestLogView.this.treeViewerTestSteps.refresh(true);
                ReportPartTestLogView.this.updateSelectedTestStep(ReportPartTestLogView.this.getSelectedTestStep());
            }
        });
        this.btnFilterTestStepFailed.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReportPartTestLogView.this.testStepFilter.showFailed(ReportPartTestLogView.this.btnFilterTestStepFailed.getSelection());
                ReportPartTestLogView.this.treeViewerTestSteps.refresh(true);
                ReportPartTestLogView.this.updateSelectedTestStep(ReportPartTestLogView.this.getSelectedTestStep());
            }
        });
        this.btnFilterTestStepError.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReportPartTestLogView.this.testStepFilter.showError(ReportPartTestLogView.this.btnFilterTestStepError.getSelection());
                ReportPartTestLogView.this.treeViewerTestSteps.refresh(true);
                ReportPartTestLogView.this.updateSelectedTestStep(ReportPartTestLogView.this.getSelectedTestStep());
            }
        });
        this.btnFilterTestStepIncomplete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReportPartTestLogView.this.testStepFilter.showIncomplete(ReportPartTestLogView.this.btnFilterTestStepIncomplete.getSelection());
                ReportPartTestLogView.this.treeViewerTestSteps.refresh(true);
                ReportPartTestLogView.this.updateSelectedTestStep(ReportPartTestLogView.this.getSelectedTestStep());
            }
        });
        this.btnFilterTestStepWarning.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReportPartTestLogView.this.testStepFilter.showWarning(ReportPartTestLogView.this.btnFilterTestStepWarning.getSelection());
                ReportPartTestLogView.this.treeViewerTestSteps.refresh(true);
                ReportPartTestLogView.this.updateSelectedTestStep(ReportPartTestLogView.this.getSelectedTestStep());
            }
        });
        this.btnFilterTestStepNotRun.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReportPartTestLogView.this.testStepFilter.showNotRun(ReportPartTestLogView.this.btnFilterTestStepNotRun.getSelection());
                ReportPartTestLogView.this.treeViewerTestSteps.refresh(true);
                ReportPartTestLogView.this.updateSelectedTestStep(ReportPartTestLogView.this.getSelectedTestStep());
            }
        });
        this.txtTestLogSearch.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    ReportPartTestLogView.this.filterTestStepBySearchedText();
                }
            }
        });
        this.lblTestLogSearch.addListener(4, new Listener(){

            public void handleEvent(Event event) {
                if (ReportPartTestLogView.this.isSearching) {
                    ReportPartTestLogView.this.txtTestLogSearch.setText("");
                }
                ReportPartTestLogView.this.filterTestStepBySearchedText();
            }
        });
        this.lblTestLogAdvancedSearch.addListener(4, new Listener(){

            public void handleEvent(Event event) {
                Shell shell = new Shell(ReportPartTestLogView.this.lblTestLogAdvancedSearch.getShell().getDisplay());
                Point pt = ReportPartTestLogView.this.lblTestLogAdvancedSearch.toDisplay(1, 1);
                shell.setSize(0, 0);
                AdvancedSearchTestLogDialog dialog = new AdvancedSearchTestLogDialog(shell);
                shell.setLocation(pt.x - shell.getBounds().width - 52, pt.y + shell.getBounds().height + 52);
                if (dialog.open() == 0 && ReportPartTestLogView.this.isSearching) {
                    ReportPartTestLogView.this.treeViewerTestSteps.refresh(false);
                }
            }
        });
        this.tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ReportPartTestLogView.this.tabFolder.getSelection() == ReportPartTestLogView.this.tbtmTestLog) {
                    ReportPartTestLogView.this.testLogToolbar.setVisible(true);
                } else {
                    ReportPartTestLogView.this.testLogToolbar.setVisible(false);
                }
            }
        });
        this.tltmFitScreen.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReportPartTestLogView.this.imageScreenMode = ImageScreenMode.FIT_SCREEN;
                ReportPartTestLogView.this.drawImage();
            }
        });
        this.tltmResetImageSize.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReportPartTestLogView.this.imageScreenMode = ImageScreenMode.FULL_SIZE;
                ReportPartTestLogView.this.tltmFitScreen.setSelection(false);
                ReportPartTestLogView.this.drawImage();
            }
        });
        this.selectedTestLogTabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReportPartTestLogView.this.imageToolbar.setVisible(ReportPartTestLogView.this.selectedTestLogTabFolder.getSelectionIndex() == 1);
            }
        });
    }

    private void drawImage() {
        if (this.drawnImage == null) {
            return;
        }
        switch (this.imageScreenMode) {
            case FIT_SCREEN: {
                this.tltmFitScreen.setSelection(true);
                this.tltmResetImageSize.setSelection(false);
                Rectangle bounds = this.compositeSTLSImageView.getClientArea();
                this.drawnImage = ImageUtil.resize((Image)this.selectedTestLogImage, (int)bounds.width, (int)bounds.height);
                this.compositeSTLSImageView.setMinSize(new Point(this.drawnImage.getBounds().width, this.drawnImage.getBounds().height));
                this.selectedTestLogCanvas.redraw();
                break;
            }
            case FULL_SIZE: {
                this.tltmFitScreen.setSelection(false);
                this.tltmResetImageSize.setSelection(true);
                this.drawnImage = this.selectedTestLogImage;
                this.compositeSTLSImageView.setMinSize(new Point(this.drawnImage.getBounds().width, this.drawnImage.getBounds().height));
                this.selectedTestLogCanvas.redraw();
            }
        }
    }

    private ILogRecord getSelectedTestStep() {
        StructuredSelection selection = (StructuredSelection)this.treeViewerTestSteps.getSelection();
        if (selection == null || selection.size() != 1) {
            return null;
        }
        return (ILogRecord)selection.getFirstElement();
    }

    private void filterTestStepBySearchedText() {
        this.isSearching = !this.txtTestLogSearch.getText().isEmpty();
        this.treeViewerTestSteps.setSearchedString(this.txtTestLogSearch.getText());
        this.treeViewerTestSteps.refresh(true);
        this.updateStatusSearchLabel();
    }

    private void updateStatusSearchLabel() {
        if (this.isSearching) {
            this.lblTestLogSearch.setImage(com.kms.katalon.composer.components.impl.constants.ImageConstants.IMG_16_CLOSE_SEARCH);
            this.lblTestLogSearch.setToolTipText(GlobalStringConstants.CLEAR);
        } else {
            this.lblTestLogSearch.setImage(com.kms.katalon.composer.components.impl.constants.ImageConstants.IMG_16_SEARCH);
            this.lblTestLogSearch.setToolTipText(GlobalStringConstants.SEARCH);
        }
    }

    public Composite createCompositeTestStepTree(SashForm sashFormDetails) {
        Composite compositeTestLogTree = new Composite((Composite)sashFormDetails, 2048);
        GridLayout glCompositeTestLogTree = new GridLayout(1, false);
        glCompositeTestLogTree.marginWidth = 0;
        glCompositeTestLogTree.marginHeight = 0;
        compositeTestLogTree.setLayout((Layout)glCompositeTestLogTree);
        Composite compositeTestLogTreeHeader = new Composite(compositeTestLogTree, 0);
        compositeTestLogTreeHeader.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        GridLayout glCompositeTestLogTreeHeader = new GridLayout(1, false);
        glCompositeTestLogTreeHeader.marginTop = 5;
        compositeTestLogTreeHeader.setLayout((Layout)glCompositeTestLogTreeHeader);
        Label lblTestCaseLog = new Label(compositeTestLogTreeHeader, 0);
        lblTestCaseLog.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        lblTestCaseLog.setText("Test Case's Log");
        this.parentPart.setLabelToBeBold(lblTestCaseLog);
        Composite compositeTestCaseLogTreeDetails = new Composite(compositeTestLogTree, 0);
        compositeTestCaseLogTreeDetails.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        GridLayout glCompositeTestCaseLogTreeDetails = new GridLayout(1, false);
        glCompositeTestCaseLogTreeDetails.marginWidth = 0;
        glCompositeTestCaseLogTreeDetails.marginHeight = 0;
        compositeTestCaseLogTreeDetails.setLayout((Layout)glCompositeTestCaseLogTreeDetails);
        this.tabFolder = new CTabFolder(compositeTestCaseLogTreeDetails, 0);
        this.tabFolder.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.tabFolder.setSelectionBackground(Display.getCurrent().getSystemColor(35));
        this.createTestLogTabItem(this.tabFolder);
        this.createTestCaseInformationTabItem(this.tabFolder);
        this.createTestCaseIntegrationTabItem(this.tabFolder);
        return compositeTestLogTree;
    }

    private Button createFilteringButton(Composite parent, String name, Image image, boolean defaultSeletion) {
        Button filteringButton = new Button(parent, 32);
        filteringButton.setText(StringUtils.defaultIfEmpty((String)name, (String)""));
        if (image != null) {
            filteringButton.setImage(image);
        }
        filteringButton.setSelection(defaultSeletion);
        return filteringButton;
    }

    private void createCompositeFilterTestLog(Composite parent) {
        Composite compositeTestLogFilter = new Composite(parent, 0);
        compositeTestLogFilter.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        GridLayout glCompositeTestLogFilter = new GridLayout(2, false);
        glCompositeTestLogFilter.marginWidth = 0;
        glCompositeTestLogFilter.marginHeight = 0;
        compositeTestLogFilter.setLayout((Layout)glCompositeTestLogFilter);
        Composite compositeFilterDetails = new Composite(compositeTestLogFilter, 0);
        compositeFilterDetails.setLayoutData((Object)new GridData(4, 4, false, false, 2, 1));
        compositeFilterDetails.setLayout((Layout)new GridLayout(7, false));
        this.btnFilterTestStepInfo = this.createFilteringButton(compositeFilterDetails, StringConstants.INFO, ImageConstants.IMG_16_INFO, true);
        this.btnFilterTestStepPassed = this.createFilteringButton(compositeFilterDetails, StringConstants.PASSED, ImageConstants.IMG_16_PASSED, true);
        this.btnFilterTestStepFailed = this.createFilteringButton(compositeFilterDetails, StringConstants.FAILED, ImageConstants.IMG_16_FAILED, true);
        this.btnFilterTestStepError = this.createFilteringButton(compositeFilterDetails, StringConstants.ERROR, ImageConstants.IMG_16_ERROR, true);
        this.btnFilterTestStepIncomplete = this.createFilteringButton(compositeFilterDetails, StringConstants.INCOMPLETE, ImageConstants.IMG_16_INCOMPLETE, true);
        this.btnFilterTestStepWarning = this.createFilteringButton(compositeFilterDetails, StringConstants.WARN, ImageConstants.IMG_16_WARNING, true);
        this.btnFilterTestStepNotRun = this.createFilteringButton(compositeFilterDetails, StringConstants.NOT_RUN, ImageConstants.IMG_16_NOT_RUN, true);
        Composite compositeTestLogSearch = new Composite(compositeTestLogFilter, 2048);
        compositeTestLogSearch.setBackground(ColorUtil.getWhiteBackgroundColor());
        compositeTestLogSearch.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        GridLayout glCompositeTestLogSearch = new GridLayout(3, false);
        glCompositeTestLogSearch.verticalSpacing = 0;
        glCompositeTestLogSearch.horizontalSpacing = 0;
        glCompositeTestLogSearch.marginWidth = 0;
        glCompositeTestLogSearch.marginHeight = 0;
        compositeTestLogSearch.setLayout((Layout)glCompositeTestLogSearch);
        this.txtTestLogSearch = new StyledText(compositeTestLogSearch, 4);
        GridData gdTxtTestCaseSearch = new GridData(768);
        gdTxtTestCaseSearch.grabExcessVerticalSpace = true;
        gdTxtTestCaseSearch.verticalAlignment = 0x1000000;
        this.txtTestLogSearch.setLayoutData((Object)gdTxtTestCaseSearch);
        StyledTextMessage styledTextMessage = new StyledTextMessage(this.txtTestLogSearch);
        styledTextMessage.setMessage(StringConstants.PA_SEARCH_TEXT_DEFAULT_VALUE);
        Canvas cvsTestLogSearch = new Canvas(compositeTestLogSearch, 0);
        GridLayout glCvsTestLogSearch = new GridLayout(3, false);
        glCvsTestLogSearch.horizontalSpacing = 0;
        glCvsTestLogSearch.marginWidth = 0;
        glCvsTestLogSearch.marginHeight = 0;
        cvsTestLogSearch.setLayout((Layout)glCvsTestLogSearch);
        this.lblTestLogSearch = new CLabel((Composite)cvsTestLogSearch, 0);
        this.lblTestLogSearch.setCursor(new Cursor((Device)Display.getCurrent(), 21));
        this.updateStatusSearchLabel();
        Label lblSeparator = new Label((Composite)cvsTestLogSearch, 2);
        GridData gdLblSeparator = new GridData(16384, 0x1000000, false, false, 1, 1);
        gdLblSeparator.heightHint = 18;
        lblSeparator.setLayoutData((Object)gdLblSeparator);
        this.lblTestLogAdvancedSearch = new CLabel((Composite)cvsTestLogSearch, 0);
        this.lblTestLogAdvancedSearch.setCursor(new Cursor((Device)Display.getCurrent(), 21));
        this.lblTestLogAdvancedSearch.setImage(com.kms.katalon.composer.components.impl.constants.ImageConstants.IMG_16_ADVANCED_SEARCH);
        this.updateStatusSearchLabel();
        this.createTestLogTableToolbar(compositeTestLogFilter);
    }

    private Display getDisplay() {
        return this.parentPart.getDisplay();
    }

    private void createTestLogTableToolbar(Composite parent) {
        this.testLogToolbar = new ToolBar(parent, 0);
        this.testLogToolbar.setForeground(ColorUtil.getToolBarForegroundColor());
        this.testLogToolbar.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.tltmCollapseAllLogs = new ToolItem(this.testLogToolbar, 0);
        this.tltmCollapseAllLogs.setToolTipText("Collapse All Logs");
        this.tltmCollapseAllLogs.setImage(ImageUtil.loadImage((Bundle)Platform.getBundle((String)"org.eclipse.ui"), (String)"icons/full/elcl16/collapseall.png"));
        this.tltmExpandAllLogs = new ToolItem(this.testLogToolbar, 0);
        this.tltmExpandAllLogs.setToolTipText("Expand All Logs");
        this.tltmExpandAllLogs.setImage(ImageUtil.loadImage((Bundle)Platform.getBundle((String)"org.eclipse.ui"), (String)"icons/full/elcl16/expandall.png"));
    }

    private void createTestLogTable(Composite parent) {
        Composite compositeTestLogTable = new Composite(parent, 0);
        compositeTestLogTable.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.tbtmTestLog.setControl((Control)parent);
        TreeColumnLayout tclCompositeTestLogTable = new TreeColumnLayout();
        compositeTestLogTable.setLayout((Layout)tclCompositeTestLogTable);
        this.treeViewerTestSteps = new ReportTestStepTreeViewer(compositeTestLogTable, 65536);
        Tree treeTestCaseLog = this.treeViewerTestSteps.getTree();
        treeTestCaseLog.setLinesVisible(ControlUtils.shouldLineVisble((Display)treeTestCaseLog.getDisplay()));
        treeTestCaseLog.setHeaderVisible(true);
        TreeViewerColumn treeViewerColumnLogItem = new TreeViewerColumn((TreeViewer)this.treeViewerTestSteps, 0);
        TreeColumn trclmnTestLogItem = treeViewerColumnLogItem.getColumn();
        trclmnTestLogItem.setText("Item");
        tclCompositeTestLogTable.setColumnData((Widget)trclmnTestLogItem, (ColumnLayoutData)new ColumnWeightData(45, 200));
        treeViewerColumnLogItem.setLabelProvider((CellLabelProvider)new ReportPartTestStepLabelProvider(0, this));
        TreeViewerColumn treeViewerColumnLogDescription = new TreeViewerColumn((TreeViewer)this.treeViewerTestSteps, 0);
        TreeColumn trclmnTestLogDescription = treeViewerColumnLogDescription.getColumn();
        trclmnTestLogDescription.setText("Description");
        tclCompositeTestLogTable.setColumnData((Widget)trclmnTestLogDescription, (ColumnLayoutData)new ColumnWeightData(30, 170));
        treeViewerColumnLogDescription.setLabelProvider((CellLabelProvider)new ReportPartTestStepLabelProvider(1, this));
        TreeViewerColumn treeViewerColumnElapsedTime = new TreeViewerColumn((TreeViewer)this.treeViewerTestSteps, 0);
        TreeColumn trclmnTestLogElapsedTime = treeViewerColumnElapsedTime.getColumn();
        trclmnTestLogElapsedTime.setText("Elapsed");
        tclCompositeTestLogTable.setColumnData((Widget)trclmnTestLogElapsedTime, (ColumnLayoutData)new ColumnWeightData(0, 80));
        treeViewerColumnElapsedTime.setLabelProvider((CellLabelProvider)new ReportPartTestStepLabelProvider(2, this));
        TreeViewerColumn treeViewerColumnAttachment = new TreeViewerColumn((TreeViewer)this.treeViewerTestSteps, 0);
        TreeColumn trclmnTestLogAttachment = treeViewerColumnAttachment.getColumn();
        trclmnTestLogAttachment.setText("");
        trclmnTestLogAttachment.setImage(ImageConstants.IMG_16_ATTACHMENT);
        tclCompositeTestLogTable.setColumnData((Widget)trclmnTestLogAttachment, (ColumnLayoutData)new ColumnWeightData(0, 40));
        treeViewerColumnAttachment.setLabelProvider((CellLabelProvider)new ReportPartTestStepLabelProvider(3, this));
        this.createTestLogIntegrationColumns(tclCompositeTestLogTable);
        this.treeViewerTestSteps.setContentProvider((IContentProvider)new ReportTreeTableContentProvider());
        this.treeViewerTestSteps.getTree().setToolTipText("");
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.treeViewerTestSteps);
        this.testStepFilter = new ReportTestStepTableViewerFilter();
        this.treeViewerTestSteps.addFilter(this.testStepFilter);
        this.testStepFilter.showInfo(this.btnFilterTestStepInfo.getSelection());
        this.testStepFilter.showPassed(this.btnFilterTestStepPassed.getSelection());
        this.testStepFilter.showFailed(this.btnFilterTestStepFailed.getSelection());
        this.testStepFilter.showError(this.btnFilterTestStepError.getSelection());
        this.testStepFilter.showIncomplete(this.btnFilterTestStepIncomplete.getSelection());
        this.testStepFilter.showWarning(this.btnFilterTestStepWarning.getSelection());
        this.testStepFilter.showNotRun(this.btnFilterTestStepNotRun.getSelection());
    }

    private void createTestLogIntegrationColumns(TreeColumnLayout tableLayout) {
        ReportEntity report = this.getReport();
        for (ReportTestCaseIntegrationViewBuilder builder : ReportComposerIntegrationFactory.getInstance().getSortedBuilder()) {
            TestLogIntegrationColumn testLogIntegrationColumn;
            if (!builder.isIntegrationEnabled(ProjectController.getInstance().getCurrentProject()) || (testLogIntegrationColumn = builder.getTestLogIntegrationColumn(report, this.parentPart.getTestSuiteLogRecord())) == null) continue;
            TreeViewerColumn viewerColumn = (TreeViewerColumn)testLogIntegrationColumn.createIntegrationColumn((ColumnViewer)this.treeViewerTestSteps, this.treeViewerTestSteps.getTree().getColumnCount());
            tableLayout.setColumnData((Widget)viewerColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(0, 32));
            this.testCaseChangedEventListeners.add(testLogIntegrationColumn);
        }
    }

    private void createTestLogTabItem(CTabFolder tabFolder) {
        this.tbtmTestLog = new CTabItem(tabFolder, 0);
        this.tbtmTestLog.setText("Test Log");
        Composite compositeTestLog = new Composite((Composite)tabFolder, 0);
        compositeTestLog.setLayout((Layout)new GridLayout(1, false));
        this.createCompositeFilterTestLog(compositeTestLog);
        this.createTestLogTable(compositeTestLog);
        tabFolder.setSelection(0);
    }

    private void createTestCaseInformationTabItem(CTabFolder tabFolder) {
        CTabItem tbtmGeneralInformation = new CTabItem(tabFolder, 0);
        tbtmGeneralInformation.setText(ComposerReportMessageConstants.LBL_INFORMATION);
        this.compositeTestCaseInformation = new Composite((Composite)tabFolder, 0);
        tbtmGeneralInformation.setControl((Control)this.compositeTestCaseInformation);
        this.compositeTestCaseInformation.setBackground(ColorUtil.getWhiteBackgroundColor());
        GridLayout glCompositeTestCaseInformation = new GridLayout(6, false);
        glCompositeTestCaseInformation.verticalSpacing = 7;
        glCompositeTestCaseInformation.horizontalSpacing = 15;
        this.compositeTestCaseInformation.setLayout((Layout)glCompositeTestCaseInformation);
        Label lblSTestCaseId = new Label(this.compositeTestCaseInformation, 0);
        lblSTestCaseId.setText("Test Case ID");
        this.parentPart.setLabelToBeBold(lblSTestCaseId);
        this.txtSTestCaseId = new StyledText(this.compositeTestCaseInformation, 0);
        this.txtSTestCaseId.setLayoutData((Object)new GridData(4, 4, true, false, 5, 1));
        Label lblSTCStart = new Label(this.compositeTestCaseInformation, 0);
        lblSTCStart.setText("Start");
        this.parentPart.setLabelToBeBold(lblSTCStart);
        this.txtSTestCaseStartTime = new StyledText(this.compositeTestCaseInformation, 8);
        this.txtSTestCaseStartTime.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        Label lblSTCEndTime = new Label(this.compositeTestCaseInformation, 0);
        lblSTCEndTime.setText("End");
        this.parentPart.setLabelToBeBold(lblSTCEndTime);
        this.txtSTestCaseEndTime = new StyledText(this.compositeTestCaseInformation, 8);
        this.txtSTestCaseEndTime.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        Label lblSTCElapsedTime = new Label(this.compositeTestCaseInformation, 0);
        lblSTCElapsedTime.setText("Elapsed");
        this.parentPart.setLabelToBeBold(lblSTCElapsedTime);
        this.txtSTestCaseElapsedTime = new StyledText(this.compositeTestCaseInformation, 8);
        this.txtSTestCaseElapsedTime.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        Label lblSTCDescription = new Label(this.compositeTestCaseInformation, 0);
        lblSTCDescription.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        lblSTCDescription.setText("Description");
        this.parentPart.setLabelToBeBold(lblSTCDescription);
        this.txtSTestCaseDescription = new StyledText(this.compositeTestCaseInformation, 584);
        this.txtSTestCaseDescription.setLayoutData((Object)new GridData(4, 4, true, true, 5, 1));
        this.txtSTestCaseDescription.setMarginColor(ColorUtil.getTextPlaceholderColor());
        this.enableMargin(this.txtSTestCaseDescription, false);
        Label lblSTCMessage = new Label(this.compositeTestCaseInformation, 0);
        lblSTCMessage.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        lblSTCMessage.setText("Message");
        this.parentPart.setLabelToBeBold(lblSTCMessage);
        this.txtSTestCaseMessage = new StyledText(this.compositeTestCaseInformation, 584);
        this.txtSTestCaseMessage.setLayoutData((Object)new GridData(4, 4, true, true, 5, 1));
        this.txtSTestCaseMessage.setMarginColor(ColorUtil.getTextPlaceholderColor());
        this.enableMargin(this.txtSTestCaseMessage, false);
    }

    private void createTestCaseIntegrationTabItem(CTabFolder tabFolder) {
        CTabItem tbtmTestCaseIntegration = new CTabItem(tabFolder, 0);
        tbtmTestCaseIntegration.setText("Integration");
        Composite compositeTestCaseIntegration = new Composite((Composite)tabFolder, 0);
        tbtmTestCaseIntegration.setControl((Control)compositeTestCaseIntegration);
        compositeTestCaseIntegration.setBackground(ColorUtil.getWhiteBackgroundColor());
        GridLayout glCompositeTestCaseIntegration = new GridLayout(2, false);
        glCompositeTestCaseIntegration.horizontalSpacing = 20;
        compositeTestCaseIntegration.setLayout((Layout)glCompositeTestCaseIntegration);
        Composite compositeTestCaseIntegrationToolbar = new Composite(compositeTestCaseIntegration, 0);
        compositeTestCaseIntegrationToolbar.setLayout((Layout)new FillLayout(256));
        compositeTestCaseIntegrationToolbar.setLayoutData((Object)new GridData(16384, 4, false, true, 1, 1));
        this.testCaseLogIntegrationToolbar = new ToolBar(compositeTestCaseIntegrationToolbar, 0x800200);
        this.testCaseLogIntegrationToolbar.setForeground(ColorUtil.getToolBarForegroundColor());
        this.compositeTestCaseLogIntegration = new Composite(compositeTestCaseIntegration, 0);
        this.compositeTestCaseLogIntegration.setLayout((Layout)new FillLayout(256));
        this.compositeTestCaseLogIntegration.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
    }

    public Composite createCompositeSelectedTestLog(SashForm sashFormDetails) {
        Composite compositeTestCaseSelectedLog = new Composite((Composite)sashFormDetails, 2048);
        compositeTestCaseSelectedLog.setLayout((Layout)new FillLayout(256));
        this.selectedTestLogTabFolder = new CTabFolder(compositeTestCaseSelectedLog, 2048);
        this.createSelectedTestStepInformationTabItem(this.selectedTestLogTabFolder);
        this.createSelectedTestStepImageViewTabItem(this.selectedTestLogTabFolder);
        this.imageToolbar = new ToolBar((Composite)this.selectedTestLogTabFolder, 0);
        this.imageToolbar.setForeground(ColorUtil.getToolBarForegroundColor());
        this.tltmFitScreen = new ToolItem(this.imageToolbar, 32);
        this.tltmFitScreen.setImage(ImageConstants.IMG_16_FIT_SCREEN);
        this.tltmFitScreen.setToolTipText("Fit to View");
        this.tltmResetImageSize = new ToolItem(this.imageToolbar, 32);
        this.tltmResetImageSize.setImage(ImageConstants.IMG_16_FULL_SIZE);
        this.tltmResetImageSize.setToolTipText("Show Full Size");
        this.selectedTestLogTabFolder.setTopRight((Control)this.imageToolbar);
        this.imageToolbar.setVisible(this.selectedTestLogTabFolder.getSelectionIndex() == 1);
        return compositeTestCaseSelectedLog;
    }

    private void createSelectedTestStepInformationTabItem(CTabFolder tabFolder) {
        CTabItem tbtmSTLInformation = new CTabItem(tabFolder, 0);
        tbtmSTLInformation.setText(ComposerReportMessageConstants.LBL_INFORMATION);
        this.compositeSTLInformation = new Composite((Composite)tabFolder, 0);
        tbtmSTLInformation.setControl((Control)this.compositeSTLInformation);
        GridLayout glCompositeSTLInformation = new GridLayout(6, false);
        glCompositeSTLInformation.horizontalSpacing = 15;
        this.compositeSTLInformation.setLayout((Layout)glCompositeSTLInformation);
        this.compositeSTLInformation.setBackground(ColorUtil.getWhiteBackgroundColor());
        Label lblSTLName = new Label(this.compositeSTLInformation, 0);
        lblSTLName.setText("Name");
        this.parentPart.setLabelToBeBold(lblSTLName);
        this.txtSTLName = new StyledText(this.compositeSTLInformation, 8);
        this.txtSTLName.setLayoutData((Object)new GridData(4, 4, true, false, 5, 1));
        Label lblSTLStart = new Label(this.compositeSTLInformation, 0);
        lblSTLStart.setText("Start");
        this.parentPart.setLabelToBeBold(lblSTLStart);
        this.txtSTLStartTime = new StyledText(this.compositeSTLInformation, 8);
        this.txtSTLStartTime.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        Label lblSTLEndTime = new Label(this.compositeSTLInformation, 0);
        lblSTLEndTime.setText("End");
        this.parentPart.setLabelToBeBold(lblSTLEndTime);
        this.txtSTLEndTime = new StyledText(this.compositeSTLInformation, 8);
        this.txtSTLEndTime.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        Label lblSTLElapsedTime = new Label(this.compositeSTLInformation, 0);
        lblSTLElapsedTime.setText("Elapsed");
        this.parentPart.setLabelToBeBold(lblSTLElapsedTime);
        this.txtSTLElapsedTime = new StyledText(this.compositeSTLInformation, 8);
        this.txtSTLElapsedTime.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        Label lblSTLDescription = new Label(this.compositeSTLInformation, 0);
        lblSTLDescription.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        lblSTLDescription.setText("Description");
        this.parentPart.setLabelToBeBold(lblSTLDescription);
        this.txtSTLDescription = new StyledText(this.compositeSTLInformation, 584);
        this.txtSTLDescription.setLayoutData((Object)new GridData(4, 4, true, true, 5, 1));
        this.txtSTLDescription.setMarginColor(ColorUtil.getTextPlaceholderColor());
        this.enableMargin(this.txtSTLDescription, false);
        Label lblSTLMessage = new Label(this.compositeSTLInformation, 0);
        lblSTLMessage.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        lblSTLMessage.setText("Message");
        this.parentPart.setLabelToBeBold(lblSTLMessage);
        this.txtSTLMessage = new StyledText(this.compositeSTLInformation, 584);
        this.txtSTLMessage.setLayoutData((Object)new GridData(4, 4, true, true, 5, 1));
        this.txtSTLMessage.setMarginColor(ColorUtil.getTextPlaceholderColor());
        this.enableMargin(this.txtSTLMessage, false);
        tabFolder.setSelection(0);
    }

    private void createSelectedTestStepStackTraceTabItem(CTabFolder tabFolder) {
        CTabItem tbtmSTLStackStrace = new CTabItem(tabFolder, 0);
        tbtmSTLStackStrace.setText("Stack Trace");
        Composite compositeSTLStackTrace = new Composite((Composite)tabFolder, 0);
        tbtmSTLStackStrace.setControl((Control)compositeSTLStackTrace);
        compositeSTLStackTrace.setLayout((Layout)new FillLayout(256));
        compositeSTLStackTrace.setBackground(ColorUtil.getWhiteBackgroundColor());
        this.txtSTLStackTrace = new StyledText(compositeSTLStackTrace, 0);
    }

    private void createSelectedTestStepImageViewTabItem(CTabFolder tabFolder) {
        CTabItem tbtmSTLImageView = new CTabItem(tabFolder, 0);
        tbtmSTLImageView.setText("Image");
        this.compositeSTLSImageView = new ScrolledComposite((Composite)tabFolder, 768);
        this.compositeSTLSImageView.setExpandVertical(true);
        this.compositeSTLSImageView.setExpandHorizontal(true);
        tbtmSTLImageView.setControl((Control)this.compositeSTLSImageView);
        this.compositeSTLSImageView.setLayout((Layout)new FillLayout(256));
        this.compositeSTLSImageView.setBackground(ColorUtil.getWhiteBackgroundColor());
        this.selectedTestLogCanvas = new Canvas((Composite)this.compositeSTLSImageView, 0);
        this.selectedTestLogCanvas.setBackground(ColorUtil.getWhiteBackgroundColor());
        this.selectedTestLogCanvas.setLayout((Layout)new FillLayout(256));
        this.selectedTestLogCanvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (ReportPartTestLogView.this.drawnImage != null && !ReportPartTestLogView.this.drawnImage.isDisposed()) {
                    e.gc.drawImage(ReportPartTestLogView.this.drawnImage, 0, 0);
                }
            }
        });
        this.compositeSTLSImageView.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                ReportPartTestLogView.this.selectedTestLogCanvas.redraw();
                ReportPartTestLogView.this.drawImage();
            }
        });
        this.compositeSTLSImageView.setContent((Control)this.selectedTestLogCanvas);
    }

    public void loadTestCaseIntegrationToolbar(ReportEntity report, TestSuiteLogRecord testSuiteLogRecord) {
        this.clearTestCaseIntegrationToolbar();
        for (Map.Entry<String, TestCaseLogDetailsIntegrationView> builderEntry : this.parentPart.getIntegratingCompositeMap().entrySet()) {
            if (builderEntry.getValue() == null) continue;
            ToolItem item = new ToolItem(this.testCaseLogIntegrationToolbar, 32);
            item.setText(builderEntry.getKey());
        }
        ToolItem[] toolItemArray = this.testCaseLogIntegrationToolbar.getItems();
        int n = toolItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            ToolItem item = toolItemArray[n2];
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ToolItem toolItem = (ToolItem)e.getSource();
                    if (toolItem.getSelection()) {
                        ReportPartTestLogView.this.changeTestCaseIntegrationContainer(toolItem.getText());
                    } else {
                        ReportPartTestLogView.this.clearTestCaseIntegrationContainer();
                    }
                }
            });
            ++n2;
        }
        if (this.testCaseLogIntegrationToolbar.getItems().length > 0) {
            this.testCaseLogIntegrationToolbar.getItems()[0].setSelection(true);
            this.changeTestCaseIntegrationContainer(this.testCaseLogIntegrationToolbar.getItems()[0].getText());
        }
    }

    private void changeTestCaseIntegrationContainer(String productName) {
        ToolItem[] toolItemArray = this.testCaseLogIntegrationToolbar.getItems();
        int n = toolItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            ToolItem item = toolItemArray[n2];
            if (!productName.equals(item.getText())) {
                item.setSelection(false);
            }
            ++n2;
        }
        this.clearTestCaseIntegrationContainer();
        this.selectedReportTestCaseIntegrationView = this.parentPart.getIntegratingCompositeMap().get(productName);
        if (this.selectedReportTestCaseIntegrationView == null) {
            return;
        }
        this.selectedReportTestCaseIntegrationView.createContainer(this.compositeTestCaseLogIntegration);
        this.compositeTestCaseLogIntegration.layout(true, true);
        if (this.parentPart.getSelectedTestCaseLogRecord() != null) {
            this.selectedReportTestCaseIntegrationView.changeTestCase((TestCaseLogRecord)this.parentPart.getSelectedTestCaseLogRecord());
        }
    }

    private void clearTestCaseIntegrationContainer() {
        while (this.compositeTestCaseLogIntegration.getChildren().length > 0) {
            this.compositeTestCaseLogIntegration.getChildren()[0].dispose();
        }
    }

    private void clearTestCaseIntegrationToolbar() {
        while (this.testCaseLogIntegrationToolbar.getItems().length > 0) {
            this.testCaseLogIntegrationToolbar.getItems()[0].dispose();
        }
    }

    public void updateSelectedTestCase(ILogRecord selectedLogRecord) {
        this.parentPart.clearMouseDownListener(this.txtSTestCaseId);
        if (selectedLogRecord != null && selectedLogRecord.getId() != null) {
            this.txtSTestCaseId.setText(selectedLogRecord.getId());
            this.clickToOpenTestCaseListener(this.txtSTestCaseId);
        } else {
            this.txtSTestCaseId.setText("");
        }
        if (selectedLogRecord != null && selectedLogRecord.getStartTime() > 0L) {
            this.txtSTestCaseStartTime.setText(DateUtil.getDateTimeFormatted((long)selectedLogRecord.getStartTime()));
        } else {
            this.txtSTestCaseStartTime.setText("");
        }
        if (selectedLogRecord != null && selectedLogRecord.getEndTime() > 0L) {
            this.txtSTestCaseEndTime.setText(DateUtil.getDateTimeFormatted((long)selectedLogRecord.getEndTime()));
        } else {
            this.txtSTestCaseEndTime.setText("");
        }
        if (selectedLogRecord != null && selectedLogRecord.getStartTime() > 0L && selectedLogRecord.getEndTime() > 0L) {
            this.txtSTestCaseElapsedTime.setText(DateUtil.getElapsedTime((long)selectedLogRecord.getStartTime(), (long)selectedLogRecord.getEndTime()));
            StyledString txtSTLElapsedStyleString = new StyledString(this.txtSTestCaseElapsedTime.getText(), StyledString.COUNTER_STYLER);
            this.txtSTestCaseElapsedTime.setStyleRanges(txtSTLElapsedStyleString.getStyleRanges());
        } else {
            this.txtSTestCaseElapsedTime.setText("");
        }
        if (selectedLogRecord != null && selectedLogRecord.getDescription() != null && !selectedLogRecord.getDescription().isEmpty()) {
            this.txtSTestCaseDescription.setText(StringEscapeUtils.unescapeJava((String)selectedLogRecord.getDescription()));
            this.enableMargin(this.txtSTestCaseDescription, true);
        } else {
            this.txtSTestCaseDescription.setText("");
            this.enableMargin(this.txtSTestCaseDescription, false);
        }
        if (selectedLogRecord != null && selectedLogRecord.getMessage() != null) {
            this.txtSTestCaseMessage.setText(selectedLogRecord.getMessage());
            this.enableMargin(this.txtSTestCaseMessage, true);
        } else {
            this.txtSTestCaseMessage.setText("");
            this.enableMargin(this.txtSTestCaseMessage, false);
        }
        this.compositeTestCaseInformation.layout();
        for (TestCaseChangedEventListener listener : this.testCaseChangedEventListeners) {
            listener.changeTestCase((TestCaseLogRecord)selectedLogRecord);
        }
        if (selectedLogRecord != null) {
            this.treeViewerTestSteps.setInput(selectedLogRecord.getChildRecords());
        } else {
            this.treeViewerTestSteps.setInput(null);
        }
        if (OSUtil.isMacBigSurOrLater()) {
            this.treeViewerTestSteps.getTree().redraw();
        }
        if (this.selectedReportTestCaseIntegrationView != null) {
            this.selectedReportTestCaseIntegrationView.changeTestCase((TestCaseLogRecord)this.parentPart.getSelectedTestCaseLogRecord());
        }
        this.updateSelectedTestStep(null);
    }

    private void clickToOpenTestCaseListener(StyledText styleText) {
        StyleRange range = new StyleRange();
        range.start = 0;
        range.length = styleText.getText().length();
        range.underline = true;
        range.data = styleText.getText();
        range.underlineStyle = 4;
        range.foreground = ColorUtil.getHyperlinkTextColor();
        styleText.setStyleRanges(new StyleRange[]{range});
        styleText.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                try {
                    StyledText styleText = (StyledText)event.widget;
                    int offset = styleText.getOffsetAtLocation(new Point(event.x, event.y));
                    StyleRange style = styleText.getStyleRangeAtOffset(offset);
                    if (style != null && style.underline && style.underlineStyle == 4) {
                        TestCaseEntity testCaseEntity = TestCaseController.getInstance().getTestCaseByDisplayId((String)style.data);
                        if (testCaseEntity != null) {
                            EventBrokerSingleton.getInstance().getEventBroker().post("TESTCASE/OPEN", (Object)testCaseEntity);
                        } else {
                            MessageDialog.openWarning(null, (String)StringConstants.WARN, (String)"Test case not found.");
                        }
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (Exception exception) {
                    MessageDialog.openWarning(null, (String)StringConstants.WARN, (String)"Test case not found.");
                }
            }
        });
    }

    public void updateSelectedTestStep(ILogRecord selectedLogRecord) {
        this.parentPart.clearMouseDownListener(this.txtSTLName);
        if (selectedLogRecord != null && selectedLogRecord.getName() != null) {
            this.txtSTLName.setText(selectedLogRecord.getName());
            if (selectedLogRecord instanceof TestCaseLogRecord) {
                this.clickToOpenTestCaseListener(this.txtSTLName);
            }
        } else {
            this.txtSTLName.setText("");
        }
        if (selectedLogRecord != null && selectedLogRecord.getStartTime() > 0L) {
            this.txtSTLStartTime.setText(DateUtil.getDateTimeFormatted((long)selectedLogRecord.getStartTime()));
        } else {
            this.txtSTLStartTime.setText("");
        }
        if (selectedLogRecord != null && selectedLogRecord.getEndTime() > 0L) {
            this.txtSTLEndTime.setText(DateUtil.getDateTimeFormatted((long)selectedLogRecord.getEndTime()));
        } else {
            this.txtSTLEndTime.setText("");
        }
        if (selectedLogRecord != null && selectedLogRecord.getStartTime() > 0L && selectedLogRecord.getEndTime() > 0L) {
            this.txtSTLElapsedTime.setText(DateUtil.getElapsedTime((long)selectedLogRecord.getStartTime(), (long)selectedLogRecord.getEndTime()));
            StyledString txtSTLElapsedStyleString = new StyledString(this.txtSTLElapsedTime.getText(), StyledString.COUNTER_STYLER);
            this.txtSTLElapsedTime.setStyleRanges(txtSTLElapsedStyleString.getStyleRanges());
        } else {
            this.txtSTLElapsedTime.setText("");
        }
        if (selectedLogRecord != null && StringUtils.isNotEmpty((String)selectedLogRecord.getDescription())) {
            this.txtSTLDescription.setText(StringEscapeUtils.unescapeJava((String)selectedLogRecord.getDescription()));
            this.enableMargin(this.txtSTLDescription, true);
        } else {
            this.txtSTLDescription.setText("");
            this.enableMargin(this.txtSTLDescription, false);
        }
        if (selectedLogRecord != null && StringUtils.isNotEmpty((String)selectedLogRecord.getMessage())) {
            this.txtSTLMessage.setText(selectedLogRecord.getMessage());
            this.enableMargin(this.txtSTLMessage, true);
        } else {
            this.txtSTLMessage.setText("");
            this.enableMargin(this.txtSTLMessage, false);
        }
        this.compositeSTLInformation.layout();
        if (this.selectedTestLogImage != null) {
            this.drawnImage.dispose();
            this.selectedTestLogImage.dispose();
        }
        if (selectedLogRecord != null && selectedLogRecord instanceof MessageLogRecord) {
            MessageLogRecord messageLog = (MessageLogRecord)selectedLogRecord;
            if (messageLog.getAttachment() != null) {
                this.drawnImage = this.selectedTestLogImage = new Image((Device)this.selectedTestLogCanvas.getDisplay(), PathUtil.relativeToAbsolutePath((String)messageLog.getAttachment(), (String)this.getReport().getLocation()));
            }
        } else {
            this.compositeSTLSImageView.setMinSize(0, 0);
        }
        this.selectedTestLogCanvas.getParent().layout(true, true);
        this.selectedTestLogCanvas.redraw();
    }

    public ReportEntity getReport() {
        return this.parentPart.getReport();
    }

    public void enableMargin(StyledText styledText, boolean enable) {
        styledText.setRedraw(false);
        if (enable) {
            styledText.getVerticalBar().setVisible(true);
            styledText.setTopMargin(1);
            styledText.setBottomMargin(1);
            styledText.setLeftMargin(1);
        } else {
            styledText.getVerticalBar().setVisible(false);
            styledText.setTopMargin(0);
            styledText.setBottomMargin(0);
            styledText.setLeftMargin(0);
        }
        styledText.setRedraw(true);
        styledText.layout(true);
    }

    private static enum ImageScreenMode {
        FIT_SCREEN,
        FULL_SIZE;

    }
}

