/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.report.provider;

import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.report.constants.ImageConstants;
import com.kms.katalon.composer.report.provider.ReportTestCaseTreeViewer;
import com.kms.katalon.core.logging.model.ILogRecord;
import com.kms.katalon.core.logging.model.TestCaseGroupLogRecord;
import com.kms.katalon.core.logging.model.TestCaseLogRecord;
import com.kms.katalon.core.util.internal.DateUtil;
import com.kms.katalon.util.NameUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;

public class ReportPartTestCaseLabelProvider
extends StyledCellLabelProvider {
    public static final int CLMN_TEST_CASE_ORDER = 0;
    public static final int CLMN_TEST_CASE_NAME = 1;
    public static final int CLMN_TEST_RESOLUTION = 2;
    public static final int CLMN_TEST_CASE_VIDEO = 3;
    public static final int CLMN_TEST_CASE_INTEGRATION = 4;
    private static String WEB_ELEMENT_NOT_FOUND_EXCEPTION = "com.kms.katalon.core.webui.exception.WebElementNotFoundException";

    public Image getImage(Object element, int columnIndex) {
        if (element == null || !(element instanceof ILogRecord)) {
            return null;
        }
        switch (columnIndex) {
            case 1: {
                ILogRecord logRecord = (ILogRecord)element;
                switch (logRecord.getStatus().getStatusValue()) {
                    case ERROR: {
                        return ImageConstants.IMG_16_ERROR;
                    }
                    case FAILED: {
                        return ImageConstants.IMG_16_FAILED;
                    }
                    case PASSED: {
                        return ImageConstants.IMG_16_PASSED;
                    }
                    case INCOMPLETE: {
                        return ImageConstants.IMG_16_INCOMPLETE;
                    }
                    case SKIPPED: {
                        return ImageConstants.IMG_16_SKIPPED;
                    }
                }
            }
        }
        return null;
    }

    private int getOrder(ILogRecord[] testCaseLogRecords, ILogRecord testCaseLogRecord) {
        int index = 0;
        while (index < testCaseLogRecords.length) {
            if (testCaseLogRecord.equals(testCaseLogRecords[index])) {
                return index + 1;
            }
            ++index;
        }
        return 0;
    }

    private StyledString getText(ILogRecord logRecord, int columnIndex, boolean isShortened) {
        StyledString styledString = new StyledString();
        switch (columnIndex) {
            case 0: {
                ILogRecord parentLogRecord = logRecord.getParentLogRecord();
                ILogRecord[] logRecords = parentLogRecord != null ? parentLogRecord.getChildRecords() : (ILogRecord[])this.getViewer().getInput();
                styledString.append(Integer.toString(this.getOrder(logRecords, logRecord)));
                break;
            }
            case 2: {
                if (logRecord.getMessage().contains(WEB_ELEMENT_NOT_FOUND_EXCEPTION)) {
                    styledString.append("Click here to fix broken Test Object");
                    break;
                }
                styledString.append("Click here to open AUT when test failed");
                break;
            }
            case 1: {
                String eslapsedTime;
                String testCaseId = logRecord.getName();
                String testCaseName = testCaseId.substring(testCaseId.lastIndexOf("/") + 1, testCaseId.length());
                if (isShortened && testCaseName.length() > 30) {
                    testCaseName = NameUtil.shortenNameMiddle((String)testCaseName, (int)17, (int)24);
                }
                styledString.append(testCaseName);
                TestCaseLogRecord testCaseLog = (TestCaseLogRecord)logRecord;
                String iterationVariableValue = testCaseLog.getIterationVariableValue();
                if (StringUtils.isNotEmpty((String)iterationVariableValue)) {
                    if (isShortened && iterationVariableValue.length() > 30) {
                        styledString.append("/" + NameUtil.shortenNameMiddle((String)iterationVariableValue, (int)17, (int)24), StyledString.COUNTER_STYLER);
                    } else {
                        styledString.append("/" + iterationVariableValue, StyledString.COUNTER_STYLER);
                    }
                }
                if (StringUtils.isBlank((String)(eslapsedTime = DateUtil.getElapsedTime((long)logRecord.getStartTime(), (long)logRecord.getEndTime())))) break;
                styledString.append(" (" + eslapsedTime + ")", StyledString.COUNTER_STYLER);
                break;
            }
        }
        return styledString;
    }

    public void update(ViewerCell cell) {
        if (cell.getElement() != null) {
            cell.setImage(this.getImage(cell.getElement(), cell.getColumnIndex()));
            ArrayList<StyleRange> range = new ArrayList<StyleRange>();
            StyledString styledString = this.getText((ILogRecord)cell.getElement(), cell.getColumnIndex(), false);
            cell.setText(styledString.toString());
            range.addAll(Arrays.asList(styledString.getStyleRanges()));
            if (cell.getColumnIndex() == 1) {
                ReportTestCaseTreeViewer treeViewer;
                String searchedString;
                TextLayout textLayout = new TextLayout((Device)cell.getControl().getDisplay());
                textLayout.setText(styledString.toString());
                Tree table = (Tree)this.getViewer().getControl();
                TreeColumn column = table.getColumn(cell.getColumnIndex());
                if (textLayout.getBounds().width + 5 > column.getWidth()) {
                    styledString = this.getText((ILogRecord)cell.getElement(), cell.getColumnIndex(), true);
                    range.clear();
                    range.addAll(Arrays.asList(styledString.getStyleRanges()));
                    cell.setText(styledString.toString());
                }
                if (!(searchedString = (treeViewer = (ReportTestCaseTreeViewer)this.getViewer()).getSearchedString().toLowerCase().trim()).isEmpty()) {
                    Matcher m = Pattern.compile(Pattern.quote(searchedString)).matcher(cell.getText().toLowerCase());
                    while (m.find()) {
                        StyleRange myStyledRange = new StyleRange(m.start(), searchedString.length(), null, ColorUtil.getHighlightBackgroundColor());
                        range.add(myStyledRange);
                    }
                }
            }
            if (cell.getColumnIndex() == 2) {
                Font boldFont;
                TextStyle linkTextStyle = new TextStyle();
                linkTextStyle.underline = true;
                FontDescriptor boldDescriptor = FontDescriptor.createFrom((FontData)new FontData()).setStyle(1);
                linkTextStyle.font = boldFont = boldDescriptor.createFont((Device)Display.getCurrent());
                linkTextStyle.foreground = Display.getCurrent().getSystemColor(9);
                StyleRange linkRange = new StyleRange(linkTextStyle);
                linkRange.start = 0;
                linkRange.length = cell.getText().length();
                range.add(linkRange);
            }
            cell.setStyleRanges(range.toArray(new StyleRange[0]));
        }
        super.update(cell);
    }

    public String getToolTipText(Object element) {
        String toolTip = null;
        if (element instanceof TestCaseLogRecord) {
            TestCaseGroupLogRecord logRecord = (TestCaseGroupLogRecord)element;
            String testCaseName = logRecord.getName().substring(logRecord.getName().lastIndexOf("/") + 1, logRecord.getName().length());
            String elapsedTime = DateUtil.getElapsedTime((long)logRecord.getStartTime(), (long)logRecord.getEndTime());
            String iterationVariableValue = logRecord.getIterationVariableValue();
            toolTip = StringUtils.isBlank((String)iterationVariableValue) ? String.valueOf(testCaseName) + " (" + elapsedTime + ")" : String.valueOf(testCaseName) + "/" + logRecord.getIterationVariableValue() + " (" + elapsedTime + ")";
        }
        return toolTip;
    }
}

