/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.editor;

import com.kms.katalon.composer.components.impl.constants.TextContentType;
import com.kms.katalon.composer.components.impl.editors.MirrorEditor;
import com.kms.katalon.composer.components.impl.handler.DocumentReadyHandler;
import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.composer.webservice.constants.ComposerWebserviceMessageConstants;
import com.kms.katalon.composer.webservice.editor.HttpBodyEditor;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.entity.webservice.GraphQLBodyContent;
import com.kms.katalon.entity.webservice.GraphQLQuery;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class GraphQLBodyEditor
extends HttpBodyEditor {
    private GraphQLBodyContent graphQLBodyContent;
    private MirrorEditor mirrorEditor;
    private MirrorEditor variableEditor;
    private Button chckWrapLine;
    private Button chckAutoUpdateContentType;
    Composite tbBodyType;

    public GraphQLBodyEditor(Composite parent, int style) {
        super(parent, style);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.setLayout((Layout)gridLayout);
        this.setLayoutData(new GridData(768));
        ComponentBuilder.label((Composite)this).text("Query").bold();
        ComponentBuilder.label((Composite)this).text("Query Variables").bold();
        this.mirrorEditor = new MirrorEditor((Composite)this, 0);
        this.mirrorEditor.registerDocumentHandler(new DocumentReadyHandler(){

            public void onDocumentReady() {
                GraphQLBodyEditor.this.handleControlModifyListener();
            }
        });
        this.mirrorEditor.addListener(24, this.modifyListener());
        this.variableEditor = new MirrorEditor((Composite)this, 0);
        this.variableEditor.registerDocumentHandler(new DocumentReadyHandler(){

            public void onDocumentReady() {
                GraphQLBodyEditor.this.handleVariableControlModifyListener();
            }
        });
        this.variableEditor.addListener(24, this.modifyListener());
        Composite bottomComposite = new Composite((Composite)this, 0);
        GridLayout bottomLayout = new GridLayout(1, false);
        bottomLayout.marginHeight = 0;
        bottomLayout.marginWidth = 0;
        bottomComposite.setLayout((Layout)bottomLayout);
        bottomComposite.setLayoutData((Object)new GridData(768));
        this.chckWrapLine = (Button)ComponentBuilder.button((Composite)bottomComposite, (int)32).text(ComposerWebserviceMessageConstants.PA_LBL_WRAP_LINE).check().build();
    }

    private void handleControlModifyListener() {
        this.chckWrapLine.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GraphQLBodyEditor.this.mirrorEditor.wrapLine(GraphQLBodyEditor.this.chckWrapLine.getSelection());
            }
        });
        if (this.graphQLBodyContent != null) {
            this.mirrorEditor.setText(this.graphQLBodyContent.getDisplayText());
            this.mirrorEditor.setText(this.getViewModel().getText());
        }
    }

    private void handleVariableControlModifyListener() {
        this.chckWrapLine.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GraphQLBodyEditor.this.variableEditor.wrapLine(GraphQLBodyEditor.this.chckWrapLine.getSelection());
            }
        });
        if (this.graphQLBodyContent != null && StringUtils.isNotBlank((CharSequence)this.graphQLBodyContent.getDisplayVariables())) {
            this.variableEditor.setText(this.graphQLBodyContent.getDisplayVariables());
        }
    }

    @Override
    public String getContentType() {
        return this.getViewModel().getContentType();
    }

    @Override
    public String getContentData() {
        String content = (String)this.mirrorEditor.evaluate("return editor.getValue();");
        this.graphQLBodyContent.setDisplayText(content);
        content = StringUtils.normalizeSpace((String)content);
        GraphQLQuery qlQuery = new GraphQLQuery(content);
        String variables = (String)this.variableEditor.evaluate("return editor.getValue();");
        this.graphQLBodyContent.setDisplayVariables(variables);
        if (!StringUtils.isBlank((CharSequence)variables)) {
            variables = StringUtils.normalizeSpace((String)variables);
            qlQuery.setVariables(variables);
        }
        content = JsonUtil.toJson((Object)qlQuery);
        this.graphQLBodyContent.setText(content);
        this.updateViewModel();
        return this.getViewModel().getContentData();
    }

    @Override
    public void setInput(String rawBodyContentData) {
        this.graphQLBodyContent = StringUtils.isEmpty((CharSequence)rawBodyContentData) ? new GraphQLBodyContent() : (GraphQLBodyContent)JsonUtil.fromJson((String)rawBodyContentData, GraphQLBodyContent.class);
        this.graphQLBodyContent.setContentType(TextContentType.JSON.getContentType());
        this.mirrorEditor.changeMode(TextContentType.JSON.getText());
        this.variableEditor.changeMode(TextContentType.JSON.getText());
        this.updateViewModel();
    }

    @Override
    public void onBodyTypeChanged() {
        if (this.graphQLBodyContent == null) {
            this.graphQLBodyContent = new GraphQLBodyContent();
        }
        this.updateViewModel();
        this.setContentTypeUpdated(true);
    }

    @Override
    public void setContentTypeUpdated(boolean contentTypeUpdated) {
        if (this.chckAutoUpdateContentType != null) {
            boolean autoUpdateContentTypeEnabled = this.chckAutoUpdateContentType.getSelection();
            this.getViewModel().setUserAllowsAutoUpdateContentType(autoUpdateContentTypeEnabled);
        }
        super.setContentTypeUpdated(contentTypeUpdated);
    }

    private void updateViewModel() {
        this.getViewModel().setText(this.graphQLBodyContent.getDisplayText());
        this.getViewModel().setContentType(this.graphQLBodyContent.getContentType());
        this.getViewModel().setContentData(JsonUtil.toJson((Object)this.graphQLBodyContent));
    }

    private Listener modifyListener() {
        return new Listener(){

            public void handleEvent(Event event) {
                GraphQLBodyEditor.this.notifyListeners(24, new Event());
            }
        };
    }
}

