/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.editor;

import com.kms.katalon.composer.webservice.editor.FileBodyEditor;
import com.kms.katalon.composer.webservice.editor.FormDataBodyEditor;
import com.kms.katalon.composer.webservice.editor.GraphQLBodyEditor;
import com.kms.katalon.composer.webservice.editor.HttpBodyEditor;
import com.kms.katalon.composer.webservice.editor.NoContentBodyEditor;
import com.kms.katalon.composer.webservice.editor.TextBodyEditor;
import com.kms.katalon.composer.webservice.editor.UrlEncodedBodyEditor;
import com.kms.katalon.composer.webservice.parts.RestServicePart;
import com.kms.katalon.composer.webservice.viewmodel.HttpBodyEditorCompositeViewModel;
import com.kms.katalon.entity.repository.WebServiceRequestEntity;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;

public class HttpBodyEditorComposite
extends Composite {
    private static final String NONE = "none";
    private Map<String, HttpBodyEditor> bodyEditors = new HashMap<String, HttpBodyEditor>();
    private Map<String, Button> bodySelectionButtons = new HashMap<String, Button>();
    private Button tltmNone;
    private Button tltmText;
    private Button tltmUrlEncoded;
    private Button tltmFormData;
    private Button tltmBinary;
    private Button tltmGraphQL;
    private StackLayout slBodyContent;
    private HttpBodyEditorCompositeViewModel viewModel;
    private RestServicePart servicePart;
    private String selectedBodyType;
    private boolean isInputReady;

    public HttpBodyEditorComposite(Composite parent, int style, RestServicePart servicePart) {
        super(parent, style);
        this.servicePart = servicePart;
        this.setLayout((Layout)new GridLayout());
        Composite bodyTypeComposite = new Composite((Composite)this, 0);
        bodyTypeComposite.setLayoutData((Object)new GridData(768));
        GridLayout glBodyType = new GridLayout(2, false);
        glBodyType.marginHeight = 0;
        glBodyType.marginWidth = 0;
        bodyTypeComposite.setLayout((Layout)glBodyType);
        Composite tbBodyType = new Composite(bodyTypeComposite, 0);
        tbBodyType.setLayout((Layout)new GridLayout(6, false));
        this.tltmNone = new Button(tbBodyType, 16);
        this.tltmNone.setText(NONE);
        this.bodySelectionButtons.put(NONE, this.tltmNone);
        this.tltmText = new Button(tbBodyType, 16);
        this.tltmText.setText("text");
        this.bodySelectionButtons.put("text", this.tltmText);
        this.tltmUrlEncoded = new Button(tbBodyType, 16);
        this.tltmUrlEncoded.setText("x-www-form-urlencoded");
        this.bodySelectionButtons.put("x-www-form-urlencoded", this.tltmUrlEncoded);
        this.tltmFormData = new Button(tbBodyType, 16);
        this.tltmFormData.setText("form-data");
        this.bodySelectionButtons.put("form-data", this.tltmFormData);
        this.tltmBinary = new Button(tbBodyType, 16);
        this.tltmBinary.setText("file");
        this.bodySelectionButtons.put("file", this.tltmBinary);
        this.tltmGraphQL = new Button(tbBodyType, 16);
        this.tltmGraphQL.setText("GraphQL");
        this.bodySelectionButtons.put("GraphQL", this.tltmGraphQL);
        Composite bodyContentComposite = new Composite((Composite)this, 0);
        bodyContentComposite.setLayoutData((Object)new GridData(1808));
        this.slBodyContent = new StackLayout();
        bodyContentComposite.setLayout((Layout)this.slBodyContent);
        NoContentBodyEditor noContentBodyEditor = new NoContentBodyEditor(bodyContentComposite, 0);
        this.bodyEditors.put(NONE, noContentBodyEditor);
        TextBodyEditor textBodyEditor = new TextBodyEditor(bodyContentComposite, 0);
        this.bodyEditors.put("text", textBodyEditor);
        UrlEncodedBodyEditor urlEncodedEditor = new UrlEncodedBodyEditor(bodyContentComposite, 0);
        this.bodyEditors.put("x-www-form-urlencoded", urlEncodedEditor);
        FormDataBodyEditor formDataEditor = new FormDataBodyEditor(bodyContentComposite, 0);
        this.bodyEditors.put("form-data", formDataEditor);
        FileBodyEditor fileBodyEditor = new FileBodyEditor(bodyContentComposite, 0);
        this.bodyEditors.put("file", fileBodyEditor);
        GraphQLBodyEditor graphQLBodyEditor = new GraphQLBodyEditor(bodyContentComposite, 0);
        this.bodyEditors.put("GraphQL", graphQLBodyEditor);
        this.handleControlModifyListeners();
    }

    private void migrateFromOldVersion(WebServiceRequestEntity requestEntity) {
        if (StringUtils.isEmpty((CharSequence)requestEntity.getHttpBodyContent()) && StringUtils.isNotEmpty((CharSequence)requestEntity.getHttpBody())) {
            this.selectedBodyType = "text";
        }
    }

    public void setInput(WebServiceRequestEntity requestEntity) {
        this.isInputReady = false;
        this.viewModel = new HttpBodyEditorCompositeViewModel();
        this.viewModel.setModel(requestEntity);
        this.migrateFromOldVersion(this.viewModel.getModel());
        this.selectedBodyType = (String)StringUtils.defaultIfEmpty((CharSequence)this.viewModel.getModel().getHttpBodyType(), (CharSequence)NONE);
        Button selectedButton = this.bodySelectionButtons.get(this.selectedBodyType);
        if (this.bodyEditors.get(this.selectedBodyType) != null) {
            this.bodyEditors.get(this.selectedBodyType).setContentTypeUpdated(this.viewModel.getModel().isAutoUpdateContent());
            this.bodyEditors.get(this.selectedBodyType).setInput(this.viewModel.getModel().getHttpBodyContent());
            selectedButton.setSelection(true);
            selectedButton.notifyListeners(13, new Event());
        }
        this.isInputReady = true;
    }

    private void handleControlModifyListeners() {
        SelectionAdapter bodyTypeSelectedListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button source = (Button)e.getSource();
                HttpBodyEditorComposite.this.selectedBodyType = source.getText();
                HttpBodyEditor httpBodyEditor = HttpBodyEditorComposite.this.bodyEditors.get(HttpBodyEditorComposite.this.selectedBodyType);
                httpBodyEditor.onBodyTypeChanged();
                HttpBodyEditorComposite.this.slBodyContent.topControl = httpBodyEditor;
                httpBodyEditor.getParent().layout();
                if (!HttpBodyEditorComposite.this.isInputReady) {
                    return;
                }
                HttpBodyEditorComposite.this.servicePart.setDirty(true);
                HttpBodyEditorComposite.this.updateContentTypeByEditor(httpBodyEditor);
            }
        };
        this.bodySelectionButtons.values().forEach(button -> button.addSelectionListener((SelectionListener)bodyTypeSelectedListener));
        this.bodyEditors.values().forEach(editor -> editor.addListener(24, event -> {
            if (this.isInputReady) {
                this.servicePart.setDirty(true);
                this.updateContentTypeByEditor((HttpBodyEditor)((Object)editor));
            }
        }));
    }

    private void updateContentTypeByEditor(HttpBodyEditor editor) {
        if (this.selectedBodyType.equals(NONE)) {
            this.viewModel.removeContentTypeProperty();
            this.servicePart.updateHeaders(this.viewModel.getModel());
        } else {
            this.viewModel.getModel().setAutoUpdateContent(editor.isContentTypeUpdated());
            if (editor.isContentTypeUpdated()) {
                this.viewModel.updateContentTypeByEditorViewModel(editor.getViewModel());
                this.servicePart.updateHeaders(this.viewModel.getModel());
            }
        }
    }

    public boolean isAutoUpdateContent() {
        return this.viewModel.getModel().isAutoUpdateContent();
    }

    public String getHttpBodyType() {
        if (!this.isNoContent()) {
            return this.selectedBodyType;
        }
        return "";
    }

    public String getHttpBodyContent() {
        return this.bodyEditors.get(this.selectedBodyType).getContentData();
    }

    private boolean isNoContent() {
        return NONE.equals(this.selectedBodyType);
    }
}

