/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.editor;

import com.kms.katalon.composer.components.impl.constants.TextContentType;
import com.kms.katalon.composer.components.impl.editors.MirrorEditor;
import com.kms.katalon.composer.components.impl.handler.DocumentReadyHandler;
import com.kms.katalon.composer.webservice.constants.ComposerWebserviceMessageConstants;
import com.kms.katalon.composer.webservice.editor.HttpBodyEditor;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.entity.webservice.TextBodyContent;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class TextBodyEditor
extends HttpBodyEditor {
    private TextBodyContent textBodyContent;
    private MirrorEditor mirrorEditor;
    private Button chckWrapLine;
    private Button chckAutoUpdateContentType;
    Composite tbBodyType;
    private Map<String, Button> TEXT_MODE_SELECTION_BUTTONS = new HashMap<String, Button>();
    private static final String[] TEXT_MODE_NAMES = TextContentType.getTextValues();

    public TextBodyEditor(Composite parent, int style) {
        super(parent, style);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.setLayout((Layout)gridLayout);
        this.mirrorEditor = new MirrorEditor((Composite)this, 0);
        this.mirrorEditor.registerDocumentHandler(new DocumentReadyHandler(){

            public void onDocumentReady() {
                TextBodyEditor.this.handleControlModifyListener();
            }
        });
        this.mirrorEditor.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                TextBodyEditor.this.notifyListeners(24, new Event());
            }
        });
        Composite bottomComposite = new Composite((Composite)this, 0);
        GridLayout bottomLayout = new GridLayout(3, false);
        bottomLayout.marginHeight = 0;
        bottomLayout.marginWidth = 0;
        bottomComposite.setLayout((Layout)bottomLayout);
        bottomComposite.setLayoutData((Object)new GridData(768));
        this.tbBodyType = new Composite(bottomComposite, 0);
        this.tbBodyType.setLayout((Layout)new GridLayout(TEXT_MODE_NAMES.length, false));
        Arrays.asList(TextContentType.values()).forEach(textContentType -> {
            Button btnTextMode = new Button(this.tbBodyType, 16);
            btnTextMode.setText(textContentType.getText());
            this.TEXT_MODE_SELECTION_BUTTONS.put(textContentType.getText(), btnTextMode);
            btnTextMode.addSelectionListener((SelectionListener)new SelectionAdapter((TextContentType)textContentType){
                private final /* synthetic */ TextContentType val$textContentType;
                {
                    this.val$textContentType = textContentType;
                }

                public void widgetSelected(SelectionEvent e) {
                    TextBodyEditor.this.mirrorEditor.changeMode(this.val$textContentType.getText());
                    if (TextBodyEditor.this.textBodyContent != null) {
                        boolean isSelected = TextBodyEditor.this.chckAutoUpdateContentType.getSelection();
                        TextBodyEditor.this.setContentTypeUpdated(isSelected);
                        TextBodyEditor.this.textBodyContent.setContentType(this.val$textContentType.getContentType());
                        TextBodyEditor.this.updateViewModel();
                    }
                    TextBodyEditor.this.notifyListeners(24, new Event());
                }
            });
        });
        this.chckWrapLine = new Button(bottomComposite, 32);
        this.chckWrapLine.setText(ComposerWebserviceMessageConstants.PA_LBL_WRAP_LINE);
        this.chckWrapLine.setSelection(true);
        this.chckAutoUpdateContentType = new Button(bottomComposite, 32);
        this.chckAutoUpdateContentType.setText(ComposerWebserviceMessageConstants.PA_LBL_AUTO_UPDATE_CONTENT_TYPE);
        this.chckAutoUpdateContentType.setSelection(this.getViewModel().isContentTypeUpdated());
        this.chckAutoUpdateContentType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean isSelected = TextBodyEditor.this.chckAutoUpdateContentType.getSelection();
                if (isSelected) {
                    TextBodyEditor.this.updateViewModel();
                }
                TextBodyEditor.this.setContentTypeUpdated(isSelected);
                TextBodyEditor.this.notifyListeners(24, new Event());
            }
        });
    }

    private void handleControlModifyListener() {
        this.chckWrapLine.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TextBodyEditor.this.mirrorEditor.wrapLine(TextBodyEditor.this.chckWrapLine.getSelection());
            }
        });
        if (this.textBodyContent != null) {
            this.mirrorEditor.setText(this.textBodyContent.getText());
            this.mirrorEditor.setText(this.getViewModel().getText());
        }
    }

    @Override
    public String getContentType() {
        return this.getViewModel().getContentType();
    }

    @Override
    public String getContentData() {
        this.textBodyContent.setText((String)this.mirrorEditor.evaluate("return editor.getValue();"));
        this.updateViewModel();
        return this.getViewModel().getContentData();
    }

    @Override
    public void setInput(String rawBodyContentData) {
        this.textBodyContent = StringUtils.isEmpty((CharSequence)rawBodyContentData) ? new TextBodyContent() : (TextBodyContent)JsonUtil.fromJson((String)rawBodyContentData, TextBodyContent.class);
        this.chckAutoUpdateContentType.setSelection(this.getViewModel().isContentTypeUpdated());
        this.updateViewModel();
        this.updateRadioStatus();
    }

    @Override
    public void onBodyTypeChanged() {
        if (this.textBodyContent == null) {
            this.textBodyContent = new TextBodyContent();
        }
        this.updateViewModel();
    }

    @Override
    public void setContentTypeUpdated(boolean contentTypeUpdated) {
        if (this.chckAutoUpdateContentType != null) {
            boolean autoUpdateContentTypeEnabled = this.chckAutoUpdateContentType.getSelection();
            this.getViewModel().setUserAllowsAutoUpdateContentType(autoUpdateContentTypeEnabled);
        }
        super.setContentTypeUpdated(contentTypeUpdated);
    }

    private void updateRadioStatus() {
        TextContentType preferedContentType = TextContentType.evaluateContentType((String)this.getViewModel().getContentType());
        Button selectionButton = this.TEXT_MODE_SELECTION_BUTTONS.get(preferedContentType.getText());
        this.TEXT_MODE_SELECTION_BUTTONS.entrySet().forEach(e -> ((Button)e.getValue()).setSelection(false));
        if (selectionButton != null) {
            selectionButton.setSelection(true);
            this.mirrorEditor.changeMode(preferedContentType.getText());
        }
    }

    private void updateViewModel() {
        this.getViewModel().setContentData(JsonUtil.toJson((Object)this.textBodyContent));
        this.getViewModel().setContentType(this.textBodyContent.getContentType());
        this.getViewModel().setText(this.textBodyContent.getText());
    }
}

