/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.handlers;

import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.impl.handler.KSEFeatureAccessHandler;
import com.kms.katalon.composer.components.impl.util.TreeEntityUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.webservice.constants.ComposerWebserviceMessageConstants;
import com.kms.katalon.composer.webservice.constants.StringConstants;
import com.kms.katalon.composer.webservice.openapi.OpenApiImportNode;
import com.kms.katalon.composer.webservice.openapi.OpenApiImporter;
import com.kms.katalon.composer.webservice.openapi.OpenApiProjectImportResult;
import com.kms.katalon.composer.webservice.view.ImportOpenApiDialog;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ObjectRepositoryController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.repository.WebElementEntity;
import com.kms.katalon.entity.repository.WebServiceRequestEntity;
import com.kms.katalon.execution.launcher.manager.LauncherManager;
import com.kms.katalon.feature.FeatureServiceConsumer;
import com.kms.katalon.feature.IFeatureService;
import com.kms.katalon.feature.KSEFeature;
import com.kms.katalon.tracking.service.Trackings;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Named;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ImportOpenApiHandler {
    private IFeatureService featureService = FeatureServiceConsumer.getServiceInstance();

    @CanExecute
    public boolean canExecute() {
        return ProjectController.getInstance().getCurrentProject() != null && !LauncherManager.getInstance().isAnyLauncherRunning();
    }

    @Execute
    public void execute(@Named(value="org.eclipse.ui.selection") @Optional @Named(value="org.eclipse.ui.selection") Object[] selectedObjects, @Named(value="activeShell") @Named(value="activeShell") Shell shell) {
        Trackings.trackClickImportOpenApi3();
        if (this.featureService.canUse(KSEFeature.IMPORT_OPENAPI)) {
            try {
                String selectedFilePath;
                ImportOpenApiDialog dialog = new ImportOpenApiDialog(shell);
                if (dialog.open() == 0 && (selectedFilePath = dialog.getSwaggerSpecLocation()) != null && selectedFilePath.length() > 0) {
                    ITreeEntity parentTreeEntity = ImportOpenApiHandler.findParentTreeEntity(selectedObjects);
                    FolderEntity importFolderEntity = parentTreeEntity == null ? FolderController.getInstance().getObjectRepositoryRoot(ProjectController.getInstance().getCurrentProject()) : (FolderEntity)parentTreeEntity.getObject();
                    OpenApiProjectImportResult projectImportResult = OpenApiImporter.getInstance().importServices(selectedFilePath, importFolderEntity);
                    this.saveImportedArtifacts(projectImportResult);
                    this.getEventBroker().post("EXPLORER/REFRESH_TREE_ENTITY", (Object)TreeEntityUtil.getFolderTreeEntity((FolderEntity)projectImportResult.getFileEntity()));
                    this.getEventBroker().post("EXPLORER/SET_SELECTED_ITEM", (Object)TreeEntityUtil.getFolderTreeEntity((FolderEntity)projectImportResult.getFileEntity()));
                    this.trackImportOpenApi3(selectedFilePath);
                }
            }
            catch (Exception e) {
                if (e.getMessage().contains(ComposerWebserviceMessageConstants.TITLE_INVALID_OPENAPI_FORMAT)) {
                    MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)StringConstants.ERROR, (String)ComposerWebserviceMessageConstants.ERROR_MSG_FAIL_TO_PARSING_OPENAPI);
                } else {
                    MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)StringConstants.ERROR, (String)ComposerWebserviceMessageConstants.ERROR_MSG_FAIL_TO_IMPORT_OPENAPI);
                }
                LoggerSingleton.logError((Throwable)e);
            }
        } else {
            KSEFeatureAccessHandler.handleUnauthorizedAccess((KSEFeature)KSEFeature.IMPORT_OPENAPI);
        }
    }

    private void saveImportedArtifacts(OpenApiProjectImportResult projectImportResult) throws Exception {
        List importNodes = this.flatten(projectImportResult).collect(Collectors.toList());
        for (OpenApiImportNode importNode : importNodes) {
            FileEntity fileEntity = importNode.getFileEntity();
            if (fileEntity != null && fileEntity instanceof FolderEntity) {
                FolderController.getInstance().saveFolder((FolderEntity)fileEntity);
            }
            if (fileEntity == null || !(fileEntity instanceof WebServiceRequestEntity)) continue;
            ObjectRepositoryController.getInstance().saveNewTestObject((WebElementEntity)((WebServiceRequestEntity)fileEntity));
        }
    }

    private Stream<? extends OpenApiImportNode> flatten(OpenApiImportNode importNode) {
        return Stream.concat(Stream.of(importNode), Stream.of(importNode.getChildImportNodes()).flatMap(n -> this.flatten((OpenApiImportNode)n)));
    }

    private IEventBroker getEventBroker() {
        return EventBrokerSingleton.getInstance().getEventBroker();
    }

    public static ITreeEntity findParentTreeEntity(Object[] selectedObjects) throws Exception {
        if (selectedObjects != null) {
            Object[] objectArray = selectedObjects;
            int n = selectedObjects.length;
            int n2 = 0;
            while (n2 < n) {
                Object entity = objectArray[n2];
                if (entity instanceof ITreeEntity) {
                    Object entityObject = ((ITreeEntity)entity).getObject();
                    if (entityObject instanceof FolderEntity) {
                        FolderEntity folder = (FolderEntity)entityObject;
                        if (folder.getFolderType() == FolderEntity.FolderType.WEBELEMENT) {
                            return (ITreeEntity)entity;
                        }
                    } else if (entityObject instanceof WebElementEntity) {
                        return ((ITreeEntity)entity).getParent();
                    }
                }
                ++n2;
            }
        }
        return null;
    }

    private void trackImportOpenApi3(String swaggerSpecLocation) {
        try {
            Paths.get(swaggerSpecLocation, new String[0]);
            Trackings.trackImportOpenApi3((String)"file");
        }
        catch (Throwable e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }
}

