/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.handlers;

import com.kms.katalon.composer.webservice.view.ApiQuickStartPart;
import com.kms.katalon.constants.StringConstants;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.osgi.framework.FrameworkUtil;

public class OpenApiQuickStartHandler {
    private static final String KATALON_BUNDLE_URI = "bundleclass://" + FrameworkUtil.getBundle(ApiQuickStartPart.class).getSymbolicName() + "/";
    private static final String QUICKSTART_PART_URI = String.valueOf(KATALON_BUNDLE_URI) + ApiQuickStartPart.class.getName();
    @Inject
    private MApplication application;
    @Inject
    private EModelService modelService;
    @Inject
    private EPartService partService;

    @Execute
    public void execute() {
        MPartStack stack = (MPartStack)this.modelService.find("com.kms.katalon.composer.content", (MUIElement)this.application);
        if (stack == null) {
            return;
        }
        String partId = this.getPartId();
        MPart mPart = (MPart)this.modelService.find(partId, (MUIElement)this.application);
        if (mPart == null) {
            mPart = (MPart)this.modelService.createModelElement(MPart.class);
            mPart.setElementId(partId);
            mPart.setLabel(StringConstants.PA_QUICKSTART);
            mPart.setContributionURI(this.getContributionURI());
            mPart.setCloseable(true);
            stack.getChildren().add(mPart);
        }
        this.partService.showPart(mPart, EPartService.PartState.ACTIVATE);
        mPart.setVisible(true);
        stack.setSelectedElement((MUIElement)mPart);
    }

    @Inject
    @Optional
    public void execute(@UIEventTopic(value="API/OPEN_QUICK_START_DIALOG") Object eventData) {
        this.execute();
    }

    private String getPartId() {
        return "com.kms.katalon.part.apiQuickStart";
    }

    private String getContributionURI() {
        return QUICKSTART_PART_URI;
    }
}

