/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.importing.model;

import com.kms.katalon.composer.webservice.importing.model.RestMethodImportResult;
import com.kms.katalon.composer.webservice.importing.model.RestParameterImportResult;
import com.kms.katalon.composer.webservice.importing.model.RestResourceImportNode;
import com.kms.katalon.composer.webservice.importing.model.RestServiceImportResult;
import com.kms.katalon.composer.webservice.importing.model.WebServiceImportNode;
import com.kms.katalon.controller.ObjectRepositoryController;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.repository.WebElementPropertyEntity;
import com.kms.katalon.entity.repository.WebServiceRequestEntity;
import com.kms.katalon.entity.variable.VariableEntity;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public abstract class RestRequestImportResult
extends RestResourceImportNode {
    protected RestMethodImportResult methodImportResult;
    private String name;
    protected String mediaType;
    protected String bodyContent;
    protected String httpMethod;
    protected boolean followRedirects = true;
    private RestServiceImportResult serviceImportResult;

    public RestRequestImportResult(String name, RestMethodImportResult methodResult) {
        this.methodImportResult = methodResult;
        this.name = methodResult.getAvailableChildNodeName(name, methodResult.getFileEntity(), false);
        methodResult.addChildNodeName(name);
    }

    public void setMediaType(String mediaType) {
        this.mediaType = mediaType.trim();
    }

    public void setRequestBodyContent(String bodyContent) {
        this.bodyContent = bodyContent;
    }

    public void setFollowRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
    }

    public void setHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
    }

    public void setParameter(String name, String value) {
        RestParameterImportResult pr = this.hasParameter(name) ? this.getParameter(name) : this.addNewParameter(name);
        pr.setValue(value);
    }

    @Override
    public FileEntity getFileEntity() {
        try {
            WebServiceRequestEntity request = this.buildRequest();
            return request;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private WebServiceRequestEntity buildRequest() throws Exception {
        FolderEntity parentFolder = this.methodImportResult.getFileEntity();
        WebServiceRequestEntity request = ObjectRepositoryController.getInstance().newWSTestObjectWithoutSave(parentFolder, this.name);
        String url = this.buildRequestUrl();
        request.setRestUrl(url);
        List<WebElementPropertyEntity> headers = this.getRequestHeaders();
        request.setHttpHeaderProperties(headers);
        request.setHttpBodyType(this.getHttpBodyType());
        request.setHttpBodyContent(this.getHttpBodyContent());
        List<VariableEntity> variables = this.getRequestVariables();
        request.setVariables(variables);
        request.setRestRequestMethod(this.httpMethod);
        request.setFollowRedirects(this.followRedirects);
        request.setServiceType("RESTful");
        return request;
    }

    private String buildRequestUrl() {
        List<RestParameterImportResult> queryParameters;
        StringBuilder urlBuilder = new StringBuilder();
        String basePath = this.getBaseUrl();
        if (StringUtils.isNotBlank((String)basePath)) {
            urlBuilder.append(basePath);
        }
        if (!(queryParameters = this.getUrlQueryParameters()).isEmpty()) {
            urlBuilder.append("?");
            String queryString = queryParameters.stream().map(p -> {
                String parameterName = p.getName();
                String parameterValue = StringUtils.defaultIfBlank((String)p.getValue(), (String)"");
                return String.format("%s=%s", parameterName, parameterValue);
            }).collect(Collectors.joining("&"));
            urlBuilder.append(queryString);
        }
        return urlBuilder.toString();
    }

    protected abstract List<RestParameterImportResult> getUrlQueryParameters();

    protected abstract String getBaseUrl();

    protected abstract String getHttpBodyContent();

    protected abstract String getHttpBodyType();

    protected abstract List<WebElementPropertyEntity> getRequestHeaders();

    private List<VariableEntity> getRequestVariables() {
        return this.getTemplateParameters().stream().map(p -> {
            VariableEntity variable = new VariableEntity();
            variable.setName(p.getName());
            variable.setDefaultValue(StringUtils.defaultIfBlank((String)p.getValue(), (String)""));
            return variable;
        }).collect(Collectors.toList());
    }

    protected String getServiceBasePath() {
        RestServiceImportResult serviceImportResult = this.getServiceImportResult();
        String basePath = serviceImportResult.getBasePath();
        if (StringUtils.isNotBlank((String)basePath) && !basePath.startsWith("/")) {
            basePath = "/" + basePath;
        }
        return basePath;
    }

    protected RestServiceImportResult getServiceImportResult() {
        if (this.serviceImportResult == null) {
            WebServiceImportNode importNode = this.methodImportResult;
            while (!(importNode instanceof RestServiceImportResult)) {
                importNode = ((WebServiceImportNode)importNode).getParentImportNode();
            }
            this.serviceImportResult = (RestServiceImportResult)importNode;
        }
        return this.serviceImportResult;
    }

    protected String getResourcePath() {
        String resourcePath = this.methodImportResult.getResourceImportResult().getPath();
        if (StringUtils.isNotBlank((String)resourcePath)) {
            if (!resourcePath.startsWith("/")) {
                resourcePath = "/" + resourcePath;
            }
            resourcePath = StringUtils.replace((String)resourcePath, (String)"{", (String)"${");
        }
        return resourcePath;
    }

    @Override
    public WebServiceImportNode getParentImportNode() {
        return this.methodImportResult;
    }

    @Override
    public List<WebServiceImportNode> getChildImportNodes() {
        return Collections.emptyList();
    }
}

