/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.importing.model;

import com.kms.katalon.composer.webservice.importing.model.RestMethodImportResult;
import com.kms.katalon.composer.webservice.importing.model.RestParameterImportResult;
import com.kms.katalon.composer.webservice.importing.model.RestResourceImportNode;
import com.kms.katalon.composer.webservice.importing.model.RestServiceImportResult;
import com.kms.katalon.composer.webservice.importing.model.WebServiceImportNode;
import com.kms.katalon.entity.folder.FolderEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class RestResourceImportResult
extends RestResourceImportNode {
    private RestServiceImportResult serviceImportResult;
    private RestResourceImportResult parentResourceImportResult;
    private String path;
    private FolderEntity resourceFolder;
    private List<RestMethodImportResult> methodImportResults = new ArrayList<RestMethodImportResult>();
    private List<RestResourceImportResult> childResourceImportResults = new ArrayList<RestResourceImportResult>();

    public RestResourceImportResult(String name, RestServiceImportResult serviceImportResult, String path) {
        this.serviceImportResult = serviceImportResult;
        this.path = path;
        this.resourceFolder = serviceImportResult.newChildFolder(name);
    }

    public RestResourceImportResult(String name, RestResourceImportResult resourceImportResult, String path) {
        this.parentResourceImportResult = resourceImportResult;
        this.path = path;
        this.resourceFolder = resourceImportResult.newChildFolder(name);
    }

    protected RestServiceImportResult getServiceImportResult() {
        return this.serviceImportResult;
    }

    public String getPath() {
        StringBuilder pathBuilder = new StringBuilder();
        if (this.parentResourceImportResult != null && this.parentResourceImportResult.getPath() != null) {
            pathBuilder.append(this.parentResourceImportResult.getPath());
        }
        if (StringUtils.isNotBlank((CharSequence)this.path)) {
            if (!this.path.startsWith("/")) {
                pathBuilder.append("/");
            }
            pathBuilder.append(this.path);
        }
        return pathBuilder.toString();
    }

    protected RestResourceImportResult getParentResourceImportResult() {
        return this.parentResourceImportResult;
    }

    public List<RestMethodImportResult> getMethodImportResults() {
        return Collections.unmodifiableList(this.methodImportResults);
    }

    public RestMethodImportResult newMethod(String name, String httpMethod) {
        RestMethodImportResult methodResult = new RestMethodImportResult(name, this, httpMethod);
        this.methodImportResults.add(methodResult);
        return methodResult;
    }

    public List<RestResourceImportResult> getChildResourceImportResults() {
        return Collections.unmodifiableList(this.childResourceImportResults);
    }

    public RestResourceImportResult newResource(String name, String path) {
        RestResourceImportResult resourceResult = new RestResourceImportResult(name, this, path);
        this.getParameters().stream().forEach(p -> {
            RestParameterImportResult pr = resourceResult.addNewParameter(p.getName());
            pr.setValue(p.getValue());
            pr.setStyle(p.getStyle());
        });
        this.childResourceImportResults.add(resourceResult);
        return resourceResult;
    }

    public FolderEntity getFileEntity() {
        return this.resourceFolder;
    }

    @Override
    public WebServiceImportNode getParentImportNode() {
        if (this.parentResourceImportResult != null) {
            return this.parentResourceImportResult;
        }
        return this.serviceImportResult;
    }

    @Override
    public List<WebServiceImportNode> getChildImportNodes() {
        ArrayList<RestResourceImportNode> childImportNodes = new ArrayList<RestResourceImportNode>();
        childImportNodes.addAll(this.methodImportResults);
        childImportNodes.addAll(this.childResourceImportResults);
        return Collections.unmodifiableList(childImportNodes);
    }
}

