/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.openapi;

import com.google.common.base.Preconditions;
import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.webservice.constants.ComposerWebserviceMessageConstants;
import com.kms.katalon.composer.webservice.constants.HttpMethod;
import com.kms.katalon.composer.webservice.openapi.OpenApiProjectImportResult;
import com.kms.katalon.composer.webservice.openapi.OpenApiRestParameter;
import com.kms.katalon.composer.webservice.openapi.OpenApiRestRequestImportResult;
import com.kms.katalon.composer.webservice.openapi.OpenApiRestResourceImportNode;
import com.kms.katalon.composer.webservice.openapi.OpenApiRestResourceImportResult;
import com.kms.katalon.controller.EntityNameController;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.webservice.FormDataBodyParameter;
import com.kms.katalon.entity.webservice.UrlEncodedBodyParameter;
import io.swagger.oas.models.OpenAPI;
import io.swagger.oas.models.Operation;
import io.swagger.oas.models.PathItem;
import io.swagger.oas.models.Paths;
import io.swagger.oas.models.info.Info;
import io.swagger.oas.models.media.ArraySchema;
import io.swagger.oas.models.media.Content;
import io.swagger.oas.models.media.MediaType;
import io.swagger.oas.models.media.Schema;
import io.swagger.oas.models.parameters.Parameter;
import io.swagger.oas.models.servers.Server;
import io.swagger.oas.models.servers.ServerVariable;
import io.swagger.oas.models.servers.ServerVariables;
import io.swagger.parser.OpenAPIParser;
import io.swagger.parser.models.ParseOptions;
import io.swagger.parser.models.SwaggerParseResult;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;

public final class OpenApiImporter {
    private static final OpenApiImporter INSTANCE = new OpenApiImporter();
    private Map<String, Schema> schemas;

    public static OpenApiImporter getInstance() {
        return INSTANCE;
    }

    public OpenApiProjectImportResult importServices(String projectFilePath, FolderEntity rootFolder) throws Exception {
        Preconditions.checkNotNull((Object)projectFilePath, (Object)"OpenAPI 3.0 project file path must not be null or empty.");
        File projectFile = new File(projectFilePath);
        Preconditions.checkArgument((boolean)projectFile.exists(), (Object)"OpenAPI 3.0 project file does not exist.");
        Preconditions.checkNotNull((Object)rootFolder, (Object)"Root folder must not be null.");
        OpenAPIParser parser = new OpenAPIParser();
        ParseOptions options = new ParseOptions();
        options.setResolveFully(true);
        options.setResolve(true);
        SwaggerParseResult result = parser.readLocation(projectFilePath, null, options);
        OpenAPI openAPI = result.getOpenAPI();
        if (openAPI == null) {
            throw new Exception("Invalid Open API format");
        }
        this.schemas = openAPI.getComponents() == null ? Collections.emptyMap() : openAPI.getComponents().getSchemas();
        FolderEntity projectImportFolder = this.getProjectImportFolder(this.getProjectName(openAPI), rootFolder);
        OpenApiProjectImportResult projectImportResult = new OpenApiProjectImportResult(projectImportFolder, this.getBasePath(openAPI));
        Paths paths = openAPI.getPaths();
        for (String pathKey : paths.keySet()) {
            PathItem path = (PathItem)paths.get((Object)pathKey);
            String resourceName = path.getSummary() != null ? path.getSummary() : pathKey;
            OpenApiRestResourceImportResult resourceImportResult = projectImportResult.newResource(this.toValidFileName(resourceName), pathKey);
            this.parseRequests(resourceImportResult, path);
        }
        return projectImportResult;
    }

    private String getProjectName(OpenAPI openAPI) {
        String title;
        String name = null;
        Info info = openAPI.getInfo();
        if (info != null && (title = info.getTitle()) != null) {
            name = title;
        }
        return name;
    }

    private String getBasePath(OpenAPI openAPI) {
        List servers = openAPI.getServers();
        String url = "/";
        if (servers != null && !servers.isEmpty()) {
            Server server = (Server)servers.get(0);
            url = server.getUrl();
            if (server.getVariables() != null) {
                ServerVariables serverVariables = server.getVariables();
                for (String variable : serverVariables.keySet()) {
                    String variableTemplate;
                    String defaultValue = ((ServerVariable)serverVariables.get((Object)variable)).getDefault();
                    if (defaultValue == null || !url.contains(variableTemplate = "{" + variable + "}")) continue;
                    url = url.replace(variableTemplate, defaultValue);
                }
            }
        }
        return url;
    }

    private FolderEntity getProjectImportFolder(String name, FolderEntity parentFolder) throws Exception {
        if (StringUtils.isBlank((CharSequence)name)) {
            name = "Imported from OpenAPI 3.0";
        }
        name = this.toValidFileName(name);
        name = EntityNameController.getInstance().getAvailableName(name, parentFolder, true);
        FolderEntity folder = new FolderEntity();
        folder.setName(name);
        folder.setParentFolder(parentFolder);
        folder.setProject(parentFolder.getProject());
        folder.setFolderType(parentFolder.getFolderType());
        folder.setDescription("folder");
        return folder;
    }

    private void parseRequests(OpenApiRestResourceImportResult resourceImportResult, PathItem pathItem) {
        if (resourceImportResult == null || pathItem == null) {
            return;
        }
        List parameters = pathItem.getParameters();
        if (pathItem.getGet() != null) {
            this.parseRequest(resourceImportResult, HttpMethod.GET, pathItem.getGet(), parameters);
        }
        if (pathItem.getPost() != null) {
            this.parseRequest(resourceImportResult, HttpMethod.POST, pathItem.getPost(), parameters);
        }
        if (pathItem.getDelete() != null) {
            this.parseRequest(resourceImportResult, HttpMethod.DELETE, pathItem.getDelete(), parameters);
        }
        if (pathItem.getPut() != null) {
            this.parseRequest(resourceImportResult, HttpMethod.PUT, pathItem.getPut(), parameters);
        }
        if (pathItem.getOptions() != null) {
            this.parseRequest(resourceImportResult, HttpMethod.OPTIONS, pathItem.getOptions(), parameters);
        }
        if (pathItem.getTrace() != null) {
            this.parseRequest(resourceImportResult, HttpMethod.TRACE, pathItem.getTrace(), parameters);
        }
        if (pathItem.getHead() != null) {
            this.parseRequest(resourceImportResult, HttpMethod.HEAD, pathItem.getHead(), parameters);
        }
        if (pathItem.getPatch() != null) {
            this.parseRequest(resourceImportResult, HttpMethod.PATCH, pathItem.getPatch(), parameters);
        }
    }

    private void parseRequest(OpenApiRestResourceImportResult resourceImportResult, HttpMethod httpMethod, Operation operation, List<Parameter> parameters) {
        block22: {
            if (operation == null) {
                return;
            }
            String name = !StringUtils.isBlank((CharSequence)operation.getOperationId()) ? operation.getOperationId() : httpMethod.toString();
            OpenApiRestRequestImportResult request = resourceImportResult.newRequest(this.toValidFileName(name));
            request.setHttpMethod(httpMethod.toString());
            if (operation.getParameters() != null) {
                this.addParameters(request, operation.getParameters());
            } else {
                this.addParameters(request, parameters);
            }
            if (operation.getRequestBody() == null || operation.getRequestBody().getContent() == null) break block22;
            Content content = operation.getRequestBody().getContent();
            for (String mediaTypeName : content.keySet()) {
                MediaType mediaType = (MediaType)content.get((Object)mediaTypeName);
                try {
                    Schema schema = mediaType.getSchema();
                    switch (mediaTypeName) {
                        case "application/x-www-form-urlencoded": {
                            request.setUrlEncodedBodyParameters(this.parseUrlEncodedRequestBody(schema));
                            request.setMediaType(mediaTypeName);
                            break;
                        }
                        case "multipart/form-data": {
                            request.setFormDataBodyParameters(this.parseFormDataRequestBody(schema));
                            request.setMediaType(mediaTypeName);
                            break;
                        }
                        case "application/json": {
                            String jsonBodyContent = mediaType.getExample() != null ? this.parseExample(mediaType.getExample()) : (schema != null && schema.getExample() != null ? this.parseExample(schema.getExample()) : JsonUtil.toJson((Object)this.parseJsonValue(schema, In.BODY, new ArrayList<String>())));
                            request.setRequestBodyContent(jsonBodyContent);
                            request.setMediaType(mediaTypeName);
                            break;
                        }
                        case "*/*": {
                            String bodyContent = schema != null && schema.getExample() != null ? this.parseExample(schema.getExample()) : JsonUtil.toJson((Object)this.parseJsonValue(schema, In.BODY, new ArrayList<String>()));
                            request.setRequestBodyContent(bodyContent);
                            request.setMediaType(mediaTypeName);
                        }
                    }
                }
                catch (Exception exception) {
                    MultiStatusErrorDialog.showErrorDialog((Throwable)exception, (String)ComposerWebserviceMessageConstants.TITLE_INVALID_SCHEMA, (String)MessageFormat.format(ComposerWebserviceMessageConstants.ERROR_INVALID_FORMAT_OPENAPI, mediaType.toString()));
                    LoggerSingleton.logError((Throwable)exception);
                    return;
                }
            }
        }
    }

    private List<UrlEncodedBodyParameter> parseUrlEncodedRequestBody(Schema<?> schema) {
        Map propertyMap = schema.getProperties();
        ArrayList<UrlEncodedBodyParameter> params = new ArrayList<UrlEncodedBodyParameter>();
        for (Map.Entry entry : propertyMap.entrySet()) {
            UrlEncodedBodyParameter param = new UrlEncodedBodyParameter();
            param.setName((String)entry.getKey());
            String value = String.valueOf(this.parseJsonValue((Schema)entry.getValue(), In.BODY, new ArrayList<String>()));
            param.setValue(value);
            params.add(param);
        }
        return params;
    }

    private List<FormDataBodyParameter> parseFormDataRequestBody(Schema<?> schema) {
        if (schema == null) {
            return new ArrayList<FormDataBodyParameter>();
        }
        if (schema.getType() == null && schema.getProperties() == null) {
            String refName = this.getRefName(schema);
            schema = this.schemas.get(refName);
        }
        Map propertyMap = schema.getProperties();
        ArrayList<FormDataBodyParameter> params = new ArrayList<FormDataBodyParameter>();
        for (Map.Entry entry : propertyMap.entrySet()) {
            FormDataBodyParameter param = new FormDataBodyParameter();
            param.setName((String)entry.getKey());
            param.setValue(JsonUtil.toJson((Object)this.parseJsonValue((Schema)entry.getValue(), In.BODY, new ArrayList<String>())));
            String format = ((Schema)entry.getValue()).getFormat();
            if (format != null) {
                if (((Schema)entry.getValue()).getType().equals("string") && format.equals("binary") || format.equals("byte")) {
                    param.setType("File");
                } else {
                    param.setType("Text");
                }
            }
            params.add(param);
        }
        return params;
    }

    private void addParameters(OpenApiRestResourceImportNode holder, List<Parameter> restParameters) {
        if (restParameters == null) {
            return;
        }
        for (Parameter param : restParameters) {
            String in = param.getIn();
            String name = param.getName();
            String value = null;
            String type = null;
            if (param.getSchema() != null) {
                value = String.valueOf(this.parseJsonValue(param.getSchema(), In.PARAM, new ArrayList<String>()));
                type = param.getSchema().getType();
            }
            type = type != null ? "<" + type + "> " : "";
            String required = param.getRequired() != false ? "{Required} " : "";
            String description = String.valueOf(type) + required + param.getDescription();
            if (in.equals("path")) {
                holder.addParameter(name, null, description, OpenApiRestParameter.Style.TEMPLATE);
                continue;
            }
            if (in.equals("query")) {
                holder.addParameter(name, value, description, OpenApiRestParameter.Style.QUERY);
                continue;
            }
            if (!in.equals("header")) continue;
            holder.addParameter(name, value, description, OpenApiRestParameter.Style.HEADER);
        }
    }

    private Map<String, Object> parseJsonObject(Schema<?> schema, List<String> objects) {
        Map propertyMap = schema.getProperties();
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (propertyMap != null) {
            for (Map.Entry entry : propertyMap.entrySet()) {
                ArrayList value;
                String name = (String)entry.getKey();
                Schema subSchema = (Schema)entry.getValue();
                ArrayList<String> copy = new ArrayList<String>(objects);
                if (copy.contains(name)) {
                    value = new HashMap();
                    if (subSchema.getType() != null && subSchema.getType().equals("array")) {
                        ArrayList arr = new ArrayList();
                        arr.add(value);
                        value = arr;
                    }
                } else {
                    copy.add(name);
                    value = this.parseJsonValue(subSchema, In.BODY, copy);
                }
                result.put(name, value);
            }
        }
        return result;
    }

    private Object parseJsonValue(Schema<?> schema, In in, List<String> objects) {
        ArrayList<Object> displayValue = null;
        if (schema == null) {
            return new Object();
        }
        if (schema.getType() == null && schema.get$ref() == null) {
            return displayValue;
        }
        if (schema.getExample() != null && !schema.getType().equals("array")) {
            return schema.getExample();
        }
        if (schema.getEnum() != null) {
            return schema.getEnum().get(0);
        }
        if (schema.getType() == null) {
            String refName = this.getRefName(schema);
            schema = this.schemas.get(refName);
        }
        switch (schema.getType()) {
            case "integer": {
                displayValue = 0;
                break;
            }
            case "number": {
                displayValue = 1.1;
                break;
            }
            case "string": {
                displayValue = "string";
                break;
            }
            case "boolean": {
                displayValue = true;
                break;
            }
            case "array": {
                Schema items = ((ArraySchema)schema).getItems();
                Object item = this.parseJsonValue(items, in, objects);
                if (in == In.PARAM) {
                    displayValue = item;
                    break;
                }
                ArrayList<Object> arr = new ArrayList<Object>();
                arr.add(item);
                displayValue = arr;
                break;
            }
            case "object": {
                displayValue = this.parseJsonObject(schema, objects);
            }
        }
        return displayValue;
    }

    private String getRefName(Schema<?> schema) {
        String refPath = "#/components/schemas/";
        String ref = schema.get$ref();
        return ref.substring(refPath.length());
    }

    private String parseExample(Object ex) {
        JSONObject json = new JSONObject(ex.toString());
        return json.toString(2);
    }

    private String toValidFileName(String fileName) {
        return fileName.trim().replaceAll("[^A-Za-z-0-9_()\\- ]+", "_");
    }

    private static enum In {
        BODY,
        PARAM;

    }
}

