/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.openapi;

import com.kms.katalon.composer.webservice.openapi.OpenApiImportNode;
import com.kms.katalon.composer.webservice.openapi.OpenApiProjectImportResult;
import com.kms.katalon.composer.webservice.openapi.OpenApiRestParameter;
import com.kms.katalon.composer.webservice.openapi.OpenApiRestResourceImportNode;
import com.kms.katalon.composer.webservice.openapi.OpenApiRestResourceImportResult;
import com.kms.katalon.controller.ObjectRepositoryController;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.repository.WebElementPropertyEntity;
import com.kms.katalon.entity.repository.WebServiceRequestEntity;
import com.kms.katalon.entity.variable.VariableEntity;
import com.kms.katalon.entity.webservice.FormDataBodyParameter;
import com.kms.katalon.entity.webservice.HttpBodyContent;
import com.kms.katalon.entity.webservice.ParameterizedBodyContent;
import com.kms.katalon.entity.webservice.TextBodyContent;
import com.kms.katalon.entity.webservice.UrlEncodedBodyParameter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class OpenApiRestRequestImportResult
extends OpenApiRestResourceImportNode {
    static final String APPLICATION_JSON_CONTENT_TYPE = "application/json";
    static final String APPLICATION_XML_CONTENT_TYPE = "application/xml";
    static final String TEXT_XML_CONTENT_TYPE = "text/xml";
    static final String MULTIPLE_CONTENT_TYPE = "*/*";
    static final String MULTIPART_FORM_DATA_CONTENT_TYPE = "multipart/form-data";
    static final String FORM_URLENCODED_CONTENT_TYPE = "application/x-www-form-urlencoded";
    private OpenApiProjectImportResult projectImportResult;
    private OpenApiRestResourceImportResult resourceImportResult;
    private String name;
    private Map<String, String> headers = new LinkedHashMap<String, String>();
    private String mediaType;
    private String bodyContent;
    private String httpMethod;
    private List<UrlEncodedBodyParameter> urlEncodedBodyParameters;
    private List<FormDataBodyParameter> formDataBodyParameters;

    public OpenApiRestRequestImportResult(OpenApiRestResourceImportResult resourceResult, String name) {
        this.resourceImportResult = resourceResult;
        this.name = name;
    }

    public void setHeader(String name, String value) {
        this.headers.put(name, value);
    }

    public void setMediaType(String mediaType) {
        this.mediaType = mediaType.trim();
    }

    public void setRequestBodyContent(String bodyContent) {
        this.bodyContent = bodyContent;
    }

    public void setUrlEncodedBodyParameters(List<UrlEncodedBodyParameter> urlEncodedBodyParameters) {
        this.urlEncodedBodyParameters = urlEncodedBodyParameters;
    }

    public void setFormDataBodyParameters(List<FormDataBodyParameter> formDataBodyParameters) {
        this.formDataBodyParameters = formDataBodyParameters;
    }

    protected void setHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
    }

    @Override
    public FileEntity getFileEntity() {
        try {
            WebServiceRequestEntity request = this.buildRequest();
            return request;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private WebServiceRequestEntity buildRequest() throws Exception {
        FolderEntity parentFolder = (FolderEntity)this.resourceImportResult.getFileEntity();
        WebServiceRequestEntity request = ObjectRepositoryController.getInstance().newWSTestObjectWithoutSave(parentFolder, this.name);
        String url = this.buildRequestUrl();
        request.setRestUrl(url);
        List<WebElementPropertyEntity> headers = this.collectRequestHeaders();
        request.setHttpHeaderProperties(headers);
        if (this.mediaType != null) {
            request.setHttpBodyType(this.getBodyType());
            HttpBodyContent httpBodyContent = this.getHttpBodyContent();
            request.setHttpBodyContent(JsonUtil.toJson((Object)httpBodyContent));
        }
        List<VariableEntity> variables = this.collectRequestVariables();
        request.setVariables(variables);
        request.setRestRequestMethod(this.httpMethod);
        request.setServiceType("RESTful");
        return request;
    }

    private List<WebElementPropertyEntity> collectRequestHeaders() {
        ArrayList<WebElementPropertyEntity> headers = new ArrayList<WebElementPropertyEntity>();
        for (OpenApiRestParameter headerParameter : this.getHeaderParameters()) {
            WebElementPropertyEntity headerPropertyEntity = new WebElementPropertyEntity();
            headerPropertyEntity.setName(headerParameter.getName());
            headerPropertyEntity.setValue(headerParameter.getValue());
            headers.add(headerPropertyEntity);
        }
        return headers;
    }

    private List<VariableEntity> collectRequestVariables() {
        return this.getTemplateParameters().stream().map(p -> {
            VariableEntity variable = new VariableEntity();
            variable.setName(p.getName());
            variable.setDefaultValue(StringUtils.defaultIfBlank((String)p.getValue(), (String)""));
            variable.setDescription(p.getDescription());
            return variable;
        }).collect(Collectors.toList());
    }

    private String getBodyType() {
        switch (this.mediaType) {
            case "application/xml": 
            case "text/xml": 
            case "application/json": {
                return "text";
            }
            case "application/x-www-form-urlencoded": {
                return "x-www-form-urlencoded";
            }
            case "multipart/form-data": {
                return "form-data";
            }
        }
        return "text";
    }

    private HttpBodyContent getHttpBodyContent() {
        switch (this.mediaType) {
            case "application/xml": 
            case "text/xml": 
            case "application/json": {
                return this.getTextBodyContent();
            }
            case "application/x-www-form-urlencoded": {
                return this.getUrlEncodedBodyContent();
            }
            case "multipart/form-data": {
                return this.getFormDataBodyContent();
            }
        }
        return this.getTextBodyContent();
    }

    private HttpBodyContent getTextBodyContent() {
        TextBodyContent httpBody = new TextBodyContent();
        httpBody.setContentType(this.mediaType);
        httpBody.setText(this.bodyContent);
        return httpBody;
    }

    private HttpBodyContent getUrlEncodedBodyContent() {
        ParameterizedBodyContent httpBody = new ParameterizedBodyContent();
        this.urlEncodedBodyParameters.stream().forEach(p -> httpBody.addParameter(p));
        httpBody.setContentType(FORM_URLENCODED_CONTENT_TYPE);
        httpBody.setCharset(StandardCharsets.UTF_8.name());
        return httpBody;
    }

    private HttpBodyContent getFormDataBodyContent() {
        ParameterizedBodyContent httpBody = new ParameterizedBodyContent();
        this.formDataBodyParameters.stream().forEach(p -> httpBody.addParameter(p));
        httpBody.setContentType(MULTIPART_FORM_DATA_CONTENT_TYPE);
        httpBody.setCharset(StandardCharsets.UTF_8.name());
        return httpBody;
    }

    private String buildRequestUrl() {
        List<OpenApiRestParameter> queryParameters;
        String resourcePath;
        StringBuilder urlBuilder = new StringBuilder();
        String basePath = this.getBasePath();
        if (StringUtils.isNotBlank((String)basePath)) {
            urlBuilder.append(basePath);
        }
        if (StringUtils.isNotBlank((String)(resourcePath = this.getResourcePath()))) {
            urlBuilder.append(resourcePath);
        }
        if (!(queryParameters = this.getQueryParameters()).isEmpty()) {
            urlBuilder.append("?");
            String queryString = queryParameters.stream().map(p -> {
                String parameterName = p.getName();
                String parameterValue = StringUtils.defaultIfBlank((String)p.getValue(), (String)"");
                return String.format("%s=%s", parameterName, parameterValue);
            }).collect(Collectors.joining("&"));
            urlBuilder.append(queryString);
        }
        return urlBuilder.toString();
    }

    private String getBasePath() {
        OpenApiProjectImportResult projectImportResult = this.getProjectImportResult();
        String basePath = projectImportResult.getBasePath();
        return basePath;
    }

    private String getResourcePath() {
        String resourcePath = this.resourceImportResult.getPath();
        if (StringUtils.isNotBlank((String)resourcePath)) {
            if (!resourcePath.startsWith("/")) {
                resourcePath = "/" + resourcePath;
            }
            resourcePath = StringUtils.replace((String)resourcePath, (String)"{", (String)"${");
        }
        return resourcePath;
    }

    private OpenApiProjectImportResult getProjectImportResult() {
        if (this.projectImportResult == null) {
            OpenApiImportNode importNode = this.resourceImportResult;
            while (!(importNode instanceof OpenApiProjectImportResult)) {
                importNode = ((OpenApiImportNode)importNode).getParentImportNode();
            }
            this.projectImportResult = (OpenApiProjectImportResult)importNode;
        }
        return this.projectImportResult;
    }
}

