/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.parts;

import com.kms.katalon.application.utils.LicenseUtil;
import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.impl.dialogs.ProgressMonitorDialogWithThread;
import com.kms.katalon.composer.components.impl.handler.KSEFeatureAccessHandler;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.webservice.constants.ComposerWebserviceMessageConstants;
import com.kms.katalon.composer.webservice.constants.StringConstants;
import com.kms.katalon.composer.webservice.editor.HttpBodyEditorComposite;
import com.kms.katalon.composer.webservice.editor.ValidationComposite;
import com.kms.katalon.composer.webservice.parts.WebServicePart;
import com.kms.katalon.composer.webservice.response.body.ResponseBodyEditorsComposite;
import com.kms.katalon.composer.webservice.util.WebServiceUtil;
import com.kms.katalon.composer.webservice.view.ExpandableComposite;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.WebServiceController;
import com.kms.katalon.core.testobject.RequestObject;
import com.kms.katalon.core.testobject.ResponseObject;
import com.kms.katalon.core.util.internal.ExceptionsUtil;
import com.kms.katalon.core.webservice.common.HarLogger;
import com.kms.katalon.core.webservice.common.WebServiceMethod;
import com.kms.katalon.core.webservice.helper.RestRequestMethodHelper;
import com.kms.katalon.core.webservice.setting.WebServiceSettingStore;
import com.kms.katalon.core.webui.util.OSUtil;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.repository.DraftWebServiceRequestEntity;
import com.kms.katalon.entity.repository.WebElementPropertyEntity;
import com.kms.katalon.entity.repository.WebServiceRequestEntity;
import com.kms.katalon.entity.webservice.RequestHistoryEntity;
import com.kms.katalon.execution.preferences.ProxyPreferences;
import com.kms.katalon.feature.KSEFeature;
import com.kms.katalon.tracking.service.Trackings;
import com.kms.katalon.util.URLBuilder;
import com.kms.katalon.util.collections.NameValuePair;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.PreDestroy;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class RestServicePart
extends WebServicePart {
    protected HttpBodyEditorComposite requestBodyEditor;
    protected ValidationComposite validationComposite;
    private URLBuilder urlBuilder;
    protected ResponseBodyEditorsComposite responseBodyEditor;
    private ProgressMonitorDialogWithThread progress;
    private Label lblBodyNotSupported;
    private ModifyListener requestURLModifyListener;
    private CCombo cbbRequestMethod;
    private Text txtRequestURL;

    @Override
    protected void createServiceInfoComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.cbbRequestMethod = new CCombo(composite, 2048);
        this.cbbRequestMethod.setBackground(ColorUtil.getWhiteBackgroundColor());
        GridData gdRequestMethod = new GridData(4, 0x1000000, false, false);
        gdRequestMethod.widthHint = 100;
        gdRequestMethod.heightHint = 22;
        this.cbbRequestMethod.setLayoutData((Object)gdRequestMethod);
        this.cbbRequestMethod.setEditable(true);
        this.cbbRequestMethod.setItems(this.getRestRequestMethods());
        this.cbbRequestMethod.setText(this.originalWsObject.getRestRequestMethod());
        this.txtRequestURL = new Text(composite, 2048);
        GridData gdRequestURL = new GridData(4, 0x1000000, true, true);
        gdRequestURL.heightHint = 20;
        this.txtRequestURL.setLayoutData((Object)gdRequestURL);
        this.txtRequestURL.setMessage(StringConstants.PA_LBL_URL);
        String url = this.originalWsObject.getRestUrl();
        if (!StringUtils.trim((String)url).isEmpty()) {
            this.txtRequestURL.setText(url);
        }
        this.createApiControls(composite);
        Composite requestOptions = this.createRequestOptionsComposite(composite);
        requestOptions.setLayoutData((Object)new GridData(-1, -1, true, false, gridLayout.numColumns, 1));
        Composite queryParamsComp = new Composite(composite, 0);
        queryParamsComp.setLayout((Layout)new GridLayout());
        queryParamsComp.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
        this.createQueryParamsComposite(queryParamsComp);
        this.registerControlListeners();
        this.registerEventListeners();
    }

    protected void createQueryParamsComposite(Composite parent) {
        ExpandableComposite paramsExpandableComposite = new ExpandableComposite(parent, StringConstants.PA_LBL_PARAMS, 1, true);
        Composite paramsComposite = paramsExpandableComposite.createControl();
        GridLayout glParams = (GridLayout)paramsComposite.getLayout();
        glParams.marginLeft = 0;
        glParams.marginRight = 0;
        final ToolBar toolbar = this.createAddRemoveToolBar(paramsComposite, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RestServicePart.this.tblParams.addRow();
            }
        }, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RestServicePart.this.deleteSelectedParams();
            }
        });
        this.tblParams = this.createKeyValueTable(paramsComposite, false);
        this.tblParams.setInput(this.params);
        this.tblParams.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                toolbar.getItem(1).setEnabled(RestServicePart.this.tblParams.getTable().getSelectionCount() > 0);
            }
        });
    }

    private void registerEventListeners() {
        this.eventBroker.subscribe("WEBSERVICE/UPDATE_METHODS", (EventHandler)this);
    }

    private String[] getRestRequestMethods() {
        List methods;
        WebServiceSettingStore store = this.getWebServiceSettingStore();
        try {
            methods = store.getWebServiceMethods();
        }
        catch (IOException e) {
            LoggerSingleton.logError((Throwable)e);
            methods = store.getDefaultWebServiceMethods();
        }
        return (String[])methods.stream().map(WebServiceMethod::getName).toArray(String[]::new);
    }

    private WebServiceSettingStore getWebServiceSettingStore() {
        ProjectEntity project = ProjectController.getInstance().getCurrentProject();
        return WebServiceSettingStore.create((String)project.getFolderLocation());
    }

    private void registerControlListeners() {
        this.requestURLModifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Text text = (Text)e.widget;
                RestServicePart.this.updateParamsTable(text.getText());
                RestServicePart.this.setDirty(true);
            }
        };
        this.txtRequestURL.addModifyListener(this.requestURLModifyListener);
        this.cbbRequestMethod.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RestServicePart.this.setTabBodyContentBasedOnRequestMethod();
                RestServicePart.this.setDirty(true);
            }
        });
        this.cbbRequestMethod.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RestServicePart.this.setTabBodyContentBasedOnRequestMethod();
                RestServicePart.this.setDirty(true);
            }
        });
        this.cbbRequestMethod.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                if (StringUtils.isBlank((CharSequence)RestServicePart.this.cbbRequestMethod.getText())) {
                    RestServicePart.this.cbbRequestMethod.select(0);
                }
                RestServicePart.this.setDirty(true);
            }
        });
    }

    @Override
    protected void sendRequest(final boolean runVerificationScript) {
        if (this.dirtyable.isDirty()) {
            boolean isOK = MessageDialog.openConfirm(null, (String)StringConstants.WARN, (String)ComposerWebserviceMessageConstants.PART_MSG_DO_YOU_WANT_TO_SAVE_THE_CHANGES);
            if (!isOK) {
                return;
            }
            this.save();
        }
        this.clearPreviousResponse();
        if (this.wsApiControl.getSendingState()) {
            this.progress.getProgressMonitor().setCanceled(true);
            this.wsApiControl.setSendButtonState(false);
            return;
        }
        try {
            WebServiceUtil.setHttpsProtocol();
            boolean isValidateJsonAgainstJson = this.isValidateJsonAganistSchema(this.validationComposite.getValidationSteps());
            boolean isValidateXMLAgainstJson = this.isValidateXMLAganistSchema(this.validationComposite.getValidationSteps());
            boolean isValidateGraphQLAgainstSchema = this.isValidateGraphQLAgainstSchema(this.validationComposite.getValidationSteps());
            String requestType = this.getRequestType(this.getWSRequestObject());
            Trackings.trackTestWebServiceObject((boolean)runVerificationScript, (boolean)(this.getOriginalWsObject() instanceof DraftWebServiceRequestEntity), (String)this.ccbAuthType.getText(), (boolean)isValidateJsonAgainstJson, (boolean)isValidateXMLAgainstJson, (boolean)isValidateGraphQLAgainstSchema, (String)requestType);
            this.wsApiControl.setSendButtonState(true);
            this.progress = new ProgressMonitorDialogWithThread(Display.getCurrent().getActiveShell());
            this.progress.setOpenOnRun(false);
            this.displayResponseContentBasedOnSendingState(true);
            this.progress.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    RequestObject requestObject;
                    ResponseObject responseObject;
                    block7: {
                        monitor.beginTask(ComposerWebserviceMessageConstants.PART_MSG_SENDING_TEST_REQUEST, -1);
                        String projectDir = ProjectController.getInstance().getCurrentProject().getFolderLocation();
                        WebServiceRequestEntity requestEntity = RestServicePart.this.getWSRequestObject();
                        RestServicePart.this.configRequest(requestEntity);
                        Map<String, Object> evaluatedVariables = RestServicePart.this.evaluateRequestVariables();
                        HarLogger harLogger = new HarLogger();
                        harLogger.initHarFile();
                        responseObject = WebServiceController.getInstance().sendRequest(requestEntity, projectDir, ProxyPreferences.getSystemProxyInformation(), Collections.unmodifiableMap(evaluatedVariables), false);
                        RestServicePart.this.deleteTempHarFile();
                        requestObject = WebServiceController.getRequestObject((WebServiceRequestEntity)requestEntity, (String)projectDir, Collections.unmodifiableMap(evaluatedVariables));
                        String logFolder = Files.createTempDirectory("har", new FileAttribute[0]).toFile().getAbsolutePath();
                        RestServicePart.this.harFile = harLogger.logHarFile(requestObject, responseObject, logFolder);
                        if (!monitor.isCanceled()) break block7;
                        UISynchronizeService.syncExec(() -> RestServicePart.this.wsApiControl.setSendButtonState(false));
                        monitor.done();
                        return;
                    }
                    try {
                        try {
                            String bodyContent = responseObject.getResponseText();
                            Display.getDefault().asyncExec(() -> {
                                RestServicePart.this.setResponseStatus(responseObject);
                                RestServicePart.this.mirrorEditor.setText(RestServicePart.this.getPrettyHeaders(responseObject));
                                if (bodyContent == null) {
                                    return;
                                }
                                RestServicePart.this.responseBodyEditor.setInput(responseObject);
                            });
                            if (runVerificationScript) {
                                RestServicePart.this.executeVerificationScript(responseObject);
                            }
                            if (runVerificationScript) {
                                RestServicePart.this.executeValidationSteps(requestObject, responseObject);
                                UISynchronizeService.syncExec(() -> {
                                    RestServicePart.this.validationComposite.updateResults(requestObject.getValidationSteps());
                                    RestServicePart.this.getWSRequestObject().setValidationSteps(RestServicePart.this.validationComposite.getPureValidationSteps());
                                    RestServicePart.this.updateValidationResult(requestObject.getValidationSteps());
                                });
                            }
                            RequestHistoryEntity requestHistoryEntity = new RequestHistoryEntity(new Date(), (WebServiceRequestEntity)RestServicePart.this.getWSRequestObject().clone());
                            RestServicePart.this.eventBroker.post("WS_VERIFICATION/FINISHED", (Object)new Object[]{requestHistoryEntity});
                        }
                        catch (Exception e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    catch (Throwable throwable) {
                        UISynchronizeService.syncExec(() -> RestServicePart.this.wsApiControl.setSendButtonState(false));
                        monitor.done();
                        throw throwable;
                    }
                    UISynchronizeService.syncExec(() -> RestServicePart.this.wsApiControl.setSendButtonState(false));
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException ex) {
            Throwable target = ex.getTargetException();
            if (target == null) {
                return;
            }
            LoggerSingleton.logError((Throwable)target);
            MultiStatusErrorDialog.showErrorDialog((String)ComposerWebserviceMessageConstants.PART_MSG_CANNOT_SEND_THE_TEST_REQUEST, (String)target.getMessage(), (String)ExceptionsUtil.getStackTraceForThrowable((Throwable)target));
        }
        catch (InterruptedException interruptedException) {}
        this.displayResponseContentBasedOnSendingState(false);
    }

    private void setTabBodyContentBasedOnRequestMethod() {
        GridData gdLblBodyNotSupported = (GridData)this.lblBodyNotSupported.getLayoutData();
        GridData gdRequestBodyEditor = (GridData)this.requestBodyEditor.getLayoutData();
        if (this.isBodySupported()) {
            gdLblBodyNotSupported.exclude = true;
            this.lblBodyNotSupported.setVisible(false);
            gdRequestBodyEditor.exclude = false;
            this.requestBodyEditor.setVisible(true);
        } else {
            gdLblBodyNotSupported.exclude = false;
            this.lblBodyNotSupported.setVisible(true);
            this.lblBodyNotSupported.setText(String.format(ComposerWebserviceMessageConstants.LBL_BODY_NOT_SUPPORTED, this.cbbRequestMethod.getText()));
            gdRequestBodyEditor.exclude = true;
            this.requestBodyEditor.setVisible(false);
        }
        this.lblBodyNotSupported.getParent().requestLayout();
    }

    protected boolean isBodySupported() {
        String requestMethod = this.cbbRequestMethod.getText();
        return RestRequestMethodHelper.isBodySupported((String)requestMethod);
    }

    private void updateParamsTable(String newUrl) {
        this.params = this.extractRestParameters(newUrl);
        this.tblParams.setInput(this.params);
        this.tblParams.refresh();
    }

    private List<WebElementPropertyEntity> extractRestParameters(String url) {
        ArrayList<WebElementPropertyEntity> paramEntities = new ArrayList();
        this.urlBuilder = new URLBuilder(url);
        List params = this.urlBuilder.getQueryParams();
        paramEntities = params.stream().map(param -> new WebElementPropertyEntity(param.getName(), param.getValue())).collect(Collectors.toList());
        return paramEntities;
    }

    @Override
    protected Composite createRequestOptionsComposite(Composite parent) {
        Composite requestOptionsComposite = super.createRequestOptionsComposite(parent);
        this.createCustomizeApiMethodsLink(requestOptionsComposite);
        this.createSetRequestTimeoutLink(requestOptionsComposite);
        return requestOptionsComposite;
    }

    private void createCustomizeApiMethodsLink(Composite parent) {
        Link lnkCustomizeApiMethods = new Link(parent, 0);
        lnkCustomizeApiMethods.setText(StringConstants.LINK_CUSTOMIZE_API_METHODS);
        lnkCustomizeApiMethods.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RestServicePart.this.eventBroker.post("PROJECT/SETTINGS_PAGE", (Object)"com.kms.katalon.composer.webui.setting.testdesign.webservice.custommethod");
            }
        });
    }

    private void createSetRequestTimeoutLink(Composite parent) {
        Link lnkSetTimeout = new Link(parent, 0);
        lnkSetTimeout.setText(StringConstants.LINK_SET_REQUEST_TIMEOUT_AND_LIMIT);
        lnkSetTimeout.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (LicenseUtil.isNotFreeLicense()) {
                    RestServicePart.this.eventBroker.post("PROJECT/SETTINGS_PAGE", (Object)"com.kms.katalon.composer.execution.settings.webservice");
                } else {
                    KSEFeatureAccessHandler.handleUnauthorizedAccess((KSEFeature)KSEFeature.CUSTOM_WEB_SERVICE_REQUEST_TIMEOUT);
                }
            }
        });
    }

    @Override
    protected void deleteSelectedParams() {
        int[] selectionIndices = this.tblParams.getTable().getSelectionIndices();
        if (selectionIndices == null || selectionIndices.length == 0) {
            return;
        }
        HashSet<Integer> selectionIndexSet = new HashSet<Integer>();
        int[] nArray = selectionIndices;
        int n = selectionIndices.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            selectionIndexSet.add(index);
            ++n2;
        }
        Object paramProperties = this.tblParams.getInput();
        ArrayList<WebElementPropertyEntity> unselectedParamProperties = new ArrayList<WebElementPropertyEntity>();
        IntStream.range(0, paramProperties.size()).filter(i -> !selectionIndexSet.contains(i)).forEach(arg_0 -> RestServicePart.lambda$4(unselectedParamProperties, (List)paramProperties, arg_0));
        this.tblParams.setInput(unselectedParamProperties);
        this.tblParams.refresh();
        if (OSUtil.isMacBigSurOrLater()) {
            this.tblParams.getTable().redraw();
        }
        this.updateRequestUrlWithNewParams(unselectedParamProperties);
        this.setDirty(true);
    }

    private void updateRequestUrlWithNewParams(List<WebElementPropertyEntity> paramProperties) {
        if (this.urlBuilder == null) {
            this.urlBuilder = new URLBuilder();
        }
        List<NameValuePair> params = this.toNameValuePair(paramProperties);
        this.urlBuilder.setParameters(params);
        String newUrl = this.urlBuilder.buildString();
        this.txtRequestURL.removeModifyListener(this.requestURLModifyListener);
        this.txtRequestURL.setText(newUrl);
        this.txtRequestURL.addModifyListener(this.requestURLModifyListener);
    }

    private List<NameValuePair> toNameValuePair(List<WebElementPropertyEntity> propertyEntities) {
        return propertyEntities.stream().map(pr -> new NameValuePair(pr.getName(), pr.getValue())).collect(Collectors.toList());
    }

    @Override
    protected void handleRequestParamNameChanged(Object element, Object value) {
        if (element != null && element instanceof WebElementPropertyEntity && value != null && value instanceof String) {
            WebElementPropertyEntity paramProperty = (WebElementPropertyEntity)element;
            paramProperty.setName((String)value);
            this.tblParams.refresh();
            this.tblParams.markDirty();
            Object paramProperties = this.tblParams.getInput();
            this.updateRequestUrlWithNewParams((List<WebElementPropertyEntity>)paramProperties);
        }
    }

    @Override
    protected void handleRequestParamValueChanged(Object element, Object value) {
        if (element != null && element instanceof WebElementPropertyEntity && value != null && value instanceof String) {
            WebElementPropertyEntity paramProperty = (WebElementPropertyEntity)element;
            paramProperty.setValue((String)value);
            this.tblParams.refresh();
            this.tblParams.markDirty();
            Object paramProperties = this.tblParams.getInput();
            this.updateRequestUrlWithNewParams((List<WebElementPropertyEntity>)paramProperties);
        }
    }

    @Override
    protected void addTabBody(CTabFolder parent) {
        super.addTabBody(parent);
        Composite tabComposite = (Composite)this.tabBody.getControl();
        Composite tabBodyComposite = new Composite(tabComposite, 0);
        tabBodyComposite.setLayout((Layout)new GridLayout());
        this.requestBodyEditor = new HttpBodyEditorComposite(tabBodyComposite, 0, this);
        this.requestBodyEditor.setLayoutData(new GridData(4, 4, true, true));
        this.lblBodyNotSupported = new Label(tabBodyComposite, 0);
        this.lblBodyNotSupported.setLayoutData((Object)new GridData(4, 4, true, false));
    }

    @Override
    protected void addTabValidation(CTabFolder parent) {
        super.addTabValidation(parent);
        Composite tabComposite = (Composite)this.tabValidation.getControl();
        this.validationComposite = new ValidationComposite(tabComposite, 0);
        this.validationComposite.addListener(24, event -> this.setDirty(true));
    }

    @Override
    protected void createResponseComposite(Composite parent) {
        super.createResponseComposite(parent);
        this.responseBodyEditor = new ResponseBodyEditorsComposite(this.responseBodyComposite, 0, this);
        this.responseBodyEditor.setLayoutData(new GridData(4, 4, true, true));
    }

    @Override
    protected SourceViewer createSourceViewer(Composite parent, GridData layoutData) {
        SourceViewer sv = super.createSourceViewer(parent, layoutData);
        sv.configure(new SourceViewerConfiguration());
        return sv;
    }

    @Override
    protected void preSaving() {
        this.tblParams.removeEmptyProperty();
        this.updateRequestUrlWithNewParams((List<WebElementPropertyEntity>)this.tblParams.getInput());
        this.originalWsObject.setRestUrl(this.getRequestURL());
        String requestMethod = this.getRequestMethod();
        this.originalWsObject.setRestRequestMethod(requestMethod);
        this.tblHeaders.removeEmptyProperty();
        this.originalWsObject.setHttpHeaderProperties((List)this.tblHeaders.getInput());
        if (this.requestBodyEditor.getHttpBodyType() != null) {
            String bodyType = this.requestBodyEditor.getHttpBodyType();
            String bodyContent = this.requestBodyEditor.getHttpBodyContent();
            this.originalWsObject.setHttpBodyContent(bodyContent);
            this.originalWsObject.setHttpBodyType(bodyType);
        }
        this.originalWsObject.setAutoUpdateContent(this.requestBodyEditor.isAutoUpdateContent());
        this.originalWsObject.setValidationSteps(this.validationComposite.getPureValidationSteps());
        this.updatePartImage();
    }

    @Override
    protected void populateDataToUI() {
        WebServiceRequestEntity clone = (WebServiceRequestEntity)this.originalWsObject.clone();
        String restUrl = clone.getRestUrl();
        this.setRequestURL(restUrl);
        this.updateParamsTable(restUrl);
        this.tempPropList = new ArrayList(clone.getHttpHeaderProperties());
        this.httpHeaders.clear();
        this.httpHeaders.addAll(this.tempPropList);
        this.tblHeaders.refresh();
        this.populateBasicAndBearerAuthFromHeader();
        this.populateOAuth1FromHeader();
        this.populateNTLMAuthorization();
        this.populateOAuth2FromHeader();
        this.renderAuthenticationUI(this.ccbAuthType.getText());
        this.updateHeaders(clone);
        this.requestBodyEditor.setInput(clone);
        this.validationComposite.setValidationSteps(clone.getValidationSteps());
        this.cbFollowRedirects.setSelection(this.originalWsObject.isFollowRedirects());
        this.populateVariableManualView();
        this.populateVariableScriptView();
        this.reloadVerificationScript();
        this.dirtyable.setDirty(false);
    }

    private String getRequestURL() {
        return this.txtRequestURL.getText();
    }

    private void setRequestURL(String url) {
        this.txtRequestURL.setText(url);
    }

    private String getRequestMethod() {
        return this.cbbRequestMethod.getText();
    }

    @Override
    public void updateHeaders(WebServiceRequestEntity cloneWS) {
        this.tempPropList = new ArrayList(cloneWS.getHttpHeaderProperties());
        this.httpHeaders.clear();
        this.httpHeaders.addAll(this.tempPropList);
        this.tblHeaders.refresh();
    }

    @PreDestroy
    public void preClose() {
        if (this.progress != null) {
            this.progress.getProgressMonitor().setCanceled(true);
        }
    }

    @Override
    protected void updatePartImage() {
        this.updateIconURL(WebServiceUtil.getRequestMethodIcon(this.originalWsObject.getServiceType(), this.originalWsObject.getRestRequestMethod()));
    }

    public boolean isDirty() {
        return this.mPart.isDirty();
    }

    @Override
    public void handleEvent(Event event) {
        super.handleEvent(event);
        if (this.cbbRequestMethod == null || this.cbbRequestMethod.isDisposed()) {
            return;
        }
        if ("WEBSERVICE/UPDATE_METHODS".equals(event.getTopic())) {
            this.cbbRequestMethod.setItems(this.getRestRequestMethods());
        }
    }

    private static /* synthetic */ void lambda$4(List list, List list2, int i) {
        boolean bl = list.add((WebElementPropertyEntity)list2.get(i));
    }
}

