/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.soapui;

import com.kms.katalon.composer.webservice.importing.model.RestServiceImportResult;
import com.kms.katalon.composer.webservice.importing.model.WebServiceImportNode;
import com.kms.katalon.composer.webservice.soapui.SoapUIOAuth1Credential;
import com.kms.katalon.composer.webservice.soapui.SoapUIOAuth2Credential;
import com.kms.katalon.composer.websesrvice.wsdl.SoapRequestFolderImportResult;
import com.kms.katalon.entity.folder.FolderEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SoapUIProjectImportResult
extends WebServiceImportNode {
    private FolderEntity projectFolder;
    private List<RestServiceImportResult> restServiceImportResults = new ArrayList<RestServiceImportResult>();
    private List<SoapRequestFolderImportResult> soapServiceImportResults = new ArrayList<SoapRequestFolderImportResult>();
    private Set<String> serviceFolderNames = new HashSet<String>();
    private List<SoapUIOAuth1Credential> oAuth1Credentials = new ArrayList<SoapUIOAuth1Credential>();
    private List<SoapUIOAuth2Credential> oauth2Credentials = new ArrayList<SoapUIOAuth2Credential>();

    public SoapUIProjectImportResult(String name, FolderEntity parentFolder) {
        this.projectFolder = this.newFolder(name, parentFolder);
    }

    public FolderEntity getFileEntity() {
        return this.projectFolder;
    }

    public RestServiceImportResult newRestService(String name) {
        RestServiceImportResult serviceResult = new RestServiceImportResult(name, this);
        this.restServiceImportResults.add(serviceResult);
        return serviceResult;
    }

    public SoapRequestFolderImportResult newSoapRequestFolder(String name, String wsdlLocation, String method) {
        SoapRequestFolderImportResult serviceResult = new SoapRequestFolderImportResult(name, wsdlLocation, method, this);
        this.soapServiceImportResults.add(serviceResult);
        return serviceResult;
    }

    public SoapUIOAuth1Credential newOAuth1Credential(String profileName) {
        SoapUIOAuth1Credential credential = new SoapUIOAuth1Credential(profileName);
        this.oAuth1Credentials.add(credential);
        return credential;
    }

    public SoapUIOAuth1Credential getOAuth1CredentialByProfile(String profileName) {
        return this.oAuth1Credentials.stream().filter(c -> c.getProfileName().equals(profileName)).findAny().orElse(null);
    }

    public SoapUIOAuth2Credential newOAuth2Credential(String profileName) {
        SoapUIOAuth2Credential credential = new SoapUIOAuth2Credential(profileName);
        this.oauth2Credentials.add(credential);
        return credential;
    }

    public SoapUIOAuth2Credential getOAuth2CredentialByProfile(String profileName) {
        return this.oauth2Credentials.stream().filter(c -> c.getProfileName().equals(profileName)).findAny().orElse(null);
    }

    public boolean isServiceFolderNameAvailable(String folderName) {
        return !this.serviceFolderNames.contains(folderName);
    }

    @Override
    public WebServiceImportNode getParentImportNode() {
        return null;
    }

    @Override
    public List<WebServiceImportNode> getChildImportNodes() {
        ArrayList<WebServiceImportNode> childNodes = new ArrayList<WebServiceImportNode>();
        childNodes.addAll(this.restServiceImportResults);
        childNodes.addAll(this.soapServiceImportResults);
        return Collections.unmodifiableList(childNodes);
    }
}

