/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.soapui;

import com.kms.katalon.composer.webservice.importing.model.RestMethodImportResult;
import com.kms.katalon.composer.webservice.importing.model.RestParameterImportResult;
import com.kms.katalon.composer.webservice.importing.model.RestRequestImportResult;
import com.kms.katalon.composer.webservice.importing.model.WebServiceImportNode;
import com.kms.katalon.composer.webservice.soapui.SoapUIAttachment;
import com.kms.katalon.composer.webservice.soapui.SoapUIBasicCredential;
import com.kms.katalon.composer.webservice.soapui.SoapUIOAuth1Credential;
import com.kms.katalon.composer.webservice.soapui.SoapUIOAuth2Credential;
import com.kms.katalon.composer.webservice.soapui.SoapUIProjectImportResult;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.entity.repository.WebElementPropertyEntity;
import com.kms.katalon.entity.webservice.FormDataBodyParameter;
import com.kms.katalon.entity.webservice.HttpBodyContent;
import com.kms.katalon.entity.webservice.ParameterizedBodyContent;
import com.kms.katalon.entity.webservice.TextBodyContent;
import com.kms.katalon.entity.webservice.UrlEncodedBodyParameter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class SoapUIRestRequestImportResult
extends RestRequestImportResult {
    private static final String APPLICATION_JSON_CONTENT_TYPE = "application/json";
    private static final String APPLICATION_XML_CONTENT_TYPE = "application/xml";
    private static final String TEXT_XML_CONTENT_TYPE = "text/xml";
    private static final String MULTIPART_FORM_DATA_CONTENT_TYPE = "multipart/form-data";
    private static final String FORM_URLENCODED_CONTENT_TYPE = "application/x-www-form-urlencoded";
    private static final String FILE_QUERY_PARAM_PREFIX = "file:";
    private SoapUIProjectImportResult projectImportResult;
    private String endpoint;
    private boolean postQueryString;
    private String encoding;
    private List<SoapUIAttachment> attachments = new ArrayList<SoapUIAttachment>();
    private Map<String, String> headers = new HashMap<String, String>();
    private SoapUIBasicCredential basicCredential;
    private String oAuth1ProfileName;
    private String oAuth2ProfileName;

    public SoapUIRestRequestImportResult(String name, RestMethodImportResult methodResult) {
        super(name, methodResult);
    }

    public void setHeader(String name, String value) {
        this.headers.put(name, value);
    }

    public void setPostQueryString(boolean postQueryString) {
        this.postQueryString = postQueryString;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setParameterOrder(String[] parameterOrder) {
        List<String> parameterOrderList = Arrays.asList(parameterOrder);
        this.parameters.sort((p1, p2) -> parameterOrderList.indexOf(p1.getName()) - parameterOrderList.indexOf(p2.getName()));
    }

    public SoapUIAttachment newAttachment(String name, String contentType, String contentId, String url) {
        SoapUIAttachment attachment = new SoapUIAttachment();
        attachment.setName(name);
        attachment.setContentType(contentType);
        attachment.setContentId(contentId);
        attachment.setUrl(url);
        this.attachments.add(attachment);
        return attachment;
    }

    @Override
    protected String getBaseUrl() {
        String resourcePath;
        String serviceBasePath;
        StringBuilder urlBuilder = new StringBuilder();
        if (StringUtils.isNotBlank((String)this.endpoint)) {
            urlBuilder.append(this.endpoint);
            if (this.endpoint.endsWith("/")) {
                urlBuilder.deleteCharAt(this.endpoint.length() - 1);
            }
        }
        if (StringUtils.isNotBlank((String)(serviceBasePath = this.getServiceBasePath()))) {
            urlBuilder.append(serviceBasePath);
        }
        if (StringUtils.isNotBlank((String)(resourcePath = this.getResourcePath()))) {
            urlBuilder.append(resourcePath);
        }
        return urlBuilder.toString();
    }

    private SoapUIProjectImportResult getProjectImportResult() {
        if (this.projectImportResult == null) {
            WebServiceImportNode importNode = this.methodImportResult;
            while (!(importNode instanceof SoapUIProjectImportResult)) {
                importNode = ((WebServiceImportNode)importNode).getParentImportNode();
            }
            this.projectImportResult = (SoapUIProjectImportResult)importNode;
        }
        return this.projectImportResult;
    }

    @Override
    protected List<WebElementPropertyEntity> getRequestHeaders() {
        Map<String, String> map;
        String string;
        LinkedHashMap<String, String> combinedHeaders = new LinkedHashMap<String, String>();
        for (RestParameterImportResult restParameterImportResult : this.getHeaderParameters()) {
            combinedHeaders.put(restParameterImportResult.getName(), restParameterImportResult.getValue());
        }
        for (Map.Entry entry : this.headers.entrySet()) {
            combinedHeaders.put((String)entry.getKey(), (String)entry.getValue());
        }
        if (this.isBodySupported() && !combinedHeaders.containsKey("Content-Type") && StringUtils.isNotBlank((String)(string = this.getDefaultContentTypeHeaderValue()))) {
            combinedHeaders.put("Content-Type", string);
        }
        if ((map = this.getAuthHeaders()) != null) {
            combinedHeaders.putAll(map);
        }
        return combinedHeaders.entrySet().stream().map(e -> {
            WebElementPropertyEntity headerPropertyEntity = new WebElementPropertyEntity();
            headerPropertyEntity.setName((String)e.getKey());
            headerPropertyEntity.setValue((String)e.getValue());
            return headerPropertyEntity;
        }).collect(Collectors.toList());
    }

    private String getDefaultContentTypeHeaderValue() {
        StringBuilder builder = new StringBuilder();
        if (StringUtils.isNotBlank((String)this.mediaType)) {
            builder.append(this.mediaType);
        }
        if (StringUtils.isNotBlank((String)this.encoding)) {
            builder.append(";charset=");
            builder.append(this.encoding);
        }
        return builder.toString();
    }

    private Map<String, String> getAuthHeaders() {
        if (this.basicCredential != null) {
            return this.basicCredential.getAuthHeaders();
        }
        SoapUIOAuth1Credential oAuth1Credential = this.getOAuth1Credential();
        if (oAuth1Credential != null) {
            return oAuth1Credential.getAuthHeaders();
        }
        SoapUIOAuth2Credential oAuth2Credential = this.getOAuth2Credential();
        if (oAuth2Credential != null) {
            return oAuth2Credential.getAuthHeaders();
        }
        return null;
    }

    private SoapUIOAuth1Credential getOAuth1Credential() {
        if (StringUtils.isBlank((String)this.oAuth1ProfileName)) {
            return null;
        }
        SoapUIProjectImportResult projectImportResult = this.getProjectImportResult();
        return projectImportResult.getOAuth1CredentialByProfile(this.oAuth1ProfileName);
    }

    protected void setOAuth1Profile(String oAuth1ProfileName) {
        this.oAuth1ProfileName = oAuth1ProfileName;
    }

    private SoapUIOAuth2Credential getOAuth2Credential() {
        if (StringUtils.isBlank((String)this.oAuth2ProfileName)) {
            return null;
        }
        SoapUIProjectImportResult projectImportResult = this.getProjectImportResult();
        return projectImportResult.getOAuth2CredentialByProfile(this.oAuth2ProfileName);
    }

    protected void setOAuth2Profile(String oAuth2ProfileName) {
        this.oAuth2ProfileName = oAuth2ProfileName;
    }

    @Override
    protected String getHttpBodyContent() {
        if (this.isBodySupported()) {
            HttpBodyContent httpBodyContent = this.getBodyContent();
            return JsonUtil.toJson((Object)httpBodyContent);
        }
        return "";
    }

    private boolean isBodySupported() {
        List<String> BODY_SUPPORTED_METHODS = Arrays.asList("POST", "PUT", "DELETE", "PATCH", "PROPFIND", "LOCK");
        return BODY_SUPPORTED_METHODS.contains(this.httpMethod);
    }

    @Override
    protected String getHttpBodyType() {
        switch (this.mediaType) {
            case "application/xml": 
            case "text/xml": 
            case "application/json": {
                return "text";
            }
            case "application/x-www-form-urlencoded": {
                return "x-www-form-urlencoded";
            }
            case "multipart/form-data": {
                return "form-data";
            }
        }
        return "text";
    }

    private HttpBodyContent getBodyContent() {
        switch (this.mediaType) {
            case "application/xml": 
            case "text/xml": 
            case "application/json": {
                return this.getTextBodyContent();
            }
            case "application/x-www-form-urlencoded": {
                return this.getUrlEncodedBodyContent();
            }
            case "multipart/form-data": {
                return this.getFormDataBodyContent();
            }
        }
        return null;
    }

    private HttpBodyContent getTextBodyContent() {
        TextBodyContent httpBody = new TextBodyContent();
        httpBody.setContentType(this.mediaType);
        httpBody.setText(this.bodyContent);
        return httpBody;
    }

    private HttpBodyContent getUrlEncodedBodyContent() {
        ParameterizedBodyContent httpBody = new ParameterizedBodyContent();
        List<UrlEncodedBodyParameter> bodyParameters = this.getUrlEncodedBodyParameters();
        bodyParameters.stream().forEach(p -> httpBody.addParameter(p));
        httpBody.setContentType(FORM_URLENCODED_CONTENT_TYPE);
        httpBody.setCharset(StandardCharsets.UTF_8.name());
        return httpBody;
    }

    private List<UrlEncodedBodyParameter> getUrlEncodedBodyParameters() {
        if (this.postQueryString) {
            List<RestParameterImportResult> queryParameters = this.getQueryParameters();
            return queryParameters.stream().map(p -> {
                UrlEncodedBodyParameter urlEncodedParameter = new UrlEncodedBodyParameter();
                urlEncodedParameter.setName(p.getName());
                urlEncodedParameter.setValue(p.getValue());
                return urlEncodedParameter;
            }).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private HttpBodyContent getFormDataBodyContent() {
        ParameterizedBodyContent httpBody = new ParameterizedBodyContent();
        List<FormDataBodyParameter> bodyParameters = this.getFormDataBodyParameters();
        bodyParameters.stream().forEach(p -> httpBody.addParameter(p));
        httpBody.setContentType(MULTIPART_FORM_DATA_CONTENT_TYPE);
        httpBody.setCharset(StandardCharsets.UTF_8.name());
        return httpBody;
    }

    private List<FormDataBodyParameter> getFormDataBodyParameters() {
        ArrayList<FormDataBodyParameter> formDataBodyParameters = new ArrayList<FormDataBodyParameter>();
        if (StringUtils.isNotBlank((String)this.bodyContent)) {
            FormDataBodyParameter bodyContentParam = new FormDataBodyParameter();
            bodyContentParam.setName("");
            bodyContentParam.setValue(this.bodyContent);
            bodyContentParam.setType("Text");
            formDataBodyParameters.add(bodyContentParam);
        }
        if (this.postQueryString) {
            formDataBodyParameters.addAll(this.getFormDataBodyParametersIfPostQueryString());
        }
        return formDataBodyParameters;
    }

    private List<FormDataBodyParameter> getFormDataBodyParametersIfPostQueryString() {
        List<RestParameterImportResult> queryParameters = this.getQueryParameters();
        return queryParameters.stream().map(p -> {
            FormDataBodyParameter formDataParameter = new FormDataBodyParameter();
            formDataParameter.setName(p.getName());
            String value = p.getValue();
            if (value.startsWith(FILE_QUERY_PARAM_PREFIX)) {
                formDataParameter.setType("File");
                String attachmentName = value.substring(FILE_QUERY_PARAM_PREFIX.length());
                SoapUIAttachment attachment = this.getAttachmentWithName(attachmentName);
                if (attachment != null) {
                    formDataParameter.setValue(attachment.getUrl());
                    formDataParameter.setContentType(attachment.getContentType());
                } else {
                    formDataParameter.setValue("");
                }
            } else {
                formDataParameter.setType("Text");
                formDataParameter.setValue(p.getValue());
            }
            return formDataParameter;
        }).collect(Collectors.toList());
    }

    private SoapUIAttachment getAttachmentWithName(String name) {
        return this.attachments.stream().filter(a -> name.equals(a.getName())).findAny().orElse(null);
    }

    public void setBasicCredential(String username, String password) {
        if (this.basicCredential == null) {
            this.basicCredential = new SoapUIBasicCredential();
        }
        this.basicCredential.setUsername(username);
        this.basicCredential.setPassword(password);
    }

    @Override
    public List<RestParameterImportResult> getUrlQueryParameters() {
        List<RestParameterImportResult> queryParameters = super.getQueryParameters();
        if (!queryParameters.isEmpty() && !this.postQueryString) {
            return queryParameters;
        }
        return Collections.emptyList();
    }
}

