/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.soapui;

import com.eviware.soapui.config.AbstractRequest;
import com.eviware.soapui.config.Credentials;
import com.eviware.soapui.config.Operation;
import com.eviware.soapui.config.SoapVersionTypes;
import com.eviware.soapui.config.WsdlInterface;
import com.eviware.soapui.config.WsdlRequest;
import com.kms.katalon.composer.webservice.soapui.SoapUIProjectImportResult;
import com.kms.katalon.composer.webservice.soapui.SoapUISoapRequestImportResult;
import com.kms.katalon.composer.webservice.soapui.SoapUIWebServiceImporter;
import com.kms.katalon.composer.websesrvice.wsdl.SoapRequestFolderImportResult;
import org.apache.commons.lang3.StringUtils;

public class SoapUISoapServiceImporter
extends SoapUIWebServiceImporter {
    public void importService(SoapUIProjectImportResult projectImportResult, WsdlInterface wsdlInterface) {
        String serviceName = wsdlInterface.getName();
        String wsdlLocation = wsdlInterface.getDefinition();
        String method = this.getBindingMethod(wsdlInterface);
        SoapRequestFolderImportResult requestFolder = projectImportResult.newSoapRequestFolder(serviceName, wsdlLocation, method);
        Operation[] operationArray = wsdlInterface.getOperationArray();
        if (operationArray != null) {
            Operation[] operationArray2 = operationArray;
            int n = operationArray.length;
            int n2 = 0;
            while (n2 < n) {
                Operation operation = operationArray2[n2];
                SoapRequestFolderImportResult childRequestFolder = requestFolder.newChildRequestFolder(operation.getBindingOperationName());
                WsdlRequest[] callArray = operation.getCallArray();
                if (callArray != null) {
                    WsdlRequest[] wsdlRequestArray = callArray;
                    int n3 = callArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        WsdlRequest call = wsdlRequestArray[n4];
                        SoapUISoapRequestImportResult requestResult = childRequestFolder.newRequest(call.getName(), name -> new SoapUISoapRequestImportResult((String)name, childRequestFolder));
                        requestResult.setServiceEndpoint(call.getEndpoint());
                        requestResult.setOperationName(operation.getBindingOperationName());
                        String requestMessage = call.getRequest().getStringValue();
                        requestMessage = StringUtils.isNotBlank((CharSequence)requestMessage) ? requestMessage.replaceAll("\\\\r", "") : "";
                        requestResult.setRequestMessage(requestMessage);
                        this.addHeaders(requestResult, call);
                        this.addCredential(requestResult, call);
                        ++n4;
                    }
                }
                ++n2;
            }
        }
    }

    private String getBindingMethod(WsdlInterface wsdlInterface) {
        SoapVersionTypes.Enum soapVersion = wsdlInterface.getSoapVersion();
        if (soapVersion == SoapVersionTypes.X_1_1) {
            return "SOAP";
        }
        if (soapVersion == SoapVersionTypes.X_1_2) {
            return "SOAP12";
        }
        return "";
    }

    private void addHeaders(SoapUISoapRequestImportResult requestImportResult, WsdlRequest soapRequest) {
        this.getHeaderMap((AbstractRequest)soapRequest).entrySet().forEach(e -> requestImportResult.setHeader((String)e.getKey(), (String)e.getValue()));
    }

    private void addCredential(SoapUISoapRequestImportResult requestImportResult, WsdlRequest soapRequest) {
        String authProfile;
        Credentials credentials = soapRequest.getCredentials();
        if (credentials != null && StringUtils.isNotBlank((CharSequence)credentials.getSelectedAuthProfile()) && "Basic".equals(authProfile = credentials.getSelectedAuthProfile())) {
            requestImportResult.setBasicCredential(credentials.getUsername(), credentials.getPassword());
            return;
        }
    }
}

