/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.view;

import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.impl.control.ScrollableComposite;
import com.kms.katalon.composer.components.impl.event.EventServiceAdapter;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.webservice.constants.ImageConstants;
import com.kms.katalon.composer.webservice.constants.StringConstants;
import com.kms.katalon.composer.webservice.view.ImportFromWsdlDialog;
import com.kms.katalon.composer.webservice.view.ImportWebServiceObjectsFromSwaggerDialog;
import com.kms.katalon.controller.ObjectRepositoryController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.project.ProjectType;
import com.kms.katalon.entity.repository.DraftWebServiceRequestEntity;
import com.kms.katalon.entity.repository.WebElementEntity;
import com.kms.katalon.entity.repository.WebServiceRequestEntity;
import com.kms.katalon.tracking.service.Trackings;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class ApiQuickStartPart {
    private static final Color RIGHT_PART_BACKGROUND_COLOR = ColorUtil.getColor((String)"#F7F7F7");
    private static final Point LEFT_PART_SIZE = new Point(1000, 2150);
    private static final Point QUICKSTART_ITEM_SIZE = new Point(200, 47);
    private ITreeEntity parentTreeEntity;
    private ProjectType projectType;
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private EPartService partService;
    private MPart part;
    @Inject
    private EModelService modelService;
    private Composite mainComposite;

    @PostConstruct
    public void initialize(Composite parent, MPart part) {
        this.part = part;
        this.projectType = ProjectController.getInstance().getCurrentProject().getType();
        this.createDialogArea(parent);
        this.registerEventListeners();
    }

    private void registerEventListeners() {
        this.eventBroker.subscribe("PROJECT/CREATED", (EventHandler)new EventServiceAdapter(){

            public void handleEvent(Event event) {
                if (ApiQuickStartPart.this.part.isVisible()) {
                    ApiQuickStartPart.this.partService.hidePart(ApiQuickStartPart.this.part, true);
                }
                ApiQuickStartPart.this.part.setVisible(true);
            }
        });
    }

    protected void createDialogArea(Composite parent) {
        FillLayout parentLayout = new FillLayout();
        parentLayout.marginHeight = 0;
        parentLayout.marginWidth = 0;
        parent.setLayout((Layout)parentLayout);
        final ScrollableComposite container = new ScrollableComposite(parent, 768);
        this.mainComposite = new Composite((Composite)container, 0);
        this.mainComposite.setBackground(ColorUtil.getCompositeBackgroundColor());
        this.mainComposite.setBackgroundMode(2);
        GridLayout mainGridLayout = new GridLayout(2, false);
        mainGridLayout.verticalSpacing = 0;
        mainGridLayout.horizontalSpacing = 0;
        mainGridLayout.marginWidth = 0;
        mainGridLayout.marginHeight = 0;
        this.mainComposite.setLayout((Layout)mainGridLayout);
        this.mainComposite.addListener(9, new Listener(){

            public void handleEvent(org.eclipse.swt.widgets.Event event) {
                Point size = ApiQuickStartPart.this.mainComposite.computeSize(-1, -1);
                if (container.getMinHeight() < size.y) {
                    container.setMinHeight(size.y);
                }
            }
        });
        container.setContent((Control)this.mainComposite);
        container.setMinSize(this.getLeftPartSize());
        container.setExpandHorizontal(true);
        container.setExpandVertical(true);
        switch (this.projectType) {
            case WEBSERVICE: {
                this.createLeftPart(this.mainComposite);
                this.createRightPart(this.mainComposite);
                break;
            }
            case WEBUI: 
            case GENERIC: {
                this.mainComposite.setBackground(ColorUtil.getWhiteBackgroundColor());
                this.createLeftPart(this.mainComposite);
                break;
            }
            case MOBILE: {
                this.mainComposite.setBackground(ColorUtil.getWhiteBackgroundColor());
                this.createLeftPart(this.mainComposite);
                break;
            }
        }
    }

    private Point getLeftPartSize() {
        switch (this.projectType) {
            case MOBILE: {
                return new Point(1000, 2150);
            }
            case WEBSERVICE: {
                return new Point(900, 1700);
            }
        }
        return new Point(1000, 1700);
    }

    public void createLeftPart(Composite parent) {
        switch (this.projectType) {
            case WEBSERVICE: {
                Composite imageComposite = new Composite(parent, 16384);
                GridData gridData = new GridData(4, 4, false, false);
                Image backgroundImg = ImageConstants.API_QUICKSTART_BACKGROUND_LEFT;
                gridData.widthHint = backgroundImg.getBounds().width;
                gridData.heightHint = backgroundImg.getBounds().height;
                imageComposite.setLayoutData((Object)gridData);
                imageComposite.setBackgroundImage(backgroundImg);
                break;
            }
            case WEBUI: 
            case GENERIC: {
                Composite imageComposite = new Composite(parent, 0);
                GridData gridData = new GridData(0x1000000, 4, true, false);
                Image backgroundWImg = ImageConstants.API_QUICKSTART_BACKGROUND_WEB_LEFT;
                gridData.widthHint = backgroundWImg.getBounds().width;
                gridData.heightHint = backgroundWImg.getBounds().height;
                imageComposite.setLayoutData((Object)gridData);
                imageComposite.setBackgroundImage(backgroundWImg);
                break;
            }
            case MOBILE: {
                Composite imageComposite = new Composite(parent, 0);
                GridData gridData = new GridData(0x1000000, 4, true, false);
                Image backgroundMImg = ImageConstants.API_QUICKSTART_BACKGROUND_MOBILE_LEFT;
                gridData.widthHint = backgroundMImg.getBounds().width;
                gridData.heightHint = backgroundMImg.getBounds().height;
                imageComposite.setLayoutData((Object)gridData);
                imageComposite.setBackgroundImage(backgroundMImg);
                break;
            }
        }
    }

    public void createRightPart(Composite parent) {
        Composite rightComposite = new Composite(parent, 131072);
        GridLayout glRight = new GridLayout(1, false);
        glRight.marginWidth = 0;
        glRight.marginHeight = 0;
        glRight.marginLeft = 0;
        glRight.marginTop = 250;
        rightComposite.setLayout((Layout)glRight);
        rightComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        rightComposite.setBackground(RIGHT_PART_BACKGROUND_COLOR);
        Composite quickStartItemComposite = new Composite(rightComposite, 0);
        GridLayout glQuickStartItemComposite = new GridLayout(1, false);
        glQuickStartItemComposite.marginWidth = 0;
        glQuickStartItemComposite.marginHeight = 0;
        glQuickStartItemComposite.horizontalSpacing = 0;
        glQuickStartItemComposite.verticalSpacing = 0;
        quickStartItemComposite.setLayout((Layout)glQuickStartItemComposite);
        quickStartItemComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        quickStartItemComposite.setBackground(RIGHT_PART_BACKGROUND_COLOR);
        this.createNewRestRequestItem(quickStartItemComposite);
        this.createNewSoapRequestItem(quickStartItemComposite);
        this.createImportRestRequestItem(quickStartItemComposite);
        this.createImportSoapRequestItem(quickStartItemComposite);
    }

    private Composite createQuickStartItem(Composite parent, Image image, String toolTip, Listener selectionListener) {
        CLabel lblItem = new CLabel(parent, 0);
        GridData gdItem = new GridData(0x1000000, 4, true, false);
        gdItem.widthHint = ApiQuickStartPart.QUICKSTART_ITEM_SIZE.x;
        gdItem.heightHint = ApiQuickStartPart.QUICKSTART_ITEM_SIZE.y;
        lblItem.setLayoutData((Object)gdItem);
        lblItem.setToolTipText(toolTip);
        lblItem.setBackground(RIGHT_PART_BACKGROUND_COLOR);
        lblItem.setBackground(image);
        lblItem.setCursor(Display.getCurrent().getSystemCursor(21));
        lblItem.addListener(3, selectionListener);
        return lblItem;
    }

    private Composite createNewRestRequestItem(Composite parent) {
        Composite item = this.createQuickStartItem(parent, ImageConstants.NEW_DRAFT_REST_REQUEST, StringConstants.QUICKSTART_NEW_DRAFT_REST_REQUEST, e -> this.createNewRestRequest());
        return item;
    }

    private Composite createNewSoapRequestItem(Composite parent) {
        Composite item = this.createQuickStartItem(parent, ImageConstants.NEW_DRAFT_SOAP_REQUEST, StringConstants.QUICKSTART_NEW_DRAFT_SOAP_REQUEST, e -> this.createNewSoapRequest());
        return item;
    }

    private Composite createImportRestRequestItem(Composite parent) {
        Composite item = this.createQuickStartItem(parent, ImageConstants.IMPORT_SWAGGER, StringConstants.QUICKSTART_IMPORT_SWAGGER_FROM_FILE_OR_URL, e -> this.importSwaggerFromFileOrUrl());
        return item;
    }

    private Composite createImportSoapRequestItem(Composite parent) {
        Composite item = this.createQuickStartItem(parent, ImageConstants.IMPORT_WSDL, StringConstants.QUICKSTART_IMPORT_WSDL_FROM_FILE_OR_URL, e -> this.importWsdlFromUrl());
        return item;
    }

    private void createNewRestRequest() {
        DraftWebServiceRequestEntity entity = ObjectRepositoryController.getInstance().newDraftWebServiceEntity(ProjectController.getInstance().getCurrentProject());
        entity.setServiceType("RESTful");
        EventBrokerSingleton.getInstance().getEventBroker().post("EXPLORER/OPEN_DRAFT_WEBSERVICE", (Object)entity);
        Trackings.trackOpenDraftRequest((String)entity.getServiceType(), (String)"apiQuickStart");
        this.partService.hidePart(this.part);
    }

    private void createNewSoapRequest() {
        DraftWebServiceRequestEntity entity = ObjectRepositoryController.getInstance().newDraftWebServiceEntity(ProjectController.getInstance().getCurrentProject());
        entity.setServiceType("SOAP");
        EventBrokerSingleton.getInstance().getEventBroker().post("EXPLORER/OPEN_DRAFT_WEBSERVICE", (Object)entity);
        Trackings.trackOpenDraftRequest((String)entity.getServiceType(), (String)"apiQuickStart");
        this.partService.hidePart(this.part);
    }

    private void importSwaggerFromFileOrUrl() {
        try {
            FolderEntity parentFolderEntity = (FolderEntity)this.parentTreeEntity.getObject();
            ObjectRepositoryController toController = ObjectRepositoryController.getInstance();
            ImportWebServiceObjectsFromSwaggerDialog dialog = new ImportWebServiceObjectsFromSwaggerDialog(Display.getCurrent().getActiveShell(), parentFolderEntity);
            if (dialog.open() == 0) {
                List<WebServiceRequestEntity> requestEntities = dialog.getWebServiceRequestEntities();
                for (WebServiceRequestEntity entity : requestEntities) {
                    toController.saveNewTestObject((WebElementEntity)entity);
                }
                EventBrokerSingleton.getInstance().getEventBroker().post("EXPLORER/REFRESH_TREE_ENTITY", (Object)this.parentTreeEntity);
                EventBrokerSingleton.getInstance().getEventBroker().post("EXPLORER/SET_SELECTED_ITEM", (Object)this.parentTreeEntity);
                this.partService.hidePart(this.part);
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private void importWsdlFromUrl() {
        try {
            FolderEntity parentFolderEntity = (FolderEntity)this.parentTreeEntity.getObject();
            ImportFromWsdlDialog dialog = new ImportFromWsdlDialog(Display.getCurrent().getActiveShell(), parentFolderEntity);
            if (dialog.open() == 0) {
                this.partService.hidePart(this.part);
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    @Focus
    public void setFocus() {
        this.mainComposite.forceFocus();
    }
}

