/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.view;

import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.webservice.constants.ComposerWebserviceMessageConstants;
import com.kms.katalon.composer.webservice.constants.ImageConstants;
import com.kms.katalon.composer.webservice.constants.StringConstants;
import com.kms.katalon.entity.repository.DraftWebServiceRequestEntity;
import com.kms.katalon.entity.repository.WebServiceRequestEntity;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class WebServiceAPIControl
extends Composite {
    private ToolItem btnSend;
    private GridData layoutData;
    private boolean sendingState;
    private Menu menuSend;
    private MenuItem mniSendAndVerify;
    private ToolItem btnAddRequestToTestCase;
    private Menu menuAddRequestToTestCase;
    private MenuItem mniAddRequestToNewTestCase;
    private MenuItem mniAddRequestToExistingTestCase;
    private ToolItem btnSaveDraft;
    private WebServiceRequestEntity originalWsObject;

    public WebServiceAPIControl(Composite parent, WebServiceRequestEntity requestEntity) {
        super(parent, 0);
        this.originalWsObject = requestEntity;
        boolean isDraft = this.isDraft();
        this.setLayout((Layout)new GridLayout());
        this.createControl(isDraft);
    }

    private boolean isDraft() {
        return this.originalWsObject instanceof DraftWebServiceRequestEntity;
    }

    private void createControl(boolean isDraft) {
        ToolBar toolbar = new ToolBar((Composite)this, 131072);
        toolbar.setForeground(ColorUtil.getToolBarForegroundColor());
        this.btnSend = new ToolItem(toolbar, 4);
        this.setSendButtonState(false);
        this.menuSend = new Menu((Control)this.btnSend.getParent().getShell());
        this.mniSendAndVerify = new MenuItem(this.menuSend, 8);
        this.mniSendAndVerify.setText(StringConstants.MENU_ITEM_TEST_REQUEST_AND_VERIFY);
        this.mniSendAndVerify.setID(0);
        this.btnSend.setData((Object)this.menuSend);
        if (!isDraft) {
            this.btnAddRequestToTestCase = new ToolItem(toolbar, 4);
            this.btnAddRequestToTestCase.setImage(ImageConstants.WS_ADD_TO_TEST_CASE_24);
            this.btnAddRequestToTestCase.setToolTipText(ComposerWebserviceMessageConstants.BTN_ADD_TO_NEW_TEST_CASE);
            this.menuAddRequestToTestCase = new Menu((Control)this.btnAddRequestToTestCase.getParent().getShell());
            this.mniAddRequestToNewTestCase = new MenuItem(this.menuAddRequestToTestCase, 8);
            this.mniAddRequestToNewTestCase.setText(StringConstants.MENU_ITEM_ADD_REQUEST_TO_NEW_TEST_CASE);
            this.mniAddRequestToNewTestCase.setID(0);
            this.mniAddRequestToExistingTestCase = new MenuItem(this.menuAddRequestToTestCase, 8);
            this.mniAddRequestToExistingTestCase.setText(StringConstants.MENU_ITEM_ADD_REQUEST_TO_EXISTING_TEST_CASE);
            this.mniAddRequestToExistingTestCase.setID(1);
            this.btnAddRequestToTestCase.setData((Object)this.menuAddRequestToTestCase);
        }
        if (isDraft) {
            this.btnSaveDraft = new ToolItem(toolbar, 8);
            this.btnSaveDraft.setImage(ImageConstants.IMG_24_SAVE);
            this.btnSaveDraft.setToolTipText(ComposerWebserviceMessageConstants.BTN_SAVE_DRAFT_REQUEST);
        }
        toolbar.setLayoutData((Object)new GridData(0x1000000, 131072, false, true));
    }

    public void addSendSelectionListener(SelectionListener selectionListener) {
        if (selectionListener == null) {
            return;
        }
        this.btnSend.addSelectionListener(selectionListener);
    }

    public void addSendAndVerifySelectionListener(SelectionListener selectionListener) {
        if (selectionListener == null) {
            return;
        }
        this.mniSendAndVerify.addSelectionListener(selectionListener);
    }

    public void addAddRequestToTestCaseSelectionListener(SelectionListener selectionListener) {
        if (selectionListener == null) {
            return;
        }
        this.btnAddRequestToTestCase.addSelectionListener(selectionListener);
    }

    public void addAddRequestToNewTestCaseSelectionListener(SelectionListener selectionListener) {
        if (selectionListener == null) {
            return;
        }
        this.mniAddRequestToNewTestCase.addSelectionListener(selectionListener);
    }

    public void addAddRequestToExistingTestCaseSelectionListener(SelectionListener selectionListener) {
        if (selectionListener == null) {
            return;
        }
        this.mniAddRequestToExistingTestCase.addSelectionListener(selectionListener);
    }

    public void addSaveDraftSelectionListener(SelectionListener selectionListener) {
        if (selectionListener == null) {
            return;
        }
        this.btnSaveDraft.addSelectionListener(selectionListener);
    }

    public void setLayoutDataColumnsSpan(int numberOfColumn) {
        this.layoutData.horizontalSpan = numberOfColumn;
        this.layout();
    }

    public ToolItem getSendControl() {
        return this.btnSend;
    }

    protected void checkSubclass() {
    }

    public void setSendButtonState(boolean sendingState) {
        this.sendingState = sendingState;
        if (this.sendingState) {
            this.btnSend.setToolTipText(StringConstants.STOP);
            this.btnSend.setImage(ImageConstants.IMG_24_STOP);
        } else {
            this.btnSend.setToolTipText(ComposerWebserviceMessageConstants.BTN_SEND_TEST_REQUEST);
            this.btnSend.setImage(ImageConstants.IMG_24_PLAY);
        }
        this.btnSend.getParent().update();
    }

    public boolean getSendingState() {
        return this.sendingState;
    }

    public Menu getSendMenu() {
        return this.menuSend;
    }

    public Menu getAddRequestToTestCaseMenu() {
        return this.menuAddRequestToTestCase;
    }
}

