/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.view.xml;

import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class CDataRule
implements IRule {
    private IToken fToken;
    private StringBuffer buffer = new StringBuffer();
    private int charsRead = 0;
    private String matchString;
    private static final String START_MATCH_STRING = "<![CDATA[";
    private static final String END_MATCH_STRING = "]]>";

    public CDataRule(IToken token, boolean start) {
        this.fToken = token;
        this.matchString = start ? START_MATCH_STRING : END_MATCH_STRING;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        this.buffer.setLength(0);
        this.charsRead = 0;
        int c = this.read(scanner);
        if (c == this.matchString.charAt(0)) {
            while (this.isOK((char)(c = this.read(scanner)))) {
            }
            if (this.charsRead == this.matchString.length()) {
                return this.fToken;
            }
            this.rewind(scanner);
            return Token.UNDEFINED;
        }
        scanner.unread();
        return Token.UNDEFINED;
    }

    private void rewind(ICharacterScanner scanner) {
        int rewindLength = this.charsRead;
        while (rewindLength > 0) {
            scanner.unread();
            --rewindLength;
        }
    }

    private int read(ICharacterScanner scanner) {
        int c = scanner.read();
        this.buffer.append((char)c);
        ++this.charsRead;
        return c;
    }

    private boolean isOK(char c) {
        if (this.charsRead >= this.matchString.length()) {
            return false;
        }
        return this.matchString.charAt(this.charsRead - 1) == c;
    }
}

