/*
 * Decompiled with CFR 0.152.
 */
package ca.mestevens.ios.xcode.parser.models;

import ca.mestevens.ios.xcode.parser.exceptions.InvalidObjectFormatException;
import ca.mestevens.ios.xcode.parser.models.CommentedIdentifier;
import ca.mestevens.ios.xcode.parser.utils.ObjectParser;
import java.beans.ConstructorProperties;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PBXProject
implements Comparable<PBXProject> {
    private CommentedIdentifier reference;
    private String isa;
    private CommentedIdentifier buildConfigurationList;
    private String compatibilityVersion;
    private String developmentRegion;
    private Integer hasScannedForEncodings;
    private List<String> knownRegions;
    private CommentedIdentifier mainGroup;
    private CommentedIdentifier productRefGroup;
    private String projectDirPath;
    private String projectRoot;
    private List<CommentedIdentifier> targets;
    private String attributes;

    public PBXProject(String projectString) throws InvalidObjectFormatException {
        try {
            projectString = projectString.trim();
            int equalsIndex = projectString.indexOf(61);
            String commentPart = "";
            String uuidPart = projectString.substring(0, equalsIndex).trim();
            if (uuidPart.contains("/*")) {
                int commentStartIndex = uuidPart.indexOf("/*");
                int commentEndIndex = uuidPart.indexOf("*/");
                commentPart = projectString.substring(commentStartIndex + 2, commentEndIndex).trim();
                uuidPart = uuidPart.substring(0, commentStartIndex).trim();
            }
            this.reference = new CommentedIdentifier(uuidPart, commentPart);
            ObjectParser parser = new ObjectParser(projectString);
            parser = parser.getNextNestedObjects();
            String parserObject = parser.parseNextObject();
            while (parserObject != null) {
                parserObject = parserObject.substring(0, parserObject.length() - 1);
                String[] splitObject = parserObject.split("=");
                String key = splitObject[0].trim();
                String value = "";
                for (int i = 1; i < splitObject.length; ++i) {
                    if (i > 1) {
                        value = value + "=";
                    }
                    value = value + splitObject[i];
                }
                value = value.trim();
                if (key.equals("isa")) {
                    this.isa = value;
                } else if (key.equals("buildConfigurationList")) {
                    this.buildConfigurationList = parser.getCommentedIdentifier(value);
                } else if (key.equals("compatibilityVersion")) {
                    this.compatibilityVersion = value;
                } else if (key.equals("developmentRegion")) {
                    this.developmentRegion = value;
                } else if (key.equals("hasScannedForEncodings")) {
                    this.hasScannedForEncodings = Integer.valueOf(value);
                } else if (key.equals("knownRegions")) {
                    this.knownRegions = parser.getStringList(value);
                } else if (key.equals("mainGroup")) {
                    this.mainGroup = parser.getCommentedIdentifier(value);
                } else if (key.equals("productRefGroup")) {
                    this.productRefGroup = parser.getCommentedIdentifier(value);
                } else if (key.equals("projectDirPath")) {
                    this.projectDirPath = value;
                } else if (key.equals("projectRoot")) {
                    this.projectRoot = value;
                } else if (key.equals("targets")) {
                    this.targets = parser.getIdentifierList(value);
                } else if (key.equals("attributes")) {
                    this.attributes = value;
                }
                parserObject = parser.parseNextObject();
            }
        }
        catch (Exception ex) {
            throw new InvalidObjectFormatException(ex);
        }
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int numberOfTabs) {
        String tabString = "";
        for (int i = 0; i < numberOfTabs; ++i) {
            tabString = tabString + "\t";
        }
        String returnString = "";
        returnString = returnString + tabString + this.reference.toString() + " = {\n";
        returnString = returnString + tabString + "\tisa = " + this.isa + ";\n";
        if (this.attributes != null) {
            returnString = returnString + tabString + "\tattributes = " + this.attributes + ";\n";
        }
        returnString = returnString + tabString + "\tbuildConfigurationList = " + this.buildConfigurationList.toString() + ";\n";
        returnString = returnString + tabString + "\tcompatibilityVersion = " + this.compatibilityVersion + ";\n";
        returnString = returnString + tabString + "\tdevelopmentRegion = " + this.developmentRegion + ";\n";
        returnString = returnString + tabString + "\thasScannedForEncodings = " + this.hasScannedForEncodings + ";\n";
        returnString = returnString + tabString + "\tknownRegions = (\n";
        for (String knownRegion : this.knownRegions) {
            returnString = returnString + tabString + "\t\t" + knownRegion + ",\n";
        }
        returnString = returnString + tabString + "\t);\n";
        returnString = returnString + tabString + "\tmainGroup = " + this.mainGroup.toString() + ";\n";
        returnString = returnString + tabString + "\tproductRefGroup = " + this.productRefGroup.toString() + ";\n";
        returnString = returnString + tabString + "\tprojectDirPath = " + this.projectDirPath + ";\n";
        returnString = returnString + tabString + "\tprojectRoot = " + this.projectRoot + ";\n";
        returnString = returnString + tabString + "\ttargets = (\n";
        for (CommentedIdentifier target : this.targets) {
            returnString = returnString + tabString + "\t\t" + target.toString() + ",\n";
        }
        returnString = returnString + tabString + "\t);\n";
        returnString = returnString + tabString + "};";
        return returnString;
    }

    @Override
    public int compareTo(PBXProject o) {
        return this.reference.getIdentifier().compareTo(o.getReference().getIdentifier());
    }

    public CommentedIdentifier getReference() {
        return this.reference;
    }

    public String getIsa() {
        return this.isa;
    }

    public CommentedIdentifier getBuildConfigurationList() {
        return this.buildConfigurationList;
    }

    public String getCompatibilityVersion() {
        return this.compatibilityVersion;
    }

    public String getDevelopmentRegion() {
        return this.developmentRegion;
    }

    public Integer getHasScannedForEncodings() {
        return this.hasScannedForEncodings;
    }

    public List<String> getKnownRegions() {
        return this.knownRegions;
    }

    public CommentedIdentifier getMainGroup() {
        return this.mainGroup;
    }

    public CommentedIdentifier getProductRefGroup() {
        return this.productRefGroup;
    }

    public String getProjectDirPath() {
        return this.projectDirPath;
    }

    public String getProjectRoot() {
        return this.projectRoot;
    }

    public List<CommentedIdentifier> getTargets() {
        return this.targets;
    }

    public String getAttributes() {
        return this.attributes;
    }

    public void setReference(CommentedIdentifier reference) {
        this.reference = reference;
    }

    public void setIsa(String isa) {
        this.isa = isa;
    }

    public void setBuildConfigurationList(CommentedIdentifier buildConfigurationList) {
        this.buildConfigurationList = buildConfigurationList;
    }

    public void setCompatibilityVersion(String compatibilityVersion) {
        this.compatibilityVersion = compatibilityVersion;
    }

    public void setDevelopmentRegion(String developmentRegion) {
        this.developmentRegion = developmentRegion;
    }

    public void setHasScannedForEncodings(Integer hasScannedForEncodings) {
        this.hasScannedForEncodings = hasScannedForEncodings;
    }

    public void setKnownRegions(List<String> knownRegions) {
        this.knownRegions = knownRegions;
    }

    public void setMainGroup(CommentedIdentifier mainGroup) {
        this.mainGroup = mainGroup;
    }

    public void setProductRefGroup(CommentedIdentifier productRefGroup) {
        this.productRefGroup = productRefGroup;
    }

    public void setProjectDirPath(String projectDirPath) {
        this.projectDirPath = projectDirPath;
    }

    public void setProjectRoot(String projectRoot) {
        this.projectRoot = projectRoot;
    }

    public void setTargets(List<CommentedIdentifier> targets) {
        this.targets = targets;
    }

    public void setAttributes(String attributes) {
        this.attributes = attributes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PBXProject)) {
            return false;
        }
        PBXProject other = (PBXProject)o;
        if (!other.canEqual(this)) {
            return false;
        }
        CommentedIdentifier this$reference = this.getReference();
        CommentedIdentifier other$reference = other.getReference();
        if (this$reference == null ? other$reference != null : !((Object)this$reference).equals(other$reference)) {
            return false;
        }
        String this$isa = this.getIsa();
        String other$isa = other.getIsa();
        if (this$isa == null ? other$isa != null : !this$isa.equals(other$isa)) {
            return false;
        }
        CommentedIdentifier this$buildConfigurationList = this.getBuildConfigurationList();
        CommentedIdentifier other$buildConfigurationList = other.getBuildConfigurationList();
        if (this$buildConfigurationList == null ? other$buildConfigurationList != null : !((Object)this$buildConfigurationList).equals(other$buildConfigurationList)) {
            return false;
        }
        String this$compatibilityVersion = this.getCompatibilityVersion();
        String other$compatibilityVersion = other.getCompatibilityVersion();
        if (this$compatibilityVersion == null ? other$compatibilityVersion != null : !this$compatibilityVersion.equals(other$compatibilityVersion)) {
            return false;
        }
        String this$developmentRegion = this.getDevelopmentRegion();
        String other$developmentRegion = other.getDevelopmentRegion();
        if (this$developmentRegion == null ? other$developmentRegion != null : !this$developmentRegion.equals(other$developmentRegion)) {
            return false;
        }
        Integer this$hasScannedForEncodings = this.getHasScannedForEncodings();
        Integer other$hasScannedForEncodings = other.getHasScannedForEncodings();
        if (this$hasScannedForEncodings == null ? other$hasScannedForEncodings != null : !((Object)this$hasScannedForEncodings).equals(other$hasScannedForEncodings)) {
            return false;
        }
        List<String> this$knownRegions = this.getKnownRegions();
        List<String> other$knownRegions = other.getKnownRegions();
        if (this$knownRegions == null ? other$knownRegions != null : !((Object)this$knownRegions).equals(other$knownRegions)) {
            return false;
        }
        CommentedIdentifier this$mainGroup = this.getMainGroup();
        CommentedIdentifier other$mainGroup = other.getMainGroup();
        if (this$mainGroup == null ? other$mainGroup != null : !((Object)this$mainGroup).equals(other$mainGroup)) {
            return false;
        }
        CommentedIdentifier this$productRefGroup = this.getProductRefGroup();
        CommentedIdentifier other$productRefGroup = other.getProductRefGroup();
        if (this$productRefGroup == null ? other$productRefGroup != null : !((Object)this$productRefGroup).equals(other$productRefGroup)) {
            return false;
        }
        String this$projectDirPath = this.getProjectDirPath();
        String other$projectDirPath = other.getProjectDirPath();
        if (this$projectDirPath == null ? other$projectDirPath != null : !this$projectDirPath.equals(other$projectDirPath)) {
            return false;
        }
        String this$projectRoot = this.getProjectRoot();
        String other$projectRoot = other.getProjectRoot();
        if (this$projectRoot == null ? other$projectRoot != null : !this$projectRoot.equals(other$projectRoot)) {
            return false;
        }
        List<CommentedIdentifier> this$targets = this.getTargets();
        List<CommentedIdentifier> other$targets = other.getTargets();
        if (this$targets == null ? other$targets != null : !((Object)this$targets).equals(other$targets)) {
            return false;
        }
        String this$attributes = this.getAttributes();
        String other$attributes = other.getAttributes();
        return !(this$attributes == null ? other$attributes != null : !this$attributes.equals(other$attributes));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PBXProject;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CommentedIdentifier $reference = this.getReference();
        result = result * 59 + ($reference == null ? 0 : ((Object)$reference).hashCode());
        String $isa = this.getIsa();
        result = result * 59 + ($isa == null ? 0 : $isa.hashCode());
        CommentedIdentifier $buildConfigurationList = this.getBuildConfigurationList();
        result = result * 59 + ($buildConfigurationList == null ? 0 : ((Object)$buildConfigurationList).hashCode());
        String $compatibilityVersion = this.getCompatibilityVersion();
        result = result * 59 + ($compatibilityVersion == null ? 0 : $compatibilityVersion.hashCode());
        String $developmentRegion = this.getDevelopmentRegion();
        result = result * 59 + ($developmentRegion == null ? 0 : $developmentRegion.hashCode());
        Integer $hasScannedForEncodings = this.getHasScannedForEncodings();
        result = result * 59 + ($hasScannedForEncodings == null ? 0 : ((Object)$hasScannedForEncodings).hashCode());
        List<String> $knownRegions = this.getKnownRegions();
        result = result * 59 + ($knownRegions == null ? 0 : ((Object)$knownRegions).hashCode());
        CommentedIdentifier $mainGroup = this.getMainGroup();
        result = result * 59 + ($mainGroup == null ? 0 : ((Object)$mainGroup).hashCode());
        CommentedIdentifier $productRefGroup = this.getProductRefGroup();
        result = result * 59 + ($productRefGroup == null ? 0 : ((Object)$productRefGroup).hashCode());
        String $projectDirPath = this.getProjectDirPath();
        result = result * 59 + ($projectDirPath == null ? 0 : $projectDirPath.hashCode());
        String $projectRoot = this.getProjectRoot();
        result = result * 59 + ($projectRoot == null ? 0 : $projectRoot.hashCode());
        List<CommentedIdentifier> $targets = this.getTargets();
        result = result * 59 + ($targets == null ? 0 : ((Object)$targets).hashCode());
        String $attributes = this.getAttributes();
        result = result * 59 + ($attributes == null ? 0 : $attributes.hashCode());
        return result;
    }

    public PBXProject() {
    }

    @ConstructorProperties(value={"reference", "isa", "buildConfigurationList", "compatibilityVersion", "developmentRegion", "hasScannedForEncodings", "knownRegions", "mainGroup", "productRefGroup", "projectDirPath", "projectRoot", "targets", "attributes"})
    public PBXProject(CommentedIdentifier reference, String isa, CommentedIdentifier buildConfigurationList, String compatibilityVersion, String developmentRegion, Integer hasScannedForEncodings, List<String> knownRegions, CommentedIdentifier mainGroup, CommentedIdentifier productRefGroup, String projectDirPath, String projectRoot, List<CommentedIdentifier> targets, String attributes) {
        this.reference = reference;
        this.isa = isa;
        this.buildConfigurationList = buildConfigurationList;
        this.compatibilityVersion = compatibilityVersion;
        this.developmentRegion = developmentRegion;
        this.hasScannedForEncodings = hasScannedForEncodings;
        this.knownRegions = knownRegions;
        this.mainGroup = mainGroup;
        this.productRefGroup = productRefGroup;
        this.projectDirPath = projectDirPath;
        this.projectRoot = projectRoot;
        this.targets = targets;
        this.attributes = attributes;
    }
}

