/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.mobile.component;

import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.execution.util.MobileDeviceUIProvider;
import com.kms.katalon.composer.mobile.constants.StringConstants;
import com.kms.katalon.core.mobile.driver.MobileDriverType;
import com.kms.katalon.execution.mobile.configuration.providers.MobileDeviceProvider;
import com.kms.katalon.execution.mobile.device.MobileDeviceInfo;
import com.kms.katalon.execution.mobile.exception.MobileSetupException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class DeviceSelectionComposite
extends Composite {
    private Combo cbbDevices;
    private List<MobileDeviceInfo> devicesList = new ArrayList<MobileDeviceInfo>();
    private ArrayList<SelectionListener> selectionListenerList = new ArrayList();
    private ArrayList<ModifyListener> modifyListenerList = new ArrayList();

    public DeviceSelectionComposite(Composite parent, int style, MobileDriverType platform) {
        super(parent, style);
        this.setBackground(ColorUtil.getCompositeBackgroundColorForDialog());
        this.setBackgroundMode(2);
        this.setLayoutData(new GridData(1808));
        GridLayout glContainer = new GridLayout(2, false);
        glContainer.verticalSpacing = 10;
        this.setLayout((Layout)glContainer);
        this.loadDeviceList(platform);
        Label theLabel = new Label((Composite)this, 0);
        theLabel.setText(StringConstants.DIA_DEVICE_NAME);
        this.cbbDevices = new Combo((Composite)this, 4);
        this.cbbDevices.setLayoutData((Object)new GridData(768));
        this.cbbDevices.setItems(this.getDeviceFullNames());
        this.cbbDevices.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                for (SelectionListener selectionListener : DeviceSelectionComposite.this.selectionListenerList) {
                    selectionListener.widgetSelected(e);
                }
            }
        });
        this.cbbDevices.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                for (ModifyListener modifyListener : DeviceSelectionComposite.this.modifyListenerList) {
                    modifyListener.modifyText(e);
                }
            }
        });
    }

    private String[] getDeviceFullNames() {
        String[] fullNames = new String[this.devicesList.size()];
        int i = 0;
        while (i < this.devicesList.size()) {
            fullNames[i] = this.devicesList.get(i).getDisplayName();
            ++i;
        }
        return fullNames;
    }

    public void setSelectionIndex(int index) {
        if (this.devicesList.size() > 0 && index <= this.devicesList.size()) {
            this.cbbDevices.select(index);
        } else {
            this.cbbDevices.setItems(new String[0]);
            this.cbbDevices.setItems(this.getDeviceFullNames());
        }
    }

    public void setDeviceId(String deviceId) {
        int i = 0;
        while (i < this.devicesList.size()) {
            if (this.devicesList.get(i).getDeviceId().equals(deviceId)) {
                this.cbbDevices.select(i);
                return;
            }
            ++i;
        }
        this.cbbDevices.setItems(new String[0]);
        this.cbbDevices.setItems(this.getDeviceFullNames());
    }

    private void loadDeviceList(MobileDriverType platForm) {
        this.devicesList.clear();
        switch (platForm) {
            case ANDROID_DRIVER: {
                try {
                    if (!MobileDeviceUIProvider.checkAndroidSDKExist((Shell)this.getShell())) break;
                    this.devicesList.addAll(MobileDeviceProvider.getAndroidDevices());
                }
                catch (MobileSetupException | IOException | InterruptedException e) {
                    this.logException((Exception)e);
                }
                break;
            }
            case IOS_DRIVER: {
                try {
                    this.devicesList.addAll(MobileDeviceProvider.getIosDevices());
                }
                catch (IOException | InterruptedException e) {
                    this.logException(e);
                }
                try {
                    this.devicesList.addAll(MobileDeviceProvider.getIosSimulators());
                    break;
                }
                catch (IOException | InterruptedException e) {
                    this.logException(e);
                }
            }
        }
    }

    public void logException(Exception e) {
        MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Error", (String)(String.valueOf(e.getClass().getName()) + ": " + e.getMessage()));
        LoggerSingleton.logError((Throwable)e);
    }

    private boolean isNoDeviceSelected() {
        return this.devicesList.isEmpty() || this.cbbDevices.getSelectionIndex() < 0;
    }

    public MobileDeviceInfo getSelectedDevice() {
        if (this.isNoDeviceSelected()) {
            return null;
        }
        return this.devicesList.get(this.cbbDevices.getSelectionIndex());
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.selectionListenerList.add(selectionListener);
    }

    public void addModifyListener(ModifyListener modifyListener) {
        this.modifyListenerList.add(modifyListener);
    }
}

