/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.mobile.dialog;

import com.kms.katalon.activation.dialog.BaseModernDialog;
import com.kms.katalon.composer.components.controls.TextField;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.composer.components.util.ComponentEventUtil;
import com.kms.katalon.composer.components.util.ComponentUtil;
import com.kms.katalon.core.util.ConsoleCommandExecutor;
import com.kms.katalon.core.util.internal.ProcessUtil;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class AdministratorPrivilegeDialog
extends BaseModernDialog {
    private Composite loginButtonsGroup;
    private TextField passwordInput;
    private Link statusLabel;
    private String password;

    public String getPassword() {
        return this.password;
    }

    public AdministratorPrivilegeDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Point getInitialSize() {
        return super.getInitialSize();
    }

    public String getDialogTitle() {
        return "";
    }

    protected boolean useButtonBar() {
        return false;
    }

    protected void createContent(Composite container) {
        ComponentEventUtil.onSubmit((Control)container, event -> {
            this.clearMessage();
            this.password = this.passwordInput.getText();
            if (this.verifySudoPassword()) {
                this.setReturnCode(0);
                this.close();
            } else {
                this.setErrorMessage("Incorrect password or this user does not have sudo privilege.");
            }
        });
        Composite header = (Composite)ComponentBuilder.gridContainer((Composite)container).marginBottom(ComponentUtil.applyZoom((int)20)).fillHorizontal().build();
        ComponentBuilder.image((Composite)header, (String)"quick_start/logo_74.png").imageSize(this.applyZoom(100), this.applyZoom(100)).center().middle().build();
        ComponentBuilder.label((Composite)header).text("Katalon Studio is trying to install dependencies").fontSize(12).bold().textCenter().fillHorizontal().build();
        this.getShell().pack();
        int buttonSpacing = this.applyZoom(6);
        this.loginButtonsGroup = (Composite)ComponentBuilder.gridContainer((Composite)container).gridSpacing(buttonSpacing).fillHorizontal().build();
        Composite orWrapper = (Composite)ComponentBuilder.gridContainer((Composite)this.loginButtonsGroup).marginVertical(this.applyZoom(3)).fillHorizontal().build();
        ComponentBuilder.label((Composite)orWrapper).text("Enter your password to allow this").color(ColorUtil.getColor((String)"#919299")).fontSize(10).textCenter().fillHorizontal().build();
        Composite credentialWrapper = (Composite)ComponentBuilder.gridContainer((Composite)container).gridSpacing(this.applyZoom(10)).fillHorizontal().build();
        ComponentBuilder.textField((Composite)credentialWrapper).disable().placeholder("Username").text(SystemUtils.USER_NAME).fillHorizontal().build();
        this.passwordInput = (TextField)ComponentBuilder.textField((Composite)credentialWrapper, (int)16384).placeholder("Password").focus().fillHorizontal().build();
        this.statusLabel = (Link)ComponentBuilder.link((Composite)container).color(ColorUtil.getTextErrorColor()).fontSize(10).fillHorizontal().hide().build();
        Composite buttonBar = (Composite)ComponentBuilder.gridContainer((Composite)container).gridLayout(2, true).fillHorizontal().marginTop(0).marginBottom(this.applyZoom(10)).gridSpacing(this.applyZoom(10)).build();
        ComponentBuilder.canvas((Composite)buttonBar).text("Cancel").bold().fontSize(12).secondaryButton().autoHeight(40).onClick(event -> {
            this.setReturnCode(1);
            this.close();
        }).fillHorizontal().build();
        ComponentBuilder.canvas((Composite)buttonBar).text("Install").bold().fontSize(12).primaryButton3().autoHeight(40).submitButton().fillHorizontal().build();
    }

    protected void createButtons(Composite parent) {
    }

    public boolean close() {
        return super.close();
    }

    public void setErrorMessage(String message) {
        if (this.statusLabel.isDisposed()) {
            return;
        }
        ComponentUtil.show((Control)this.statusLabel);
        ComponentUtil.showError((Control)this.statusLabel, (String)ComponentUtil.autoWrapLinks((String)message), (boolean)true);
        this.getShell().pack();
    }

    public void clearMessage() {
        if (this.statusLabel.isDisposed()) {
            return;
        }
        ComponentUtil.hide((Control)this.statusLabel);
        ComponentUtil.setText((Widget)this.statusLabel, (String)"");
        this.getShell().pack();
    }

    private boolean verifySudoPassword() {
        try {
            String command = "echo \"" + this.passwordInput.getText() + "\" | sudo -S -k -v";
            String fullCommand = String.valueOf(ConsoleCommandExecutor.getSourcesLoadingCommand()) + "; " + command;
            ProcessBuilder processBuilder = ConsoleCommandExecutor.build((String)fullCommand, (String)"");
            Process process = processBuilder.start();
            int exitCode = process.waitFor();
            List results = ProcessUtil.readSync((Process)process);
            String result = String.join((CharSequence)", ", results);
            return exitCode == 0 && StringUtils.compare((String)result.toLowerCase(), (String)"password:") == 0;
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            return false;
        }
    }
}

