/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.mobile.execution.handler;

import com.kms.katalon.composer.components.dialogs.InstallationInstructionDialog;
import com.kms.katalon.composer.components.impl.installer.InstallationCommandStep;
import com.kms.katalon.composer.components.impl.installer.InstallationManager;
import com.kms.katalon.composer.components.impl.installer.InstallationStep;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.mobile.constants.ComposerMobileMessageConstants;
import com.kms.katalon.constants.GlobalStringConstants;
import com.kms.katalon.core.util.ConsoleCommandBuilder;
import com.kms.katalon.core.util.ConsoleCommandExecutor;
import com.kms.katalon.core.util.internal.ProcessUtil;
import com.kms.katalon.tracking.service.Trackings;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.swt.widgets.Shell;

public class IosInstallDependenciesHandler {
    private String password = "";
    private static final String RUN_OSASCRIPT_WITH_PRIVILEGES = "/usr/bin/osascript -e ''do shell script \"{0}\" with administrator privileges''";
    private static final String INSTALL_XCODE_CLI_TOOLS = "xcode-select --install; sudo xcode-select -s /Applications/Xcode.app/Contents/Developer";
    private static final String INSTALL_APPIUM = "npm install -g appium";
    private static final String INSTALL_XCUITEST = "appium driver install xcuitest";
    private static final String INSTALL_NODE = "brew install node";
    private static final String INSTALL_LIBIMOBILEDEVICE_XCODE15 = "brew install --HEAD libimobiledevice && brew unlink libimobiledevice && brew link libimobiledevice";
    private static final String INSTALL_LIBIMOBILEDEVICE = "brew install libimobiledevice && brew unlink libimobiledevice && brew link libimobiledevice";
    private static final String INSTALL_DEPENDENCIES_LOG_NAME = "IosInstallDependencies";
    private static final String PREFERRED_NPM_PATH = Paths.get(File.separator, "opt", "homebrew", "bin", "npm").toString();
    private static final String XCUITEST_PRE_CONDITION_FAILED_COMMAND = "echo xcuitest is already installed";

    @CanExecute
    public boolean canExecute() {
        return SystemUtils.IS_OS_MAC;
    }

    public static boolean containsSymlink(File file) throws IOException {
        return !file.getCanonicalFile().equals(file.getAbsoluteFile());
    }

    /*
     * Exception decompiling
     */
    @Execute
    public void execute(Shell shell) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private InstallationCommandStep appendStep(InstallationManager installationManager, File logFile, File errorLogFile, String title, String command) throws IOException, InterruptedException {
        InstallationCommandStep installationStep = new InstallationCommandStep(title, logFile, errorLogFile, command);
        installationManager.appendStep((InstallationStep)installationStep);
        return installationStep;
    }

    private InstallationCommandStep appendStep(InstallationManager installationManager, File logFile, File errorLogFile, String title, String command, InstallationCommandStep.PreConditionFunc preCondition, String preConditionCommand) throws IOException, InterruptedException {
        InstallationCommandStep installationStep = new InstallationCommandStep(title, logFile, errorLogFile, command);
        installationStep.setPreCondition(preCondition);
        installationStep.setPreConditionFailedCommand(preConditionCommand);
        installationManager.appendStep((InstallationStep)installationStep);
        return installationStep;
    }

    private void guidingToInstallHomebrew(Shell shell) {
        InstallationInstructionDialog dialog = new InstallationInstructionDialog(shell, ComposerMobileMessageConstants.DIA_TITLE_INSTALLATION_INSTRUCTIONS, null, ComposerMobileMessageConstants.MSG_XCODE_HOMEBREW_INSTALLATION_INSTRUCTION, 4, new String[]{GlobalStringConstants.DIA_TROUBLESHOOT, GlobalStringConstants.DIA_OK}, 1, ComposerMobileMessageConstants.MSG_IOS_INSTALL_DEPENDENCIES_TROUBLESHOOT_LINK);
        dialog.open();
    }

    private void guidingToInstallXcode(Shell shell) {
        InstallationInstructionDialog dialog = new InstallationInstructionDialog(shell, ComposerMobileMessageConstants.DIA_TITLE_INSTALLATION_INSTRUCTIONS, null, ComposerMobileMessageConstants.MSG_XCODE_INSTALLATION_INSTRUCTION, 4, new String[]{GlobalStringConstants.DIA_TROUBLESHOOT, GlobalStringConstants.DIA_OK}, 1, ComposerMobileMessageConstants.MSG_IOS_INSTALL_DEPENDENCIES_TROUBLESHOOT_LINK);
        dialog.open();
    }

    private boolean isXcodeCLTConfigured() throws IOException, InterruptedException {
        return ConsoleCommandExecutor.verifyModuleInstalled((String)"xcode-select -p", (String)"/Applications/Xcode.app/Contents/Developer");
    }

    private boolean isHomebrewInstalled() throws IOException, InterruptedException {
        return ConsoleCommandExecutor.verifyModuleInstalled((String)"brew");
    }

    private String findNpm() throws IOException, InterruptedException {
        if (this.isValidNpm(PREFERRED_NPM_PATH)) {
            return PREFERRED_NPM_PATH;
        }
        String npmPath = ConsoleCommandExecutor.safeWhere((String)"npm");
        if (this.isValidNpm(npmPath)) {
            return npmPath;
        }
        return null;
    }

    private boolean isNodeInstalled() throws IOException, InterruptedException {
        boolean isNodeInstalled = ConsoleCommandExecutor.verifyModuleInstalled((String)"node");
        if (!isNodeInstalled) {
            return false;
        }
        String npmPath = this.findNpm();
        return StringUtils.isNotBlank((CharSequence)npmPath);
    }

    private boolean isValidNpm(String npmPath) throws IOException, InterruptedException {
        String checkCommand = MessageFormat.format("{0} root -g", npmPath);
        String nodeModulesPath = ConsoleCommandBuilder.create((String)checkCommand).useSystemEnvs().first();
        if (nodeModulesPath == null) {
            return false;
        }
        File nodeModulesFolder = new File(nodeModulesPath);
        return nodeModulesFolder.exists() && nodeModulesFolder.canWrite();
    }

    private boolean isXcuitestInstalled() throws Exception {
        String command = "appium driver list --installed";
        String fullCommand = String.valueOf(ConsoleCommandExecutor.getSourcesLoadingCommand()) + "; " + command;
        ProcessBuilder processBuilder = ConsoleCommandExecutor.build((String)fullCommand, (String)"");
        Process process = processBuilder.start();
        List results = ProcessUtil.readSync((Process)process);
        return results.stream().anyMatch(result -> result.contains("xcuitest"));
    }

    private void removePasswordFile() {
        try {
            File pwFile = Paths.get(SystemUtils.getUserHome().toString(), ".katalon", "pw.sh").toFile();
            if (pwFile.exists()) {
                FileUtils.forceDelete((File)pwFile);
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private File getLogFile(String name) {
        try {
            return File.createTempFile(name, ".log");
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static /* synthetic */ void lambda$0(IosDependenciesTrackingObj iosDependenciesTrackingObj) {
        Trackings.trackInstallDependencies((boolean)iosDependenciesTrackingObj.getResult(), (String)iosDependenciesTrackingObj.getCurrentStep());
    }

    private /* synthetic */ boolean lambda$1() throws Exception {
        return !this.isXcuitestInstalled();
    }

    private class IosDependenciesTrackingObj {
        private boolean result = true;
        private String currentStep;

        private IosDependenciesTrackingObj() {
        }

        public void setResult(boolean result) {
            this.result = result;
        }

        public void setCurrentStep(String currentStep) {
            this.currentStep = currentStep;
        }

        public String getCurrentStep() {
            return this.currentStep;
        }

        public boolean getResult() {
            return this.result;
        }
    }
}

