/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.mobile.handler;

import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.tree.WebElementTreeEntity;
import com.kms.katalon.composer.components.impl.util.TreeEntityUtil;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.explorer.parts.ExplorerPart;
import com.kms.katalon.composer.mobile.dialog.NewMobileElementDialog;
import com.kms.katalon.composer.mobile.handler.OpenMobileTestObjectHandler;
import com.kms.katalon.controller.EntityNameController;
import com.kms.katalon.controller.ObjectRepositoryController;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.repository.MobileElementEntity;
import com.kms.katalon.entity.repository.WebElementEntity;
import com.kms.katalon.tracking.service.Trackings;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.swt.widgets.Shell;

public class NewMobileElementHandler {
    @Execute
    public void createNewWindowsElement(Shell activeShell) {
        try {
            ITreeEntity selectedEntity = (ITreeEntity)ExplorerPart.getInstance().getSelectedTreeEntities().get(0);
            FolderTreeEntity folderTreeEntity = null;
            if (selectedEntity instanceof FolderTreeEntity) {
                folderTreeEntity = (FolderTreeEntity)selectedEntity;
            } else if (selectedEntity instanceof WebElementTreeEntity) {
                folderTreeEntity = (FolderTreeEntity)selectedEntity.getParent();
            } else {
                return;
            }
            FolderEntity folder = folderTreeEntity.getObject();
            String suggestedName = EntityNameController.getInstance().getAvailableName("New Mobile Object", folder, false);
            NewMobileElementDialog dialog = new NewMobileElementDialog(activeShell, folder, suggestedName);
            if (dialog.open() != 0) {
                return;
            }
            MobileElementEntity newMobileElement = (MobileElementEntity)dialog.getEntity();
            if (newMobileElement == null) {
                return;
            }
            MobileElementEntity newMobileElementEntity = ObjectRepositoryController.getInstance().newMobileElement(newMobileElement);
            Trackings.trackCreatingObject((String)"mobileObject");
            ExplorerPart.getInstance().refreshTreeEntity((Object)folderTreeEntity);
            ExplorerPart.getInstance().setSelectedItems(new Object[]{TreeEntityUtil.getWebElementTreeEntity((WebElementEntity)newMobileElementEntity, (ProjectEntity)folder.getProject())});
            OpenMobileTestObjectHandler.getInstance().execute(newMobileElementEntity);
        }
        catch (Exception e) {
            MultiStatusErrorDialog.showErrorDialog((Throwable)e, (String)"Unable to create Mobile object", (String)e.getMessage());
        }
    }
}

