/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.mobile.preferences;

import com.kms.katalon.composer.components.controls.HelpComposite;
import com.kms.katalon.composer.components.dialogs.PreferencePageWithHelp;
import com.kms.katalon.composer.mobile.constants.ComposerMobileMessageConstants;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.model.MobileDisplayObjectTreeOption;
import com.kms.katalon.execution.setting.MobileSettingStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class MobileSettingPage
extends PreferencePageWithHelp {
    private Composite container;
    private Combo displayObjectTreeOptions;
    private String projectDir = ProjectController.getInstance().getCurrentProject().getFolderLocation();
    private MobileSettingStore settingStore = new MobileSettingStore(this.projectDir);
    private boolean modified;

    protected Control createContents(Composite parent) {
        this.container = new Composite(parent, 0);
        this.container.setLayout((Layout)new GridLayout());
        this.container.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite composite = new Composite(this.container, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = 0;
        layout.marginRight = 0;
        composite.setLayout((Layout)layout);
        Label lblDisplayObjectTreeOption = new Label(composite, 0);
        lblDisplayObjectTreeOption.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        lblDisplayObjectTreeOption.setText(ComposerMobileMessageConstants.DEFAULT_DISPLAYING_OBJECT_TREE);
        new HelpComposite(composite, ComposerMobileMessageConstants.LINK_TO_DISPLAY_OBJECT_TREE_OPTIONS);
        this.displayObjectTreeOptions = new Combo(composite, 8);
        this.displayObjectTreeOptions.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        Label lblDisplayObjectTreeOptDescription = new Label(this.container, 0);
        lblDisplayObjectTreeOptDescription.setText(ComposerMobileMessageConstants.DESCRIPTION_DISPLAY_OBJECT_TREE_OPTIONS);
        lblDisplayObjectTreeOptDescription.setFont(JFaceResources.getFontRegistry().getItalic("org.eclipse.jface.defaultfont"));
        this.initValue();
        this.registerControlModifyListeners();
        return parent;
    }

    private void initValue() {
        this.displayObjectTreeOptions.setItems(MobileDisplayObjectTreeOption.valueStrings());
        MobileDisplayObjectTreeOption defaultDisplayObjectTreOption = this.settingStore.getDefaultMobileDisplayObjectTreeOption();
        this.displayObjectTreeOptions.select(defaultDisplayObjectTreOption.ordinal());
        this.modified = false;
    }

    private void registerControlModifyListeners() {
        this.displayObjectTreeOptions.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MobileSettingPage.this.modified = true;
            }
        });
    }

    protected void performDefaults() {
        MobileDisplayObjectTreeOption defaultDisplayObjectTreOption = MobileSettingStore.DEFAULT_DISPLAY_TREE_OPTION_IF_NOT_SET;
        this.displayObjectTreeOptions.select(defaultDisplayObjectTreOption.ordinal());
        this.modified = true;
        super.performDefaults();
    }

    public boolean performOk() {
        if (this.container == null) {
            return true;
        }
        if (this.modified) {
            this.settingStore.saveDefaultOptionDisplayTree(MobileDisplayObjectTreeOption.valueStrings()[this.displayObjectTreeOptions.getSelectionIndex()]);
        }
        return super.performOk();
    }

    public boolean hasDocumentation() {
        return false;
    }
}

