/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.mobile.util;

import com.kms.katalon.composer.components.impl.dialogs.MissingMobileDriverWarningDialog;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.mobile.component.ProvisioningProfile;
import com.kms.katalon.composer.mobile.entity.AppiumInfo;
import com.kms.katalon.core.appium.util.AppiumVersionUtil;
import com.kms.katalon.core.util.ConsoleCommandExecutor;
import com.kms.katalon.execution.mobile.device.IosDeviceInfo;
import com.kms.katalon.execution.mobile.exception.MobileSetupException;
import com.kms.katalon.execution.mobile.util.MobileExecutionUtil;
import com.kms.katalon.execution.mobile.util.SystemCertificationUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.cert.CertificateException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.SystemUtils;
import org.eclipse.swt.widgets.Shell;

public class MobileUtil {
    private static final String DEFAULT_XCODE_LOCATION = "/Applications/Xcode.app/Contents/MacOS/Xcode";
    private static final String[] LISTING_IDENTITIES_COMMAND = new String[]{"/bin/sh", "-c", "security find-identity -v -p codesigning"};
    private static final String WEB_DRIVER_AGENT_V1_RELATIVE_FOLDER = "/node_modules/appium-webdriveragent";
    private static final String XCUITEST_DRIVER_V1_RELATIVE_FOLDER = "/node_modules/appium-xcuitest-driver";
    private static final String WEB_DRIVER_AGENT_V2_RELATIVE_FOLDER = "/.appium/node_modules/appium-xcuitest-driver/node_modules/appium-webdriveragent";
    private static final String PROVISIONING_PROFILE_LOCATION = "/Library/MobileDevice/Provisioning Profiles";
    private static final String PROVISIONING_PROFILE_EXTENSION = ".mobileprovision";

    public static boolean detectAppiumAndNodeJs(Shell activeShell) {
        try {
            MobileExecutionUtil.detectInstalledAppiumAndNodeJs();
        }
        catch (MobileSetupException e) {
            MissingMobileDriverWarningDialog.showWarning((Shell)activeShell, (String)e.getMessage());
            return false;
        }
        return true;
    }

    public static boolean isXcodeInstalled() throws IOException, InterruptedException {
        boolean isXcodeInstalled;
        boolean bl = isXcodeInstalled = !ConsoleCommandExecutor.verifyModuleInstalled((String)"xcodebuild -version", (String)"error");
        if (isXcodeInstalled) {
            return true;
        }
        return new File(DEFAULT_XCODE_LOCATION).exists();
    }

    public static String getDefaultXCodeLocation() {
        return DEFAULT_XCODE_LOCATION;
    }

    public static List<String> getRawIdentityList() throws IOException, InterruptedException {
        return ConsoleCommandExecutor.runConsoleCommandAndCollectResults((String[])LISTING_IDENTITIES_COMMAND, (Map)IosDeviceInfo.getIosAdditionalEnvironmentVariables(), (boolean)true);
    }

    public static AppiumInfo getAppiumInfoToInstallWebDriverAgent() {
        String webDriverAgentFolder = "";
        String appiumHome = MobileExecutionUtil.findAppiumDir();
        String ver = AppiumVersionUtil.readVersionFromFile((String)appiumHome);
        webDriverAgentFolder = ver.startsWith("1") ? new File(appiumHome, WEB_DRIVER_AGENT_V1_RELATIVE_FOLDER).getAbsolutePath() : new File(SystemUtils.getUserHome(), WEB_DRIVER_AGENT_V2_RELATIVE_FOLDER).getAbsolutePath();
        return new AppiumInfo(ver, appiumHome, webDriverAgentFolder);
    }

    private static boolean isProvisioningProfileEligible(String provisioningProfileContent, String mobileDeviceId) {
        Date expirationDate = MobileUtil.parseExpirationDate(provisioningProfileContent);
        if (expirationDate.after(Date.from(Instant.now()))) {
            List<String> provisionedDeviceIds = MobileUtil.parseProvisionedDevices(provisioningProfileContent);
            return provisionedDeviceIds.contains(mobileDeviceId);
        }
        return false;
    }

    private static String readProvisioningProfileToString(File file) throws Exception {
        FileInputStream fis = new FileInputStream(file);
        byte[] data = new byte[(int)file.length()];
        fis.read(data);
        fis.close();
        String fileContent = new String(data, StandardCharsets.ISO_8859_1);
        String decodedContent = MobileUtil.decodeProvisioningProfileContent(fileContent);
        return decodedContent;
    }

    private static String decodeProvisioningProfileContent(String fileContent) throws Exception {
        Pattern pattern = Pattern.compile("<plist.*</plist>", 32);
        Matcher matcher = pattern.matcher(fileContent);
        if (matcher.find()) {
            return matcher.group(0);
        }
        return "";
    }

    public static List<String> readProvisioningProfileContents() {
        return Stream.of(new File(String.valueOf(System.getProperty("user.home")) + PROVISIONING_PROFILE_LOCATION).listFiles()).filter(file -> !file.isDirectory() && file.getName().endsWith(PROVISIONING_PROFILE_EXTENSION)).map(t -> {
            try {
                return MobileUtil.readProvisioningProfileToString(t);
            }
            catch (Exception e) {
                LoggerSingleton.logError((Throwable)e);
                return null;
            }
        }).filter(fileName -> !fileName.isBlank()).collect(Collectors.toList());
    }

    public static List<ProvisioningProfile> getEligibleProvisioningProfiles(List<String> provisioningProfileContents, String mobileDeviceId) throws CertificateException, IOException, InterruptedException {
        ArrayList<ProvisioningProfile> result = new ArrayList<ProvisioningProfile>();
        for (String provisioningProfileContent : provisioningProfileContents) {
            List<String> provisionedDeviceIds;
            Date expirationDate = MobileUtil.parseExpirationDate(provisioningProfileContent);
            if (!expirationDate.after(Date.from(Instant.now())) || !(provisionedDeviceIds = MobileUtil.parseProvisionedDevices(provisioningProfileContent)).contains(mobileDeviceId)) continue;
            String name = MobileUtil.parseNameWithProvisionedDevice(provisioningProfileContent);
            List developerCertificateIds = SystemCertificationUtil.parseDeveloperCertificates((String)provisioningProfileContent);
            result.add(new ProvisioningProfile(name, expirationDate, developerCertificateIds, provisionedDeviceIds));
        }
        return result;
    }

    private static Date parseExpirationDate(String plistContent) {
        Pattern pattern = Pattern.compile("<key>ExpirationDate</key>\\s*<date>([^<]+)</date>", 32);
        Matcher matcher = pattern.matcher(plistContent);
        if (matcher.find()) {
            Instant dateInstant = Instant.parse(matcher.group(1));
            return Date.from(dateInstant);
        }
        return null;
    }

    private static String parseNameWithProvisionedDevice(String plistContent) {
        Pattern pattern = Pattern.compile("<key>Name</key>\\s*<string>([^<]+)</string>", 32);
        Matcher matcher = pattern.matcher(plistContent);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    public static List<String> getEligibleProvisioningProfileNames(List<String> provisioningProfileContents, String mobileDeviceId) {
        ArrayList<String> result = new ArrayList<String>();
        for (String content : provisioningProfileContents) {
            if (!MobileUtil.isProvisioningProfileEligible(content, mobileDeviceId)) continue;
            result.add(MobileUtil.parseNameWithProvisionedDevice(content));
        }
        return result;
    }

    private static List<String> parseProvisionedDevices(String plistContent) {
        ArrayList<String> provisionedDevices = new ArrayList<String>();
        Pattern pattern = Pattern.compile("<key>ProvisionedDevices</key>\\s*<array>(.*?)</array>", 32);
        Matcher matcher = pattern.matcher(plistContent);
        while (matcher.find()) {
            String provisionedDeviceKey = matcher.group(1);
            pattern = Pattern.compile("<string>(.*?)</string>", 32);
            matcher = pattern.matcher(provisionedDeviceKey);
            while (matcher.find()) {
                provisionedDevices.add(matcher.group(1));
            }
        }
        return provisionedDevices;
    }

    public static String getXcuitestVersion(String appiumDir) {
        String xcuitestDir = new File(appiumDir, XCUITEST_DRIVER_V1_RELATIVE_FOLDER).getAbsolutePath();
        return AppiumVersionUtil.readVersionFromFile((String)xcuitestDir);
    }
}

