/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.keyword.dialogs;

import com.kms.katalon.composer.components.impl.dialogs.TreeEntitySelectionDialog;
import com.kms.katalon.composer.components.impl.providers.AbstractEntityViewerFilter;
import com.kms.katalon.composer.components.impl.providers.IEntityLabelProvider;
import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.tree.KeywordTreeEntity;
import com.kms.katalon.composer.components.impl.tree.PackageTreeEntity;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;

public class KeywordSelectionDialog
extends TreeEntitySelectionDialog {
    private List<Object> checkedItems;

    public KeywordSelectionDialog(Shell parent, IEntityLabelProvider labelProvider, ITreeContentProvider contentProvider, AbstractEntityViewerFilter entityViewerFilter) {
        super(parent, labelProvider, contentProvider, entityViewerFilter);
        this.setAllowMultiple(false);
        this.setDoubleClickSelects(false);
        this.checkedItems = new ArrayList<Object>();
    }

    public TreeViewer createTreeViewer(Composite parent) {
        final ContainerCheckedTreeViewer treeViewer = (ContainerCheckedTreeViewer)super.createTreeViewer(parent);
        treeViewer.getTree().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.detail != 32) {
                    return;
                }
                TreeItem item = (TreeItem)e.item;
                treeViewer.getTree().setSelection(item);
                KeywordSelectionDialog.this.onStateChangedTreeItem(item.getData(), item.getChecked());
            }
        });
        return treeViewer;
    }

    protected TreeViewer doCreateTreeViewer(Composite parent, int style) {
        return new ContainerCheckedTreeViewer(new Tree(parent, 0x20 | style));
    }

    private void onStateChangedTreeItem(Object element, boolean isChecked) {
        Object childElement;
        int n;
        int n2;
        Object[] objectArray;
        if (element instanceof KeywordTreeEntity) {
            if (isChecked) {
                this.checkedItems.add(element);
            } else {
                this.checkedItems.remove(element);
            }
            return;
        }
        if (element instanceof PackageTreeEntity) {
            try {
                objectArray = ((PackageTreeEntity)element).getChildren();
                n2 = objectArray.length;
                n = 0;
                while (n < n2) {
                    childElement = objectArray[n];
                    this.onStateChangedTreeItem(childElement, isChecked);
                    ++n;
                }
            }
            catch (Exception e) {
                LoggerSingleton.logError((Throwable)e);
            }
        }
        if (element instanceof FolderTreeEntity) {
            try {
                objectArray = ((FolderTreeEntity)element).getChildren();
                n2 = objectArray.length;
                n = 0;
                while (n < n2) {
                    childElement = objectArray[n];
                    this.onStateChangedTreeItem(childElement, isChecked);
                    ++n;
                }
            }
            catch (Exception e) {
                LoggerSingleton.logError((Throwable)e);
            }
        }
    }

    protected void computeResult() {
        ContainerCheckedTreeViewer treeViewer = (ContainerCheckedTreeViewer)this.getTreeViewer();
        List<Object> grayedItems = Arrays.asList(treeViewer.getGrayedElements());
        this.checkedItems.removeAll(grayedItems);
        this.setResult(this.checkedItems);
    }

    public KeywordTreeEntity[] getSelectedKeywords() throws Exception {
        List<KeywordTreeEntity> selectedTreeEntities = this.flattenDialogResult(this.getResult());
        return selectedTreeEntities.toArray(new KeywordTreeEntity[selectedTreeEntities.size()]);
    }

    private List<KeywordTreeEntity> flattenDialogResult(Object[] dialogResult) throws Exception {
        if (dialogResult == null) {
            return Collections.emptyList();
        }
        ArrayList<KeywordTreeEntity> selectedTreeEntities = new ArrayList<KeywordTreeEntity>();
        Object[] objectArray = dialogResult;
        int n = dialogResult.length;
        int n2 = 0;
        while (n2 < n) {
            Object eachResult = objectArray[n2];
            if (eachResult instanceof KeywordTreeEntity) {
                selectedTreeEntities.add((KeywordTreeEntity)eachResult);
            } else if (eachResult instanceof FolderTreeEntity) {
                selectedTreeEntities.addAll(this.flattenDialogResult(((FolderTreeEntity)eachResult).getChildren()));
            }
            ++n2;
        }
        return selectedTreeEntities;
    }
}

