/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.keyword.handlers;

import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.util.groovy.GroovyEditorUtil;
import com.kms.katalon.controller.KeywordController;
import com.kms.katalon.controller.ProjectController;
import java.util.concurrent.Executors;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.ui.part.FileEditorInput;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class EditorSavedHandler
implements EventHandler {
    @Inject
    private IEventBroker eventBroker;

    @PostConstruct
    public void registerEventHandler() {
        this.eventBroker.subscribe("EDITORS_SAVED", (EventHandler)this);
    }

    public void handleEvent(Event event) {
        String topic = event.getTopic();
        Object object = event.getProperty("org.eclipse.e4.data");
        switch (topic) {
            case "EDITORS_SAVED": {
                if (!(object instanceof MPart)) {
                    return;
                }
                MPart part = (MPart)object;
                if (!GroovyEditorUtil.isGroovyEditorPart((MPart)part)) {
                    return;
                }
                IFile file = ((FileEditorInput)GroovyEditorUtil.getEditor((MPart)part).getEditorInput()).getFile();
                Executors.newSingleThreadExecutor().submit(() -> {
                    if (!this.isScriptRightFormat(file)) {
                        return;
                    }
                    try {
                        KeywordController.getInstance().parseCustomKeywordFile(file, ProjectController.getInstance().getCurrentProject());
                        this.eventBroker.post("CUSTOMKEYWORD/REFRESH", null);
                    }
                    catch (Exception ex) {
                        LoggerSingleton.logError((Throwable)ex);
                    }
                    UISynchronizeService.syncExec(() -> {
                        try {
                            this.refreshKeywordTreeEntity(file);
                        }
                        catch (Exception ex) {
                            LoggerSingleton.logError((Throwable)ex);
                        }
                    });
                });
            }
        }
    }

    private boolean isScriptRightFormat(IFile file) {
        if (!ResourcesPlugin.getWorkspace().getDescription().isAutoBuilding()) {
            return true;
        }
        try {
            Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, null);
        }
        catch (InterruptedException | OperationCanceledException throwable) {
            return false;
        }
        return !this.scriptContainsErrors(file);
    }

    private boolean scriptContainsErrors(IFile file) {
        try {
            IMarker[] problemMarkers = file.findMarkers("org.eclipse.jdt.core.problem", false, 0);
            return problemMarkers != null && problemMarkers.length > 0;
        }
        catch (CoreException e) {
            LoggerSingleton.logError((Throwable)e);
            return true;
        }
    }

    private void refreshKeywordTreeEntity(IFile file) throws Exception {
    }
}

