/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.keyword.handlers;

import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.controller.ProjectController;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.StringBuilderWriter;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class ImportJarHandler {
    @Inject
    IEventBroker eventBroker;

    @CanExecute
    private boolean canExecute() {
        return ProjectController.getInstance().getCurrentProject() != null;
    }

    @Execute
    public void execute(@Named(value="activeShell") @Named(value="activeShell") Shell parentShell) {
        try {
            FileDialog dialog = new FileDialog(parentShell);
            String[] jarExtension = new String[]{"*.jar"};
            dialog.setFilterExtensions(jarExtension);
            String path = dialog.open();
            if (path == null) {
                return;
            }
            File file = new File(path);
            StringBuilder content = new StringBuilder();
            ImportJarHandler.readFileToStringBuilder(file, content);
        }
        catch (IOException | URISyntaxException e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    public static void readFileToStringBuilder(File jarFile, StringBuilder sb) throws IOException, URISyntaxException {
        if (jarFile.isFile()) {
            JarFile jar = new JarFile(jarFile);
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry jarEntry = entries.nextElement();
                String name = jarEntry.getName();
                if (!name.endsWith("class")) continue;
                StringBuilderWriter sbWriter = new StringBuilderWriter(new StringBuilder());
                IOUtils.copy((InputStream)jar.getInputStream(jarEntry), (Writer)sbWriter);
                sbWriter.flush();
                sbWriter.close();
                sb.append((CharSequence)sbWriter.getBuilder());
                break;
            }
            jar.close();
        }
    }
}

