/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.mobile.recorder.handlers;

import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.tree.TestCaseTreeEntity;
import com.kms.katalon.composer.components.impl.util.TreeEntityUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.components.util.DialogUtil;
import com.kms.katalon.composer.explorer.parts.ExplorerPart;
import com.kms.katalon.composer.mobile.objectspy.components.MobileAppComposite;
import com.kms.katalon.composer.mobile.objectspy.components.MobileLocalAppComposite;
import com.kms.katalon.composer.mobile.objectspy.dialog.SaveTestCaseDialog;
import com.kms.katalon.composer.mobile.recorder.components.MobileRecorderDialog;
import com.kms.katalon.composer.mobile.recorder.components.RecordActionResult;
import com.kms.katalon.composer.mobile.util.MobileUtil;
import com.kms.katalon.composer.testcase.groovy.ast.ScriptNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.parser.GroovyWrapperParser;
import com.kms.katalon.composer.testcase.handlers.OpenTestCaseHandler;
import com.kms.katalon.composer.testcase.model.TestCaseTreeTableInput;
import com.kms.katalon.composer.testcase.parts.TestCaseCompositePart;
import com.kms.katalon.composer.testcase.parts.TestCasePart;
import com.kms.katalon.constants.GlobalMessageConstants;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.TestCaseController;
import com.kms.katalon.controller.exception.ControllerException;
import com.kms.katalon.core.mobile.driver.MobileDriverType;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.basic.MCompositePart;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class OpenIosRecorderHandler {
    private MobileRecorderDialog recorderDialog;
    private Shell activeShell;
    @Inject
    private IEventBroker eventBroker;

    @PostConstruct
    public void registerEvent() {
        this.eventBroker.subscribe("OBJECT_SPY/MOBILE", new EventHandler(){

            public void handleEvent(Event event) {
                if (!OpenIosRecorderHandler.this.canExecute()) {
                    return;
                }
                OpenIosRecorderHandler.this.execute(Display.getCurrent().getActiveShell());
            }
        });
    }

    @CanExecute
    public boolean canExecute() {
        return ProjectController.getInstance().getCurrentProject() != null && Platform.getOS().equals("macosx");
    }

    @Execute
    public void execute(@Named(value="activeShell") @Named(value="activeShell") Shell activeShell) {
        MobileUtil.detectAppiumAndNodeJs((Shell)activeShell);
        this.openRecorderDialog(activeShell);
    }

    private boolean openRecorderDialog(Shell activeShell) {
        block4: {
            try {
                if (this.activeShell == null) {
                    this.activeShell = activeShell;
                }
                Shell dialogShell = DialogUtil.createDialogShell((Shell)activeShell);
                this.recorderDialog = new MobileRecorderDialog(dialogShell, (MobileAppComposite)new MobileLocalAppComposite(MobileDriverType.IOS_DRIVER));
                if (this.recorderDialog.open() == 0) break block4;
                return false;
            }
            catch (Exception e) {
                LoggerSingleton.logError((Throwable)e);
                MessageDialog.openError((Shell)activeShell, (String)GlobalMessageConstants.ERROR, (String)e.getMessage());
                return false;
            }
        }
        this.saveToTestCase(activeShell, this.recorderDialog.getRecordActionResult());
        return true;
    }

    private void saveToTestCase(Shell activeShell, RecordActionResult actionResult) throws ControllerException, Exception {
        SaveTestCaseDialog dialog = new SaveTestCaseDialog(activeShell);
        if (dialog.open() != 0) {
            return;
        }
        SaveTestCaseDialog.ExportTestCaseSelectionResult exportResult = dialog.getResult();
        FolderEntity selectedFolder = exportResult.getFolder();
        FolderTreeEntity selectedFolderTreeEntity = TreeEntityUtil.getFolderTreeEntity((FolderEntity)selectedFolder);
        TestCaseEntity testCaseEntity = this.getTestCase(exportResult);
        TestCaseTreeEntity testCaseTreeEntity = new TestCaseTreeEntity(testCaseEntity, (ITreeEntity)selectedFolderTreeEntity);
        ExplorerPart.getInstance().refreshTreeEntity((Object)selectedFolderTreeEntity);
        ExplorerPart.getInstance().setSelectedItems(new Object[]{testCaseTreeEntity});
        MCompositePart part = OpenTestCaseHandler.getInstance().openTestCase(testCaseEntity);
        boolean shouldOverride = false;
        if (exportResult.getOption() == SaveTestCaseDialog.ExportTestCaseOption.OVERWRITE_TEST_CASE) {
            shouldOverride = true;
        }
        boolean isNewTestCase = false;
        if (exportResult.getOption() == SaveTestCaseDialog.ExportTestCaseOption.EXPORT_TO_NEW_TEST_CASE) {
            isNewTestCase = true;
        }
        TestCaseCompositePart testCaseCompositePart = (TestCaseCompositePart)part.getObject();
        TestCasePart testCasePart = testCaseCompositePart.getChildTestCasePart();
        testCaseCompositePart.setScriptContentToManual();
        StringBuilder stringBuilder = new StringBuilder();
        new GroovyWrapperParser(stringBuilder).parseGroovyAstIntoScript(actionResult.getScript());
        ScriptNodeWrapper script = GroovyWrapperParser.parseGroovyScriptIntoNodeWrapper((String)stringBuilder.toString());
        List children = script.getBlock().getAstChildren();
        if (shouldOverride) {
            testCasePart.clearAndAddStatementsToMainBlock(children, TestCaseTreeTableInput.NodeAddType.Add, true);
        } else {
            testCasePart.addStatementsToMainBlock(children, TestCaseTreeTableInput.NodeAddType.Add, true);
        }
        testCasePart.addImports(script.getImports());
        testCasePart.getTreeTableInput().setChanged(true);
        testCaseCompositePart.changeScriptNode(testCasePart.getTreeTableInput().getMainClassNode());
        testCaseCompositePart.recorderSave(isNewTestCase);
    }

    private TestCaseEntity getTestCase(SaveTestCaseDialog.ExportTestCaseSelectionResult result) throws ControllerException {
        switch (result.getOption()) {
            case APPEND_TO_TEST_CASE: 
            case OVERWRITE_TEST_CASE: {
                return TestCaseController.getInstance().getTestCaseByDisplayId(String.valueOf(result.getFolder().getIdForDisplay()) + "/" + result.getTestCaseName());
            }
            case EXPORT_TO_NEW_TEST_CASE: {
                return TestCaseController.getInstance().newTestCase(result.getFolder(), result.getTestCaseName());
            }
        }
        return null;
    }
}

