/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.mobile.recorder.handlers;

import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.tree.TestCaseTreeEntity;
import com.kms.katalon.composer.components.impl.util.TreeEntityUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.components.util.DialogUtil;
import com.kms.katalon.composer.explorer.parts.ExplorerPart;
import com.kms.katalon.composer.mobile.objectspy.components.KobitonAppComposite;
import com.kms.katalon.composer.mobile.objectspy.components.MobileAppComposite;
import com.kms.katalon.composer.mobile.objectspy.dialog.SaveTestCaseDialog;
import com.kms.katalon.composer.mobile.recorder.components.MobileRecorderDialog;
import com.kms.katalon.composer.mobile.recorder.components.RecordActionResult;
import com.kms.katalon.composer.testcase.groovy.ast.ScriptNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.parser.GroovyWrapperParser;
import com.kms.katalon.composer.testcase.handlers.OpenTestCaseHandler;
import com.kms.katalon.composer.testcase.model.TestCaseTreeTableInput;
import com.kms.katalon.composer.testcase.parts.TestCaseCompositePart;
import com.kms.katalon.composer.testcase.parts.TestCasePart;
import com.kms.katalon.constants.GlobalMessageConstants;
import com.kms.katalon.constants.GlobalStringConstants;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.TestCaseController;
import com.kms.katalon.controller.exception.ControllerException;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.integration.kobiton.preferences.KobitonPreferencesProvider;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.basic.MCompositePart;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class OpenKobitonRecoderHandler {
    private MobileRecorderDialog recorderDialog;
    private Shell activeShell;
    @Inject
    private IEventBroker eventBroker;

    @CanExecute
    public boolean canExecute() {
        return ProjectController.getInstance().getCurrentProject() != null;
    }

    @Execute
    public void execute(@Named(value="activeShell") @Named(value="activeShell") Shell activeShell) {
        this.openRecorderDialog(activeShell);
    }

    private boolean openRecorderDialog(Shell activeShell) {
        block8: {
            block6: {
                block7: {
                    try {
                        boolean isIntegrationEnabled;
                        if (this.activeShell == null) {
                            this.activeShell = activeShell;
                        }
                        if (isIntegrationEnabled = KobitonPreferencesProvider.isKobitonIntegrationEnabled()) break block6;
                        boolean confirmToConfigureKobiton = MessageDialog.openConfirm((Shell)activeShell, (String)GlobalStringConstants.INFO, (String)"Kobiton integration has not been enabled yet. Would you like to enable now?");
                        if (confirmToConfigureKobiton) break block7;
                        return false;
                    }
                    catch (Exception e) {
                        LoggerSingleton.logError((Throwable)e);
                        MessageDialog.openError((Shell)activeShell, (String)GlobalMessageConstants.ERROR, (String)e.getMessage());
                        return false;
                    }
                }
                this.eventBroker.post("KATALON/PREFERENCES", (Object)"com.kms.katalon.composer.preferences.GeneralPreferencePage/com.kms.katalon.composer.integration.kobiton.preferences");
                return false;
            }
            Shell dialogShell = DialogUtil.createDialogShell((Shell)activeShell);
            this.recorderDialog = new MobileRecorderDialog(dialogShell, (MobileAppComposite)new KobitonAppComposite());
            if (this.recorderDialog.open() == 0) break block8;
            return false;
        }
        this.saveToTestCase(activeShell, this.recorderDialog.getRecordActionResult());
        return true;
    }

    private void saveToTestCase(Shell activeShell, RecordActionResult actionResult) throws ControllerException, Exception {
        SaveTestCaseDialog dialog = new SaveTestCaseDialog(activeShell);
        if (dialog.open() != 0) {
            return;
        }
        SaveTestCaseDialog.ExportTestCaseSelectionResult exportResult = dialog.getResult();
        FolderEntity selectedFolder = exportResult.getFolder();
        FolderTreeEntity selectedFolderTreeEntity = TreeEntityUtil.getFolderTreeEntity((FolderEntity)selectedFolder);
        TestCaseEntity testCaseEntity = this.getTestCase(exportResult);
        TestCaseTreeEntity testCaseTreeEntity = new TestCaseTreeEntity(testCaseEntity, (ITreeEntity)selectedFolderTreeEntity);
        ExplorerPart.getInstance().refreshTreeEntity((Object)selectedFolderTreeEntity);
        ExplorerPart.getInstance().setSelectedItems(new Object[]{testCaseTreeEntity});
        MCompositePart part = OpenTestCaseHandler.getInstance().openTestCase(testCaseEntity);
        boolean shouldOverride = false;
        if (exportResult.getOption() == SaveTestCaseDialog.ExportTestCaseOption.OVERWRITE_TEST_CASE) {
            shouldOverride = true;
        }
        boolean isNewTestCase = false;
        if (exportResult.getOption() == SaveTestCaseDialog.ExportTestCaseOption.EXPORT_TO_NEW_TEST_CASE) {
            isNewTestCase = true;
        }
        TestCaseCompositePart testCaseCompositePart = (TestCaseCompositePart)part.getObject();
        TestCasePart testCasePart = testCaseCompositePart.getChildTestCasePart();
        testCaseCompositePart.setScriptContentToManual();
        StringBuilder stringBuilder = new StringBuilder();
        new GroovyWrapperParser(stringBuilder).parseGroovyAstIntoScript(actionResult.getScript());
        ScriptNodeWrapper script = GroovyWrapperParser.parseGroovyScriptIntoNodeWrapper((String)stringBuilder.toString());
        List children = script.getBlock().getAstChildren();
        if (shouldOverride) {
            testCasePart.clearAndAddStatementsToMainBlock(children, TestCaseTreeTableInput.NodeAddType.Add, true);
        } else {
            testCasePart.addStatementsToMainBlock(children, TestCaseTreeTableInput.NodeAddType.Add, true);
        }
        testCasePart.addImports(script.getImports());
        testCasePart.getTreeTableInput().setChanged(true);
        testCaseCompositePart.changeScriptNode(testCasePart.getTreeTableInput().getMainClassNode());
        testCaseCompositePart.recorderSave(isNewTestCase);
    }

    private TestCaseEntity getTestCase(SaveTestCaseDialog.ExportTestCaseSelectionResult result) throws ControllerException {
        switch (result.getOption()) {
            case APPEND_TO_TEST_CASE: 
            case OVERWRITE_TEST_CASE: {
                return TestCaseController.getInstance().getTestCaseByDisplayId(String.valueOf(result.getFolder().getIdForDisplay()) + "/" + result.getTestCaseName());
            }
            case EXPORT_TO_NEW_TEST_CASE: {
                return TestCaseController.getInstance().newTestCase(result.getFolder(), result.getTestCaseName());
            }
        }
        return null;
    }
}

