/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.controller;

import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.ReportController;
import com.kms.katalon.core.logging.model.TestSuiteLogRecord;
import com.kms.katalon.core.reporting.ReportUtil;
import com.kms.katalon.entity.report.ReportEntity;
import com.kms.katalon.logging.LogUtil;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;

public class LogRecordController {
    private static LogRecordController _instance;
    private Map<String, TestSuiteLogRecord> suiteLogRecordMap = new HashMap<String, TestSuiteLogRecord>();

    public static LogRecordController getInstance() {
        if (_instance == null) {
            _instance = new LogRecordController();
        }
        return _instance;
    }

    public TestSuiteLogRecord getTestSuiteLogRecord(String reportId) {
        if (StringUtils.isEmpty((String)reportId)) {
            return null;
        }
        try {
            ReportEntity report = ReportController.getInstance().getReportEntityByDisplayId(reportId, ProjectController.getInstance().getCurrentProject());
            return report != null ? this.getTestSuiteLogRecord(report) : null;
        }
        catch (Exception e) {
            LogUtil.logError((Throwable)e);
            return null;
        }
    }

    public TestSuiteLogRecord getTestSuiteLogRecordByFullPath(String reportFullpath) {
        if (StringUtils.isEmpty((String)reportFullpath)) {
            return null;
        }
        try {
            ReportEntity report = ReportController.getInstance().getReportEntityByFullPath(reportFullpath);
            return report != null ? this.getTestSuiteLogRecord(report) : null;
        }
        catch (Exception e) {
            LogUtil.logError((Throwable)e);
            return null;
        }
    }

    public synchronized TestSuiteLogRecord getTestSuiteLogRecord(ReportEntity reportEntity) {
        TestSuiteLogRecord suiteLogRecord = this.suiteLogRecordMap.get(reportEntity.getId());
        if (suiteLogRecord == null) {
            try {
                suiteLogRecord = ReportUtil.generate((String)reportEntity.getLocation());
                this.suiteLogRecordMap.put(reportEntity.getId(), suiteLogRecord);
            }
            catch (Exception e) {
                LogUtil.logError((Throwable)e);
            }
        }
        return suiteLogRecord;
    }

    public synchronized TestSuiteLogRecord getTestSuiteLogRecord(ReportEntity reportEntity, IProgressMonitor progressMonitor) {
        TestSuiteLogRecord suiteLogRecord = this.suiteLogRecordMap.get(reportEntity.getId());
        if (suiteLogRecord == null) {
            try {
                suiteLogRecord = ReportUtil.generate((String)reportEntity.getLocation(), (IProgressMonitor)progressMonitor);
                this.suiteLogRecordMap.put(reportEntity.getId(), suiteLogRecord);
            }
            catch (Exception e) {
                LogUtil.logError((Throwable)e);
            }
        }
        return suiteLogRecord;
    }

    public void refreshLogRecord(ReportEntity reportEntity) {
        if (reportEntity != null) {
            try {
                TestSuiteLogRecord suiteLogRecord = ReportUtil.generate((String)reportEntity.getLocation());
                this.suiteLogRecordMap.put(reportEntity.getId(), suiteLogRecord);
            }
            catch (Exception e) {
                LogUtil.logError((Throwable)e);
            }
        }
    }

    public void deleteReport(String reportId) {
        if (this.suiteLogRecordMap.containsKey(reportId)) {
            this.suiteLogRecordMap.remove(reportId);
        }
    }

    public void clear() {
        this.suiteLogRecordMap.clear();
    }
}

