/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.controller;

import com.kms.katalon.controller.DatabaseController;
import com.kms.katalon.controller.EntityController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.constants.StringConstants;
import com.kms.katalon.core.db.DBConnectionProperties;
import com.kms.katalon.core.db.DatabaseConnection;
import com.kms.katalon.core.exception.DriverNotFoundException;
import com.kms.katalon.core.testdata.DBData;
import com.kms.katalon.core.testdata.TestData;
import com.kms.katalon.core.testdata.TestDataFactory;
import com.kms.katalon.entity.Entity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.link.TestSuiteTestCaseLink;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.entity.testdata.DataFileEntity;
import com.kms.katalon.entity.testdata.DataFilePropertyInputEntity;
import com.kms.katalon.entity.testdata.InternalDataFilePropertyEntity;
import com.kms.katalon.entity.util.Util;
import com.kms.katalon.logging.LogUtil;
import java.io.File;
import java.net.URLClassLoader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class TestDataController
extends EntityController {
    private static EntityController _instance;

    private TestDataController() {
    }

    public static TestDataController getInstance() {
        if (_instance == null) {
            _instance = new TestDataController();
        }
        return (TestDataController)_instance;
    }

    public DataFileEntity newTestData(FolderEntity parentFolder, String testDataName) throws Exception {
        return this.saveNewTestData(this.newTestDataWithoutSave(parentFolder, testDataName));
    }

    public DataFileEntity newTestDataWithoutSave(FolderEntity parentFolder, String testDataName) throws Exception {
        if (parentFolder == null) {
            return null;
        }
        if (StringUtils.isBlank((String)testDataName)) {
            testDataName = StringConstants.CTRL_NEW_TEST_DATA;
        }
        DataFileEntity newTestData = new DataFileEntity();
        newTestData.setDataFileGUID(Util.generateGuid());
        newTestData.setName(this.getAvailableTestDataName(parentFolder, testDataName));
        newTestData.setParentFolder(parentFolder);
        newTestData.setProject(parentFolder.getProject());
        newTestData.setDriver(DataFileEntity.DataFileDriverType.ExcelFile);
        newTestData.setDataSourceUrl("");
        return newTestData;
    }

    public DataFileEntity saveNewTestData(DataFileEntity newTestData) throws Exception {
        return TestDataController.getDataProviderSetting().getDataFileDataProvider().saveNewTestData(newTestData);
    }

    public DataFileEntity updateTestData(DataFileEntity newDataFile, FolderEntity parentFolder) throws Exception {
        return TestDataController.getDataProviderSetting().getDataFileDataProvider().updateTestData(newDataFile);
    }

    public List<DataFileEntity> getDataFileFromParentFolder(FolderEntity parentFolder) throws Exception {
        return TestDataController.getDataProviderSetting().getDataFileDataProvider().getDataFileByFolder(parentFolder);
    }

    public DataFileEntity copyDataFile(DataFileEntity dataFile, FolderEntity targetFolder) throws Exception {
        return TestDataController.getDataProviderSetting().getDataFileDataProvider().copyDataFile(dataFile, targetFolder);
    }

    public DataFileEntity moveDataFile(DataFileEntity dataFile, FolderEntity targetFolder) throws Exception {
        return TestDataController.getDataProviderSetting().getDataFileDataProvider().moveDataFile(dataFile, targetFolder);
    }

    public void deleteDataFile(DataFileEntity dataFile) throws Exception {
        TestDataController.getDataProviderSetting().getDataFileDataProvider().deleteDataFile(dataFile);
    }

    public DataFileEntity updateDataFile(DataFilePropertyInputEntity dataFileInputProperties) throws Exception {
        return TestDataController.getDataProviderSetting().getDataFileDataProvider().updateDataFileProperty(dataFileInputProperties);
    }

    public DataFileEntity updateDataFile(InternalDataFilePropertyEntity internalDataFileInputProperties) throws Exception {
        return TestDataController.getDataProviderSetting().getDataFileDataProvider().updateInternalDataFileProperty(internalDataFileInputProperties);
    }

    public DataFileEntity renameDataFile(DataFileEntity dataFile, String newName) throws Exception {
        DataFilePropertyInputEntity dataFileInputProperties = new DataFilePropertyInputEntity(dataFile);
        dataFileInputProperties.setName(newName);
        return TestDataController.getDataProviderSetting().getDataFileDataProvider().updateDataFileProperty(dataFileInputProperties);
    }

    @Deprecated
    public String getIdForDisplay(DataFileEntity entity) throws Exception {
        return TestDataController.getDataProviderSetting().getDataFileDataProvider().getIdForDisplay(entity).replace(File.separator, "/");
    }

    public List<String> getSibblingDataFileNames(DataFileEntity dataFile) throws Exception {
        List<DataFileEntity> sibblingDataFiles = this.getDataFileFromParentFolder(dataFile.getParentFolder());
        ArrayList<String> sibblingName = new ArrayList<String>();
        for (DataFileEntity sibblingDataFile : sibblingDataFiles) {
            if (TestDataController.getDataProviderSetting().getEntityPk((Entity)sibblingDataFile).equals(TestDataController.getDataProviderSetting().getEntityPk((Entity)dataFile))) continue;
            sibblingName.add(sibblingDataFile.getName());
        }
        return sibblingName;
    }

    public String getAvailableTestDataName(FolderEntity parentFolder, String name) throws Exception {
        return TestDataController.getDataProviderSetting().getDataFileDataProvider().getAvailableDataFileName(parentFolder, name);
    }

    public boolean validateTestDataName(FolderEntity parentFolder, String name) throws Exception {
        return TestDataController.getDataProviderSetting().getDataFileDataProvider().validateDataFileName(parentFolder, name);
    }

    public DataFileEntity getTestDataByDisplayId(String displayId) throws Exception {
        String relativePathWithoutExtensions = displayId.replace("/", File.separator);
        return TestDataController.getDataProviderSetting().getDataFileDataProvider().getDataFileByDisplayId(relativePathWithoutExtensions);
    }

    public DataFileEntity getTestData(String pk) throws Exception {
        return TestDataController.getDataProviderSetting().getDataFileDataProvider().getDataFile(pk);
    }

    public String getTestDataDisplayIdByPk(String pk, String projectLocation) {
        return FilenameUtils.removeExtension((String)pk).replace(String.valueOf(projectLocation) + File.separator, "").replace(File.separator, "/");
    }

    public Map<String, List<TestSuiteTestCaseLink>> getTestDataReferences(DataFileEntity dataFileEntity) throws Exception {
        return TestDataController.getDataProviderSetting().getDataFileDataProvider().getTestDataReferences(dataFileEntity);
    }

    public List<TestCaseEntity> getTestDataReferencesInTestCaseBinding(DataFileEntity dataFileEntity) throws Exception {
        return TestDataController.getDataProviderSetting().getDataFileDataProvider().getTestDataReferencesInTestCaseBinding(dataFileEntity);
    }

    public void reloadTestData(DataFileEntity testData, Entity entity) throws Exception {
        testData = this.getTestData(entity.getId());
        entity = testData;
    }

    public DatabaseConnection getDatabaseConnection(DataFileEntity testData) throws Exception {
        if (testData.getDriver() != DataFileEntity.DataFileDriverType.DBData) {
            throw new IllegalArgumentException(MessageFormat.format(StringConstants.CTRL_EXC_TEST_DATA_IS_NOT_DB_TYPE, testData.getIdForDisplay()));
        }
        return DatabaseController.getInstance().getDatabaseConnection(testData.isUsingGlobalDBSetting(), testData.isSecureUserAccount(), testData.getUser(), testData.getPassword(), testData.getDataSourceUrl(), testData.getDriverClassName(), DBConnectionProperties.convertListToProperties((List)testData.getConnectionProperties().getConnectionProperty()));
    }

    public TestData getTestDataInstance(String dataFileId, String projectLocation) throws Exception {
        DataFileEntity dataFile = this.getTestDataByDisplayId(dataFileId);
        if (dataFile.getDriver() == DataFileEntity.DataFileDriverType.DBData) {
            ClassLoader oldClassLoader = null;
            try {
                DBData dbData;
                oldClassLoader = Thread.currentThread().getContextClassLoader();
                URLClassLoader projectClassLoader = ProjectController.getInstance().getProjectClassLoader(ProjectController.getInstance().getCurrentProject());
                Thread.currentThread().setContextClassLoader(projectClassLoader);
                DatabaseConnection dbConnection = TestDataController.getInstance().getDatabaseConnection(dataFile);
                if (dbConnection == null) {
                    throw new Exception("DatabaseConnection is null");
                }
                dbConnection.getConnection();
                DBData dBData = dbData = new DBData(dbConnection, dataFile.getQuery());
                return dBData;
            }
            catch (Exception e) {
                if (e instanceof DriverNotFoundException) {
                    LogUtil.logError((String)("ERROR: " + e.getMessage()));
                }
                return null;
            }
            finally {
                if (oldClassLoader != null) {
                    Thread.currentThread().setContextClassLoader(oldClassLoader);
                }
            }
        }
        TestData testData = null;
        testData = TestDataFactory.findTestDataForExternalBundleCaller((String)dataFileId, (String)projectLocation);
        return testData;
    }
}

