/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.controller;

import com.google.common.net.UrlEscapers;
import com.kms.katalon.controller.EntityController;
import com.kms.katalon.core.network.ProxyInformation;
import com.kms.katalon.core.testobject.ConditionType;
import com.kms.katalon.core.testobject.HttpBodyContent;
import com.kms.katalon.core.testobject.RequestObject;
import com.kms.katalon.core.testobject.ResponseObject;
import com.kms.katalon.core.testobject.TestObjectProperty;
import com.kms.katalon.core.testobject.ValidationStep;
import com.kms.katalon.core.testobject.authorization.RequestAuthorization;
import com.kms.katalon.core.testobject.impl.HttpTextBodyContent;
import com.kms.katalon.core.testobject.internal.impl.HttpBodyContentReader;
import com.kms.katalon.core.util.ObjectUtil;
import com.kms.katalon.core.util.StrSubstitutor;
import com.kms.katalon.core.webservice.common.ServiceRequestFactory;
import com.kms.katalon.entity.repository.WebElementPropertyEntity;
import com.kms.katalon.entity.repository.WebServiceRequestEntity;
import com.kms.katalon.entity.webservice.RequestHistoryEntity;
import com.kms.katalon.util.URLBuilder;
import com.kms.katalon.util.collections.NameValuePair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class WebServiceController
extends EntityController {
    public static final String KATALON_VERSION_NUMBER_KEY = "katalon.versionNumber";
    private static EntityController _instance;

    private WebServiceController() {
    }

    public static WebServiceController getInstance() {
        if (_instance == null) {
            _instance = new WebServiceController();
        }
        return (WebServiceController)_instance;
    }

    public static RequestObject getRequestObject(WebServiceRequestEntity entity, String projectDir, Map<String, Object> variables) {
        RequestObject requestObject = new RequestObject(entity.getId());
        String serviceType = entity.getServiceType();
        requestObject.setServiceType(serviceType);
        if (entity.getAuthorizationRequest() != null && entity.getAuthorizationRequest().getAuthorizationType() != null && entity.getAuthorizationRequest().getAuthorizationType().endsWith("NTLM")) {
            requestObject.setRequestAuthorization((RequestAuthorization)entity.getAuthorizationRequest());
        }
        requestObject.setName(entity.getName());
        StrSubstitutor substitutor = new StrSubstitutor(variables);
        requestObject.setConnectionTimeout(entity.getConnectionTimeout());
        requestObject.setSocketTimeout(entity.getSocketTimeout());
        requestObject.setMaxResponseSize(entity.getMaxResponseSize());
        if ("SOAP".equals(serviceType)) {
            requestObject.setWsdlAddress(substitutor.replace(entity.getWsdlAddress()));
            requestObject.setSoapRequestMethod(entity.getSoapRequestMethod());
            requestObject.setSoapServiceFunction(entity.getSoapServiceFunction());
            requestObject.setHttpHeaderProperties(WebServiceController.parseProperties(entity.getHttpHeaderProperties(), substitutor));
            requestObject.setSoapBody(substitutor.replace(entity.getSoapBody()));
            requestObject.setUseServiceInfoFromWsdl(entity.isUseServiceInfoFromWsdl());
            requestObject.setSoapServiceEndpoint(substitutor.replace(entity.getSoapServiceEndpoint()));
            requestObject.setValidationSteps(WebServiceController.resolveValidationSteps(entity, substitutor));
        } else if ("RESTful".equals(serviceType)) {
            String rawUrl = entity.getRestUrl();
            String url = WebServiceController.buildUrlFromRaw(rawUrl, substitutor);
            requestObject.setRestUrl(url);
            requestObject.setRestRequestMethod(entity.getRestRequestMethod());
            requestObject.setRestParameters(WebServiceController.parseProperties(entity.getRestParameters(), new StrSubstitutor()));
            requestObject.setHttpHeaderProperties(WebServiceController.parseProperties(entity.getHttpHeaderProperties(), substitutor));
            String httpBodyType = entity.getHttpBodyType();
            String oldVersionBodyContent = entity.getHttpBody();
            if (StringUtils.isNotBlank((String)oldVersionBodyContent)) {
                httpBodyType = "text";
                String body = entity.getHttpBody();
                HttpTextBodyContent httpBodyContent = new HttpTextBodyContent(body);
                requestObject.setBodyContent((HttpBodyContent)httpBodyContent);
            } else if (StringUtils.isNotBlank((String)httpBodyType)) {
                String httpBodyContent = entity.getHttpBodyContent();
                HttpBodyContent bodyContent = HttpBodyContentReader.fromSource((String)httpBodyType, (String)httpBodyContent, (String)projectDir, (StrSubstitutor)substitutor);
                requestObject.setBodyContent(bodyContent);
            }
            requestObject.setValidationSteps(WebServiceController.resolveValidationSteps(entity, substitutor));
        }
        requestObject.setVariables(variables);
        boolean followRedirects = entity.isFollowRedirects();
        requestObject.setFollowRedirects(followRedirects);
        return requestObject;
    }

    private static List<ValidationStep> resolveValidationSteps(WebServiceRequestEntity entity, StrSubstitutor substitutor) {
        return entity.getValidationSteps().stream().map(stepI -> {
            ValidationStep clone = (ValidationStep)ObjectUtil.clone((Object)stepI);
            clone.data = substitutor.replace(clone.data);
            return clone;
        }).collect(Collectors.toList());
    }

    private static String buildUrlFromRaw(String rawUrl, StrSubstitutor substitutor) {
        URLBuilder urlBuilder = new URLBuilder(rawUrl);
        List rawQueryParams = urlBuilder.getQueryParams();
        ArrayList processedQueryParams = new ArrayList();
        rawQueryParams.stream().forEach(p -> {
            String variableExpandedName = substitutor.replace(p.getName());
            String variableExpandedValue = substitutor.replace(p.getValue());
            String escapedName = UrlEscapers.urlFormParameterEscaper().escape(variableExpandedName);
            String escapedValue = UrlEscapers.urlFormParameterEscaper().escape(variableExpandedValue);
            processedQueryParams.add(new NameValuePair(escapedName, escapedValue));
        });
        urlBuilder.setParameters(processedQueryParams);
        String url = urlBuilder.buildString();
        url = substitutor.replace(url);
        return url;
    }

    private static boolean isBodySupported(RequestObject requestObject) {
        String restRequestMethod = requestObject.getRestRequestMethod();
        return !"GET".contains(restRequestMethod);
    }

    private static List<TestObjectProperty> parseProperties(List<WebElementPropertyEntity> objects, StrSubstitutor substitutor) {
        ArrayList<TestObjectProperty> props = new ArrayList<TestObjectProperty>();
        for (WebElementPropertyEntity propertyElementObject : objects) {
            TestObjectProperty objectProperty = new TestObjectProperty();
            objectProperty.setName(substitutor.replace(propertyElementObject.getName()));
            objectProperty.setCondition(ConditionType.fromValue((String)propertyElementObject.getMatchCondition()));
            objectProperty.setValue(substitutor.replace(propertyElementObject.getValue()));
            objectProperty.setActive(propertyElementObject.getIsSelected().booleanValue());
            props.add(objectProperty);
        }
        return props;
    }

    public ResponseObject sendRequest(WebServiceRequestEntity entity, String projectDir, ProxyInformation proxyInformation, Map<String, Object> variables, boolean calledFromKeyword) throws Exception {
        RequestObject requestObject = WebServiceController.getRequestObject(entity, projectDir, variables);
        return ServiceRequestFactory.getInstance((RequestObject)requestObject, (String)projectDir, (ProxyInformation)proxyInformation, (boolean)calledFromKeyword).send(requestObject);
    }

    public List<RequestHistoryEntity> getRequestHistories() {
        return Collections.emptyList();
    }

    public static String extractParamFromRestUrl(String key, String restUrl) {
        String pattern = "(" + key + ")\\=([^&]+)";
        Pattern r = Pattern.compile(pattern);
        Matcher m = r.matcher(restUrl);
        if (m.find()) {
            return m.group(0).split("=")[1];
        }
        return "";
    }
}

