/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.decompiler.cfr.decompiler;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.sf.feeling.decompiler.cfr.decompiler.CfrDecompiler;
import org.sf.feeling.decompiler.editor.BaseDecompilerSourceMapper;

public class CfrSourceMapper
extends BaseDecompilerSourceMapper {
    public CfrSourceMapper() {
        super((IPath)new Path("."), "");
        this.origionalDecompiler = new CfrDecompiler();
    }

    protected void printDecompileReport(StringBuffer source, String fileLocation, Collection exceptions, long decompilationTime) {
        String location = "\tDecompiled from: " + fileLocation;
        source.append("\n\n/*");
        source.append("\n\tDECOMPILATION REPORT\n\n");
        source.append(location).append("\n");
        source.append("\tTotal time: ").append(decompilationTime).append(" ms\n");
        source.append("\t" + this.origionalDecompiler.getLog().replaceAll("\t", "").replaceAll("\n\\s*", "\n\t"));
        exceptions.addAll(this.origionalDecompiler.getExceptions());
        this.logExceptions(exceptions, source);
        source.append("\n*/");
    }

    protected void logExceptions(Collection exceptions, StringBuffer buffer) {
        if (!exceptions.isEmpty()) {
            buffer.append("\n\tCaught exceptions:");
            if (exceptions == null || exceptions.size() == 0) {
                return;
            }
            buffer.append("\n");
            StringWriter stackTraces = new StringWriter();
            PrintWriter stackTracesP = new PrintWriter(stackTraces);
            Iterator i = exceptions.iterator();
            while (i.hasNext()) {
                ((Exception)i.next()).printStackTrace(stackTracesP);
                stackTracesP.println("");
            }
            stackTracesP.flush();
            stackTracesP.close();
            buffer.append(stackTraces.toString());
        }
    }
}

