/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.integration.qtest;

import com.kms.katalon.integration.qtest.credential.IQTestCredential;
import com.kms.katalon.integration.qtest.credential.IQTestToken;
import com.kms.katalon.integration.qtest.credential.QTestTokenManager;
import com.kms.katalon.integration.qtest.exception.QTestAPIConnectionException;
import com.kms.katalon.integration.qtest.exception.QTestException;
import com.kms.katalon.integration.qtest.exception.QTestIOException;
import com.kms.katalon.integration.qtest.exception.QTestInvalidFormatException;
import com.kms.katalon.integration.qtest.exception.QTestUnauthorizedException;
import com.kms.katalon.integration.qtest.helper.QTestAPIRequestHelper;
import com.kms.katalon.integration.qtest.helper.QTestHttpRequestHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.qas.api.internal.util.json.JsonException;
import org.qas.api.internal.util.json.JsonObject;
import org.qas.api.net.UrlEncoder;

public class QTestIntegrationAuthenticationManager {
    private static final String USERNAME_PARAM = "j_username=";
    private static final String PW_PARAM = "j_password=";
    private static final String LOGIN_URL = "/api/login?";

    private QTestIntegrationAuthenticationManager() {
    }

    public static IQTestToken getToken(IQTestCredential qTestCrediential) throws QTestException {
        String requestResult = null;
        switch (qTestCrediential.getVersion()) {
            case V6: {
                requestResult = QTestIntegrationAuthenticationManager.getTokenViaQTestV6(qTestCrediential.getServerUrl(), qTestCrediential.getUsername(), qTestCrediential.getPassword());
                break;
            }
            case V7: {
                requestResult = QTestHttpRequestHelper.getV7Token(qTestCrediential.getServerUrl(), qTestCrediential.getUsername(), qTestCrediential.getPassword());
                break;
            }
        }
        return QTestTokenManager.getToken(requestResult);
    }

    private static String getTokenViaQTestV6(String serverURL, String username, String password) throws QTestException {
        String response;
        OutputStream os;
        HttpURLConnection con;
        block7: {
            String url = String.valueOf(serverURL) + LOGIN_URL + USERNAME_PARAM + UrlEncoder.encode((String)username) + "&" + PW_PARAM + UrlEncoder.encode((String)password);
            con = null;
            os = null;
            response = "";
            URL obj = new URL(url);
            con = (HttpURLConnection)obj.openConnection();
            con.setRequestMethod("POST");
            con.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            con.setDoOutput(true);
            os = con.getOutputStream();
            os.write("".getBytes());
            os.flush();
            int status = con.getResponseCode();
            if (status != 200) break block7;
            String string = QTestAPIRequestHelper.getResponse(con.getInputStream());
            IOUtils.closeQuietly((OutputStream)os);
            return string;
        }
        try {
            try {
                response = QTestAPIRequestHelper.getResponse(con.getErrorStream());
                JsonObject jo = new JsonObject(response.toString());
                throw new QTestIOException(jo.getString("message"));
            }
            catch (IllegalArgumentException ex) {
                throw new QTestAPIConnectionException(ex.getMessage());
            }
            catch (IOException ex) {
                throw new QTestIOException(ex);
            }
            catch (JsonException jsonException) {
                throw QTestInvalidFormatException.createInvalidJsonFormatException(response);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(os);
            throw throwable;
        }
    }

    public static boolean validateToken(String token) {
        return token != null && !token.isEmpty();
    }

    public static void authenticate(String username, String password) throws QTestUnauthorizedException {
        if (username == null || password == null || username.isEmpty() || password.isEmpty()) {
            throw new QTestUnauthorizedException("Your qTest username or password is not valid.\nPlease enter valid username and password in qTest setting page \nby choosing Project->Settings->qTest and click on Generate button.");
        }
    }
}

