/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.integration.qtest.helper;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTVerificationException;
import com.auth0.jwt.exceptions.TokenExpiredException;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.google.api.client.util.PemReader;
import com.google.gson.JsonObject;
import com.kms.katalon.application.utils.ApplicationInfo;
import com.kms.katalon.application.utils.ServerAPICommunicationUtil;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.integration.qtest.helper.ActivationPayload;
import com.kms.katalon.integration.qtest.helper.ResponseActivation;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.util.CryptoUtil;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.InetAddress;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Objects;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;

public class QTestActivationHelper {
    public static boolean activate(String activationCode, String requestCode, StringBuilder errorMessage) {
        block4: {
            try {
                RSAPublicKey publicKey = (RSAPublicKey)QTestActivationHelper.getPublicKey();
                Algorithm algorithm = Algorithm.RSA256((RSAPublicKey)publicKey, null);
                JWTVerifier verifier = JWT.require((Algorithm)algorithm).withIssuer("https://www.katalon.com/").withClaim("requestCode", requestCode).withClaim("offline", Boolean.TRUE).build();
                verifier.verify(activationCode);
                QTestActivationHelper.markActivated(activationCode);
                return true;
            }
            catch (TokenExpiredException tokenExpiredException) {
                errorMessage.append("Expired Activation Code. Please contact qTest for support!");
            }
            catch (JWTVerificationException jWTVerificationException) {
                errorMessage.append("Invalid Activation Code. Please contact qTest for support!");
            }
            catch (Exception ex) {
                LogUtil.logError((Throwable)ex);
                if (errorMessage == null) break block4;
                errorMessage.append("Invalid Activation Code. Please contact qTest for support!");
            }
        }
        return false;
    }

    public static boolean qTestOnlineActivate(String username, String activationCode, StringBuilder errorMessage) {
        block5: {
            ResponseActivation responeOb;
            block4: {
                try {
                    JsonObject activationObject = new JsonObject();
                    activationObject.addProperty("username", StringEscapeUtils.escapeJavaScript((String)StringEscapeUtils.escapeHtml((String)username)));
                    activationObject.addProperty("activationCode", StringEscapeUtils.escapeJavaScript((String)StringEscapeUtils.escapeHtml((String)activationCode)));
                    String result = ServerAPICommunicationUtil.post((String)"/qtest-licenses/activate", (String)activationObject.toString());
                    responeOb = (ResponseActivation)JsonUtil.fromJson((String)result, ResponseActivation.class);
                    if (!"SUCCESS".equalsIgnoreCase(responeOb.getVerified())) break block4;
                    QTestActivationHelper.markActivated(activationCode);
                    return true;
                }
                catch (Exception exception) {
                    errorMessage.append("Could not connect to Katalon License Server. Please try again later!");
                    return false;
                }
            }
            if (!"FAIL".equalsIgnoreCase(responeOb.getVerified())) break block5;
            QTestActivationHelper.getErrorMessage(errorMessage, responeOb.getMessage());
            return false;
        }
        errorMessage.append("The qTest Username or Activation Code you entered is incorrect. Please try again!");
        return false;
    }

    public static ActivationStatus checkActivationStatus() {
        try {
            return QTestActivationHelper.getDecodedJwt() != null ? ActivationStatus.VALIDATED : ActivationStatus.NOT_ACTIVATED;
        }
        catch (TokenExpiredException tokenExpiredException) {
            return ActivationStatus.EXPIRED;
        }
        catch (IOException | GeneralSecurityException exception) {
            return ActivationStatus.NOT_ACTIVATED;
        }
    }

    private static DecodedJWT getDecodedJwt() throws IOException, GeneralSecurityException {
        String activationCode = QTestActivationHelper.getApplicationActivationCode();
        if (StringUtils.isEmpty((String)activationCode)) {
            return null;
        }
        RSAPublicKey publicKey = (RSAPublicKey)QTestActivationHelper.getPublicKey();
        Algorithm algorithm = Algorithm.RSA256((RSAPublicKey)publicKey, null);
        JWTVerifier verifier = JWT.require((Algorithm)algorithm).withIssuer("https://www.katalon.com/").build();
        return verifier.verify(activationCode);
    }

    public static ActivationPayload getActivationPayload() throws IOException, GeneralSecurityException {
        DecodedJWT jwt = QTestActivationHelper.getDecodedJwt();
        if (jwt == null) {
            return null;
        }
        ActivationPayload payload = new ActivationPayload();
        payload.setExp(jwt.getExpiresAt());
        return payload;
    }

    private static void getErrorMessage(StringBuilder errorMessage, String errorResponse) {
        switch (errorResponse) {
            case "LICENSE_ALREADY_ACTIVATED": {
                errorMessage.append("Your activation code has been used. Please use another activation code!");
                break;
            }
            case "LICENSE_EXPIRED": {
                errorMessage.append("Expired Activation Code. Please contact qTest for support!");
                break;
            }
            default: {
                errorMessage.append("The qTest Username or Activation Code you entered is incorrect. Please try again!");
            }
        }
    }

    private static int getHostNameHashValue() throws IOException {
        String ipAddress;
        String hostName = InetAddress.getLocalHost().getHostName();
        if (hostName.equals(ipAddress = InetAddress.getLocalHost().getHostAddress())) {
            hostName = "can.not.get.host.name";
        }
        return Objects.hash(hostName);
    }

    private static void markActivated(String activationCode) throws IOException, GeneralSecurityException {
        String activatedVal = Integer.toString(QTestActivationHelper.getHostNameHashValue());
        String curVersion = new StringBuilder(ApplicationInfo.versionNo().replaceAll("\\.", "")).reverse().toString();
        ApplicationInfo.setAppProperty((String)"activated", (String)(String.valueOf(curVersion) + "_" + activatedVal), (boolean)true);
        String encodedActivationCode = CryptoUtil.encode((CryptoUtil.CrytoInfo)CryptoUtil.getDefault((String)Integer.toString(QTestActivationHelper.getHostNameHashValue()), (String)activationCode));
        ApplicationInfo.setAppProperty((String)"qTest.activationCode", (String)encodedActivationCode, (boolean)true);
        ApplicationInfo.removeAppProperty((String)"activatedRequestCode");
    }

    private static String getApplicationActivationCode() throws IOException, GeneralSecurityException {
        String encodedActivationCode = ApplicationInfo.getAppProperty((String)"qTest.activationCode");
        if (encodedActivationCode != null) {
            return CryptoUtil.decode((CryptoUtil.CrytoInfo)CryptoUtil.getDefault((String)Integer.toString(QTestActivationHelper.getHostNameHashValue()), (String)encodedActivationCode));
        }
        return null;
    }

    private static PublicKey getPublicKey() throws NoSuchAlgorithmException, InvalidKeySpecException, IOException {
        PublicKey publicKey = null;
        KeyFactory kf = KeyFactory.getInstance("RSA");
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(QTestActivationHelper.readPemString("-----BEGIN PUBLIC KEY-----\nMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQClVi5Gck1X4uD9EfpQvPNe4utlRgw9GWhCQNa4gcya6SG3UKwgDvNGyiD3J6w4xM97NUGmDJw7INTKNikVmBjXpTRKq/rWlSUpSkOYB9XT/pNvPf2G8U5qOMnXokGmW5r6GIVuYu6OrhAcAh0nSKYxt/vyLtIvt1SFDkD320fOBwIDAQAB\n-----END PUBLIC KEY-----"));
        publicKey = kf.generatePublic(keySpec);
        return publicKey;
    }

    private static byte[] readPemString(String string) throws IOException {
        return PemReader.readFirstSectionAndClose((Reader)new StringReader(string)).getBase64DecodedBytes();
    }

    public static enum ActivationStatus {
        NOT_ACTIVATED,
        VALIDATED,
        EXPIRED;

    }
}

