/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.integration.qtest.setting;

import com.katalon.platform.api.Plugin;
import com.katalon.platform.api.service.ApplicationManager;
import com.kms.katalon.core.logging.model.TestStatus;
import com.kms.katalon.core.setting.PropertySettingStoreUtil;
import com.kms.katalon.core.setting.ReportFormatType;
import com.kms.katalon.integration.qtest.credential.IQTestCredential;
import com.kms.katalon.integration.qtest.model.ExecutionStatusMapping;
import com.kms.katalon.integration.qtest.setting.QTestAttachmentSendingType;
import com.kms.katalon.integration.qtest.setting.QTestVersion;
import com.kms.katalon.util.CryptoUtil;
import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class QTestSettingStore {
    private static final String FILE_NAME = "com.kms.katalon.integration.qtest";
    public static final String TOKEN_PROPERTY = "token";
    public static final String USERNAME_PROPERTY = "username";
    public static final String PW_PROPERTY = "password";
    public static final String SERVER_URL_PROPERTY = "serverUrl";
    public static final String ENABLE_ENCRYPTION_PROPERTY = "enableAuthenticationEncryption";
    public static final String AUTO_SUBMIT_RESULT_PROPERTY = "autoSubmitResult";
    public static final String SUBMIT_RESULT_TO_LATEST_VERSION = "submitResultToLatestVersion";
    public static final String ENABLE_INTEGRATION_PROPERTY = "enableIntegration";
    public static final String SEND_ATTACHMENTS_PROPERTY = "sendAttachments";
    public static final String FIRST_TIME_USING = "firstTimeUsing";
    public static final String REPORT_FORMAT = "reportFormat";
    public static final String QTEST_VERSION_PROPERTY = "version";
    public static final String GENERATE_PARITY_REPORT_PROPERTY = "generateParityReport";
    public static final String EXECUTION_STATUS_MAPPING = "executionStatusMapping";

    public static File getPropertyFile(String projectDir) throws IOException {
        File configFile = new File(String.valueOf(projectDir) + File.separator + PropertySettingStoreUtil.INTERNAL_SETTING_ROOT_FOLDER_NAME + File.separator + FILE_NAME + ".properties");
        if (!configFile.exists()) {
            configFile.createNewFile();
        }
        return configFile;
    }

    private static void setStringProperty(String key, String defaultValue, boolean shouldEncrypt, String projectDir) throws IOException, GeneralSecurityException {
        String storedUsername = shouldEncrypt ? CryptoUtil.encode((CryptoUtil.CrytoInfo)CryptoUtil.getDefault((String)defaultValue)) : defaultValue;
        PropertySettingStoreUtil.addNewProperty((String)key, (String)storedUsername, (File)QTestSettingStore.getPropertyFile(projectDir));
    }

    private static String getStringProperty(String key, String defaultValue, boolean shouldDecrypt, String projectDir) {
        try {
            String storedValue = PropertySettingStoreUtil.getPropertyValue((String)key, (File)QTestSettingStore.getPropertyFile(projectDir));
            return shouldDecrypt ? CryptoUtil.decode((CryptoUtil.CrytoInfo)CryptoUtil.getDefault((String)storedValue)) : storedValue;
        }
        catch (IOException | GeneralSecurityException exception) {
            return defaultValue;
        }
    }

    static String getRawToken(boolean encryptionEnabled, String projectDir) {
        return QTestSettingStore.getStringProperty(TOKEN_PROPERTY, "", encryptionEnabled, projectDir);
    }

    public static String getUsername(boolean encryptionEnabled, String projectDir) {
        return QTestSettingStore.getStringProperty(USERNAME_PROPERTY, "", encryptionEnabled, projectDir);
    }

    public static String getPassword(boolean encryptionEnabled, String projectDir) {
        return QTestSettingStore.getStringProperty(PW_PROPERTY, "", encryptionEnabled, projectDir);
    }

    public static boolean isEncryptionEnabled(String projectDir) {
        try {
            return Boolean.parseBoolean(PropertySettingStoreUtil.getPropertyValue((String)ENABLE_ENCRYPTION_PROPERTY, (File)QTestSettingStore.getPropertyFile(projectDir)));
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static String getServerUrl(boolean encrypted, String projectDir) {
        try {
            String storedUrl = PropertySettingStoreUtil.getPropertyValue((String)SERVER_URL_PROPERTY, (File)QTestSettingStore.getPropertyFile(projectDir));
            return encrypted ? CryptoUtil.decode((CryptoUtil.CrytoInfo)CryptoUtil.getDefault((String)storedUrl)) : storedUrl;
        }
        catch (IOException | GeneralSecurityException exception) {
            return "";
        }
    }

    public static QTestVersion getQTestVersion(String projectDir) {
        try {
            String versionName = PropertySettingStoreUtil.getPropertyValue((String)QTEST_VERSION_PROPERTY, (File)QTestSettingStore.getPropertyFile(projectDir));
            if (StringUtils.isBlank((String)versionName)) {
                if (!StringUtils.isBlank((String)QTestSettingStore.getRawToken(QTestSettingStore.isEncryptionEnabled(projectDir), projectDir))) {
                    return QTestVersion.V6;
                }
                return QTestVersion.getLastest();
            }
            return QTestVersion.valueOf(versionName);
        }
        catch (IOException iOException) {
            return QTestVersion.getLastest();
        }
    }

    public static void saveUserProfile(IQTestCredential credential, String projectDir) throws IOException, GeneralSecurityException {
        boolean encryptionEnabled = credential.isEncryptionEnabled();
        QTestSettingStore.setEnableEncryption(encryptionEnabled, projectDir);
        String rawToken = credential.getToken() != null ? credential.getToken().getRawToken() : "";
        QTestSettingStore.setStringProperty(TOKEN_PROPERTY, rawToken, encryptionEnabled, projectDir);
        QTestSettingStore.setStringProperty(USERNAME_PROPERTY, credential.getUsername(), encryptionEnabled, projectDir);
        QTestSettingStore.setStringProperty(PW_PROPERTY, credential.getPassword(), encryptionEnabled, projectDir);
        QTestSettingStore.setStringProperty(QTEST_VERSION_PROPERTY, credential.getVersion().name(), false, projectDir);
        String savedServerUrl = credential.getServerUrl();
        while (!savedServerUrl.isEmpty() && savedServerUrl.endsWith("/")) {
            savedServerUrl = savedServerUrl.substring(0, savedServerUrl.length() - 1);
        }
        QTestSettingStore.setStringProperty(SERVER_URL_PROPERTY, savedServerUrl, encryptionEnabled, projectDir);
    }

    public static boolean isAutoSubmitResultActive(String projectDir) {
        try {
            return Boolean.parseBoolean(PropertySettingStoreUtil.getPropertyValue((String)AUTO_SUBMIT_RESULT_PROPERTY, (File)QTestSettingStore.getPropertyFile(projectDir)));
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static boolean isSubmitResultToLatestVersionActive(String projectDir) {
        try {
            return Boolean.parseBoolean(PropertySettingStoreUtil.getPropertyValue((String)SUBMIT_RESULT_TO_LATEST_VERSION, (File)QTestSettingStore.getPropertyFile(projectDir)));
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static boolean isIntegrationActive(String projectDir) {
        try {
            return QTestSettingStore.isQTestPluginInstalled() && Boolean.parseBoolean(PropertySettingStoreUtil.getPropertyValue((String)ENABLE_INTEGRATION_PROPERTY, (File)QTestSettingStore.getPropertyFile(projectDir)));
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private static boolean isQTestPluginInstalled() {
        Plugin plugin = ApplicationManager.getInstance().getPluginManager().getPlugin("com.katalon.katalon-studio-qtest");
        return plugin != null;
    }

    public static void setEnableEncryption(boolean enabled, String projectDir) throws IOException {
        PropertySettingStoreUtil.addNewProperty((String)ENABLE_ENCRYPTION_PROPERTY, (String)Boolean.toString(enabled), (File)QTestSettingStore.getPropertyFile(projectDir));
    }

    public static void saveAutoSubmit(boolean autoSubmit, String projectDir) throws IOException {
        PropertySettingStoreUtil.addNewProperty((String)AUTO_SUBMIT_RESULT_PROPERTY, (String)Boolean.toString(autoSubmit), (File)QTestSettingStore.getPropertyFile(projectDir));
    }

    public static void saveSubmitToLatestVersion(boolean submitToLatest, String projectDir) throws IOException {
        PropertySettingStoreUtil.addNewProperty((String)SUBMIT_RESULT_TO_LATEST_VERSION, (String)Boolean.toString(submitToLatest), (File)QTestSettingStore.getPropertyFile(projectDir));
    }

    public static void saveEnableIntegration(boolean isIntegration, String projectDir) throws IOException {
        PropertySettingStoreUtil.addNewProperty((String)ENABLE_INTEGRATION_PROPERTY, (String)Boolean.toString(isIntegration), (File)QTestSettingStore.getPropertyFile(projectDir));
    }

    public static List<QTestAttachmentSendingType> getAttachmentSendingTypes(String projectDir) {
        try {
            ArrayList<QTestAttachmentSendingType> attachmentSendingTypes = new ArrayList<QTestAttachmentSendingType>();
            String sendingTypePropertyString = PropertySettingStoreUtil.getPropertyValue((String)SEND_ATTACHMENTS_PROPERTY, (File)QTestSettingStore.getPropertyFile(projectDir));
            if (sendingTypePropertyString == null) {
                return Arrays.asList(QTestAttachmentSendingType.values());
            }
            if (sendingTypePropertyString.isEmpty()) {
                return attachmentSendingTypes;
            }
            String[] stringArray = sendingTypePropertyString.trim().split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String sendingTypeName = stringArray[n2];
                attachmentSendingTypes.add(QTestAttachmentSendingType.valueOf(sendingTypeName.trim()));
                ++n2;
            }
            return attachmentSendingTypes;
        }
        catch (IOException | IllegalArgumentException exception) {
            return Collections.emptyList();
        }
    }

    public static void saveAttachmentSendingType(List<QTestAttachmentSendingType> types, String projectDir) {
        try {
            StringBuilder attachmentStringBuilder = new StringBuilder();
            int index = 0;
            while (index < types.size()) {
                attachmentStringBuilder.append(types.get(index).name());
                if (index != types.size() - 1) {
                    attachmentStringBuilder.append(", ");
                }
                ++index;
            }
            PropertySettingStoreUtil.addNewProperty((String)SEND_ATTACHMENTS_PROPERTY, (String)attachmentStringBuilder.toString(), (File)QTestSettingStore.getPropertyFile(projectDir));
        }
        catch (IOException | IllegalArgumentException exception) {}
    }

    public static boolean isTheFirstTime(String projectDir) {
        String value;
        block3: {
            try {
                value = PropertySettingStoreUtil.getPropertyValue((String)FIRST_TIME_USING, (File)QTestSettingStore.getPropertyFile(projectDir));
                if (value != null) break block3;
                return true;
            }
            catch (IOException iOException) {
                return true;
            }
        }
        return Boolean.parseBoolean(value);
    }

    public static void usedSetupWizard(String projectDir) {
        try {
            PropertySettingStoreUtil.addNewProperty((String)FIRST_TIME_USING, (String)Boolean.toString(false), (File)QTestSettingStore.getPropertyFile(projectDir));
        }
        catch (IOException | IllegalArgumentException exception) {}
    }

    public static List<ReportFormatType> getFormatReportTypes(String projectDir) {
        try {
            ArrayList<ReportFormatType> reportFormatTypes = new ArrayList<ReportFormatType>();
            String formatPropertyString = PropertySettingStoreUtil.getPropertyValue((String)REPORT_FORMAT, (File)QTestSettingStore.getPropertyFile(projectDir));
            if (formatPropertyString == null) {
                return Arrays.asList(ReportFormatType.HTML, ReportFormatType.LOG);
            }
            if (formatPropertyString.isEmpty()) {
                return reportFormatTypes;
            }
            String[] stringArray = formatPropertyString.trim().split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String sendingTypeName = stringArray[n2];
                reportFormatTypes.add(ReportFormatType.valueOf((String)sendingTypeName.trim()));
                ++n2;
            }
            return reportFormatTypes;
        }
        catch (IOException | IllegalArgumentException exception) {
            return Collections.emptyList();
        }
    }

    public static void saveFormatReportTypes(List<ReportFormatType> types, String projectDir) {
        try {
            StringBuilder attachmentStringBuilder = new StringBuilder();
            int index = 0;
            while (index < types.size()) {
                attachmentStringBuilder.append(types.get(index).name());
                if (index != types.size() - 1) {
                    attachmentStringBuilder.append(", ");
                }
                ++index;
            }
            PropertySettingStoreUtil.addNewProperty((String)REPORT_FORMAT, (String)attachmentStringBuilder.toString(), (File)QTestSettingStore.getPropertyFile(projectDir));
        }
        catch (IOException | IllegalArgumentException exception) {}
    }

    public static boolean isGenerateParityReportEnabled(String projectDir) {
        try {
            return Boolean.parseBoolean(PropertySettingStoreUtil.getPropertyValue((String)GENERATE_PARITY_REPORT_PROPERTY, (File)QTestSettingStore.getPropertyFile(projectDir)));
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static void saveEnableParityReport(boolean enabled, String projectDir) throws IOException {
        PropertySettingStoreUtil.addNewProperty((String)GENERATE_PARITY_REPORT_PROPERTY, (String)Boolean.toString(enabled), (File)QTestSettingStore.getPropertyFile(projectDir));
    }

    public static void saveExecutionStatusMappings(List<ExecutionStatusMapping> mappings, String projectDir) {
        StringBuilder mappingStringBuilder = new StringBuilder();
        int i = 0;
        while (i < mappings.size()) {
            mappingStringBuilder.append(mappings.get(i).getKatalonStatus());
            mappingStringBuilder.append(" - ");
            mappingStringBuilder.append(mappings.get(i).getQTestStatus());
            if (i != mappings.size() - 1) {
                mappingStringBuilder.append(", ");
            }
            ++i;
        }
        try {
            PropertySettingStoreUtil.addNewProperty((String)EXECUTION_STATUS_MAPPING, (String)mappingStringBuilder.toString(), (File)QTestSettingStore.getPropertyFile(projectDir));
        }
        catch (IOException iOException) {}
    }

    public static List<ExecutionStatusMapping> getExecutionStatusMappings(String projectDir) {
        try {
            ArrayList<ExecutionStatusMapping> executionStatusMappings = new ArrayList<ExecutionStatusMapping>();
            String mappingString = PropertySettingStoreUtil.getPropertyValue((String)EXECUTION_STATUS_MAPPING, (File)QTestSettingStore.getPropertyFile(projectDir));
            if (mappingString == null || mappingString.isEmpty()) {
                return QTestSettingStore.getDefaultStatusMappings();
            }
            String[] stringArray = mappingString.trim().split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String pair = stringArray[n2];
                ExecutionStatusMapping mapping = new ExecutionStatusMapping();
                mapping.setKatalonStatus(pair.trim().split("-")[0].trim());
                mapping.setQTestStatus(pair.trim().split("-")[1].trim());
                executionStatusMappings.add(mapping);
                ++n2;
            }
            return executionStatusMappings;
        }
        catch (IOException | IllegalArgumentException exception) {
            return Collections.emptyList();
        }
    }

    public static List<ExecutionStatusMapping> getDefaultStatusMappings() {
        ArrayList<ExecutionStatusMapping> mappings = new ArrayList<ExecutionStatusMapping>();
        mappings.add(new ExecutionStatusMapping(TestStatus.TestStatusValue.PASSED.toString(), "PASS"));
        mappings.add(new ExecutionStatusMapping(TestStatus.TestStatusValue.FAILED.toString(), "FAIL"));
        mappings.add(new ExecutionStatusMapping(TestStatus.TestStatusValue.INCOMPLETE.toString(), "SKIP"));
        mappings.add(new ExecutionStatusMapping(TestStatus.TestStatusValue.ERROR.toString(), "FAIL"));
        mappings.add(new ExecutionStatusMapping(TestStatus.TestStatusValue.SKIPPED.toString(), "SKIP"));
        return mappings;
    }
}

