/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.integration.qtest.util;

import com.kms.katalon.integration.qtest.exception.QTestIOException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.model.ZipParameters;
import org.qas.api.internal.util.google.io.BaseEncoding;

public class ZipUtil {
    public static ZipFile getZipFile(File zipFile, File folderToZip) throws QTestIOException {
        if (zipFile.exists()) {
            zipFile.delete();
        }
        try {
            ZipFile returnedZipFile = new ZipFile(zipFile);
            ZipParameters parameters = new ZipParameters();
            parameters.setCompressionMethod(8);
            parameters.setCompressionLevel(5);
            returnedZipFile.addFolder(folderToZip.getAbsolutePath(), parameters);
            return returnedZipFile;
        }
        catch (ZipException zipException) {
            throw new QTestIOException("Cannot zip folder: " + folderToZip.getAbsolutePath());
        }
    }

    public static String encodeFileContent(String filePath) throws IOException, QTestIOException {
        try (InputStream is = null;){
            is = new FileInputStream(new File(filePath));
            String string = BaseEncoding.base64().encode(ZipUtil.getBinaryFromInputStream(is));
            return string;
        }
    }

    private static byte[] getBinaryFromInputStream(InputStream content) throws QTestIOException {
        try {
            int length;
            ByteArrayOutputStream output = new ByteArrayOutputStream(1024);
            byte[] buffer = new byte[8096];
            while ((length = content.read(buffer)) > -1) {
                output.write(buffer, 0, length);
            }
            output.close();
            return output.toByteArray();
        }
        catch (IOException ex) {
            throw new QTestIOException(ex, MessageFormat.format("Unable to read input stream: {0}", ex.getMessage()));
        }
    }
}

