/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.ast;

import com.kms.katalon.core.ast.GroovyParser;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.CastExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureListExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.NotExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.stmt.AssertStatement;
import org.codehaus.groovy.ast.stmt.BreakStatement;
import org.codehaus.groovy.ast.stmt.CaseStatement;
import org.codehaus.groovy.ast.stmt.CatchStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.ForStatement;
import org.codehaus.groovy.ast.stmt.IfStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.stmt.SwitchStatement;
import org.codehaus.groovy.ast.stmt.ThrowStatement;
import org.codehaus.groovy.ast.stmt.TryCatchStatement;
import org.codehaus.groovy.ast.stmt.WhileStatement;
import org.codehaus.groovy.syntax.Token;

public class AstTextValueUtil {
    private static AstTextValueUtil _instance;

    protected AstTextValueUtil() {
    }

    public static AstTextValueUtil getInstance() {
        if (_instance == null) {
            _instance = new AstTextValueUtil();
        }
        return _instance;
    }

    public String getTextValue(Object object) {
        if (object instanceof Statement) {
            return this.getTextValue((Statement)object);
        }
        if (object instanceof Expression) {
            return this.getTextValue((Expression)object);
        }
        if (object instanceof Token) {
            return ((Token)object).getText();
        }
        if (object instanceof Parameter) {
            Parameter parameter = (Parameter)object;
            if (parameter != ForStatement.FOR_LOOP_DUMMY) {
                return parameter.getName();
            }
        } else if (object instanceof ClassNode) {
            return ((ClassNode)object).getNameWithoutPackage();
        }
        return "";
    }

    public String getTextValue(Statement statement) {
        if (statement instanceof ExpressionStatement) {
            return this.getTextValue((ExpressionStatement)statement);
        }
        if (statement instanceof IfStatement) {
            return this.getTextValue((IfStatement)statement);
        }
        if (statement instanceof AssertStatement) {
            return this.getTextValue((AssertStatement)statement);
        }
        if (statement instanceof ForStatement) {
            return this.getTextValue((ForStatement)statement);
        }
        if (statement instanceof WhileStatement) {
            return this.getTextValue((WhileStatement)statement);
        }
        if (statement instanceof TryCatchStatement) {
            return this.getTextValue((TryCatchStatement)statement);
        }
        if (statement instanceof CatchStatement) {
            return this.getTextValue((CatchStatement)statement);
        }
        if (statement instanceof SwitchStatement) {
            return this.getTextValue((SwitchStatement)statement);
        }
        if (statement instanceof CaseStatement) {
            return this.getTextValue((CaseStatement)statement);
        }
        if (statement instanceof BreakStatement) {
            return this.getTextValue((BreakStatement)statement);
        }
        if (statement instanceof ThrowStatement) {
            return this.getTextValue((ThrowStatement)statement);
        }
        return statement.getText();
    }

    public String getTextValue(IfStatement ifStatement) {
        return "if (" + this.getTextValue(ifStatement.getBooleanExpression()) + ")";
    }

    public String getTextValue(ExpressionStatement expressionStatement) {
        return this.getTextValue(expressionStatement.getExpression());
    }

    public String getTextValue(AssertStatement assertStatement) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("assert ");
        stringBuilder.append(this.getTextValue(assertStatement.getBooleanExpression()));
        if (assertStatement.getMessageExpression() instanceof ConstantExpression && ((ConstantExpression)assertStatement.getMessageExpression()).getValue() != null) {
            stringBuilder.append(" : ");
            stringBuilder.append(this.getTextValue(assertStatement.getMessageExpression()));
        }
        return stringBuilder.toString();
    }

    public String getInputTextValue(ForStatement forStatement) {
        String value = "";
        if (!(forStatement.getCollectionExpression() instanceof ClosureListExpression) && forStatement.getVariable() != ForStatement.FOR_LOOP_DUMMY) {
            StringBuilder stringBuilder = new StringBuilder();
            GroovyParser astUtil = new GroovyParser(stringBuilder);
            astUtil.parse(new Parameter[]{forStatement.getVariable()});
            value = String.valueOf(value) + astUtil.getValue();
            value = String.valueOf(value) + " : ";
        }
        return String.valueOf(value) + this.getTextValue(forStatement.getCollectionExpression());
    }

    public String getTextValue(ForStatement forStatement) {
        return "for (" + this.getInputTextValue(forStatement) + ")";
    }

    public String getTextValue(WhileStatement whileStatement) {
        return "while (" + this.getTextValue(whileStatement.getBooleanExpression()) + ")";
    }

    public String getTextValue(TryCatchStatement catchStatement) {
        return "try";
    }

    public String getTextValue(ThrowStatement throwStatement) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("throw ");
        stringBuilder.append(this.getTextValue(throwStatement.getExpression()));
        return stringBuilder.toString();
    }

    public String getTextValue(CatchStatement catchStatement) {
        StringBuilder stringBuilder = new StringBuilder();
        new GroovyParser(stringBuilder).parse(new Parameter[]{catchStatement.getVariable()});
        return "catch (" + stringBuilder.toString() + ")";
    }

    public String getTextValue(SwitchStatement switchStatement) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("switch (");
        stringBuilder.append(this.getTextValue(switchStatement.getExpression()));
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public String getTextValue(CaseStatement caseStatement) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("case ");
        stringBuilder.append(this.getTextValue(caseStatement.getExpression()));
        stringBuilder.append(":");
        return stringBuilder.toString();
    }

    public String getTextValue(BreakStatement breakStatement) {
        return "break";
    }

    public String getTextValue(Expression expression) {
        if (expression instanceof BinaryExpression) {
            return this.getTextValue((BinaryExpression)expression);
        }
        if (expression instanceof ConstantExpression) {
            return this.getTextValue((ConstantExpression)expression);
        }
        if (expression instanceof StaticMethodCallExpression) {
            return this.getTextValue((StaticMethodCallExpression)expression);
        }
        if (expression instanceof MethodCallExpression) {
            return this.getTextValue((MethodCallExpression)expression);
        }
        if (expression instanceof TupleExpression) {
            return this.getTextValue((TupleExpression)expression);
        }
        if (expression instanceof PropertyExpression) {
            return this.getTextValue((PropertyExpression)expression);
        }
        if (expression instanceof CastExpression) {
            return this.getTextValue((CastExpression)expression);
        }
        if (expression instanceof ListExpression) {
            return this.getTextValue((ListExpression)expression);
        }
        if (expression instanceof MapExpression) {
            return this.getTextValue((MapExpression)expression);
        }
        if (expression instanceof BooleanExpression) {
            return this.getTextValue((BooleanExpression)expression);
        }
        if (expression instanceof ArgumentListExpression) {
            return this.getTextValue((ArgumentListExpression)expression);
        }
        if (expression instanceof ClassExpression) {
            return this.getTextValue((ClassExpression)expression);
        }
        if (expression != null) {
            return expression.getText();
        }
        return "null";
    }

    public String getTextValue(ArgumentListExpression argumentListExpression) {
        StringBuilder value = new StringBuilder();
        value.append("(");
        int count = argumentListExpression.getExpressions().size();
        for (Expression expression : argumentListExpression.getExpressions()) {
            value.append(this.getTextValue(expression));
            if (--count <= 0) continue;
            value.append(", ");
        }
        value.append(")");
        return value.toString();
    }

    public String getTextValue(CastExpression castExpression) {
        return this.getTextValue(castExpression.getExpression());
    }

    public String getTextValue(BooleanExpression booleanExpression) {
        if (booleanExpression instanceof NotExpression) {
            return "!(" + this.getTextValue(booleanExpression.getExpression()) + ")";
        }
        return this.getTextValue(booleanExpression.getExpression());
    }

    public String getTextValue(ConstantExpression constantExpression) {
        if (constantExpression.getValue() instanceof String) {
            return "\"" + constantExpression.getText() + "\"";
        }
        if (constantExpression.getValue() instanceof Character) {
            return "'" + constantExpression.getText() + "'";
        }
        return constantExpression.getText();
    }

    public String getTextValue(BinaryExpression binaryExpression) {
        if (binaryExpression.getOperation().getType() == 30) {
            return String.valueOf(this.getTextValue(binaryExpression.getLeftExpression())) + "[" + this.getTextValue(binaryExpression.getRightExpression()) + "]";
        }
        return String.valueOf(this.getTextValue(binaryExpression.getLeftExpression())) + " " + binaryExpression.getOperation().getText() + " " + this.getTextValue(binaryExpression.getRightExpression());
    }

    public String getTextValue(StaticMethodCallExpression methodCallExpression) {
        String fullyQualifiedObject = methodCallExpression.getOwnerType().getPlainNodeReference().getName();
        String meth = methodCallExpression.getMethod();
        String args = this.getTextValue(methodCallExpression.getArguments());
        return this.getMethodCallTextValue(fullyQualifiedObject, meth, args);
    }

    private String getMethodCallTextValue(String fullyQualifiedObject, String meth, String args) {
        String object;
        if (fullyQualifiedObject.equals("this") || fullyQualifiedObject.startsWith("com.kms.katalon") || fullyQualifiedObject.startsWith("CustomKeywords")) {
            object = "";
        } else {
            String[] tokens = fullyQualifiedObject.split("\\.");
            object = String.valueOf(tokens[tokens.length - 1]) + ".";
        }
        return String.valueOf(object) + meth + args;
    }

    public String getTextValue(MethodCallExpression methodCallExpression) {
        String fullyQualifiedObject = this.getTextValue(methodCallExpression.getObjectExpression());
        String meth = methodCallExpression.getMethod().getText();
        String args = this.getTextValue(methodCallExpression.getArguments());
        return this.getMethodCallTextValue(fullyQualifiedObject, meth, args);
    }

    public String getTextValue(ClassExpression classExpression) {
        return classExpression.getType().getPlainNodeReference().getName();
    }

    public String getTextValue(TupleExpression tupleExpression) {
        StringBuilder buffer = new StringBuilder("(");
        boolean first = true;
        for (Expression expression : tupleExpression.getExpressions()) {
            if (first) {
                first = false;
            } else {
                buffer.append(", ");
            }
            buffer.append(this.getTextValue(expression));
        }
        buffer.append(")");
        return buffer.toString();
    }

    public String getTextValue(PropertyExpression propertyExpression) {
        return propertyExpression.getProperty().getText();
    }

    public String getTextValue(ListExpression listExpression) {
        StringBuilder buffer = new StringBuilder("[");
        boolean first = true;
        for (Expression expression : listExpression.getExpressions()) {
            if (first) {
                first = false;
            } else {
                buffer.append(", ");
            }
            buffer.append(this.getTextValue(expression));
        }
        buffer.append("]");
        return buffer.toString();
    }

    public String getTextValue(MapExpression mapExpression) {
        StringBuilder sb = new StringBuilder(32);
        sb.append("[");
        int size = mapExpression.getMapEntryExpressions().size();
        MapEntryExpression mapEntryExpression = null;
        if (size > 0) {
            mapEntryExpression = (MapEntryExpression)mapExpression.getMapEntryExpressions().get(0);
            sb.append(String.valueOf(this.getTextValue(mapEntryExpression.getKeyExpression())) + ":" + this.getTextValue(mapEntryExpression.getValueExpression()));
            int i = 1;
            while (i < size) {
                mapEntryExpression = (MapEntryExpression)mapExpression.getMapEntryExpressions().get(i);
                sb.append(", " + this.getTextValue(mapEntryExpression.getKeyExpression()) + ":" + this.getTextValue(mapEntryExpression.getValueExpression()));
                if (sb.length() > 120 && i < size - 1) {
                    sb.append(", ... ");
                    break;
                }
                ++i;
            }
        } else {
            sb.append(":");
        }
        sb.append("]");
        return sb.toString();
    }

    public String getTextValue(FieldNode fieldNode) {
        if (fieldNode.getInitialExpression() != null) {
            return String.valueOf(fieldNode.getName()) + " = " + this.getTextValue(fieldNode.getInitialExpression());
        }
        return fieldNode.getName();
    }
}

