/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.keyword.internal;

import com.kms.katalon.core.annotation.internal.Action;
import com.kms.katalon.core.constants.StringConstants;
import com.kms.katalon.core.exception.StepFailedException;
import com.kms.katalon.core.keyword.internal.IKeyword;
import com.kms.katalon.core.keyword.internal.KeywordExecutionContext;
import com.kms.katalon.core.util.internal.KeywordLoader;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.lang.ref.SoftReference;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;

public class KeywordExecutor
implements GroovyObject {
    public static final String PLATFORM_WEB = "web";
    public static final String PLATFORM_MOBILE = "mobile";
    public static final String PLATFORM_WEB_SERVICE = "webservice";
    public static final String PLATFORM_WINDOWS = "windows";
    public static final String PLATFORM_BUILT_IN = "builtin";
    public static final String WEB_BUILT_IN_KEYWORD_PACKAGE = "com.kms.katalon.core.webui.keyword.builtin";
    public static final String MOBILE_BUILT_IN_KEYWORD_PACKAGE = "com.kms.katalon.core.mobile.keyword.builtin";
    public static final String WEB_SERVICE_BUILT_IN_KEYWORD_PACKAGE = "com.kms.katalon.core.webservice.keyword.builtin";
    public static final String WINDOWS_BUILT_IN_KEYWORD_PACKAGE = "com.kms.katalon.core.windows.keyword.builtin";
    public static final String CORE_BUILT_IN_KEYWORD_PACKAGE = "com.kms.katalon.core.keyword.builtin";
    private static final String INTERNAL_SMART_WAIT_GROOVY_WRAPPER = "internalSmartWaitGroovyWrapper";
    private static Map cachePlatforms;
    private static Map<String, List<IKeyword>> cacheActions;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    @Generated
    public KeywordExecutor() {
        MetaClass metaClass;
        CallSite[] callSiteArray = KeywordExecutor.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    static {
        Object object = KeywordExecutor.$getCallSiteArray()[0].callConstructor(HashMap.class);
        cacheActions = (Map)ScriptBytecodeAdapter.castToType((Object)object, Map.class);
        Object object2 = KeywordExecutor.$getCallSiteArray()[1].callConstructor(HashMap.class);
        cachePlatforms = (Map)ScriptBytecodeAdapter.castToType((Object)object2, Map.class);
    }

    public static Object executeKeywordForPlatform(String platform, String keyword, Object ... params) {
        Object[] actions = (IKeyword[])ScriptBytecodeAdapter.castToType(KeywordExecutor.getActions(platform, keyword, KeywordExecutor.getSuitablePackage(platform)), IKeyword[].class);
        if (actions.length < 1) {
            throw (Throwable)new StepFailedException(MessageFormat.format(StringConstants.KEYWORD_X_DOES_NOT_EXIST_ON_PLATFORM_Y, keyword, platform));
        }
        KeywordExecutionContext.saveRunningKeywordAndPlatform(platform, keyword);
        KeywordExecutionContext.markKeywordsUsage(platform);
        if (platform.equals(PLATFORM_WEB)) {
            Object[] internalSmartWaitGroovyWrappers = (IKeyword[])ScriptBytecodeAdapter.castToType(KeywordExecutor.getActions(PLATFORM_WEB, INTERNAL_SMART_WAIT_GROOVY_WRAPPER, KeywordExecutor.getSuitablePackage(PLATFORM_WEB)), IKeyword[].class);
            if (internalSmartWaitGroovyWrappers.length == 1) {
                ((IKeyword)BytecodeInterface8.objectArrayGet((Object[])internalSmartWaitGroovyWrappers, (int)0)).execute(keyword);
            }
        }
        return ((IKeyword)BytecodeInterface8.objectArrayGet((Object[])actions, (int)0)).execute(params);
    }

    private static String[] getSuitablePackage(String platform) {
        String string = platform;
        if (ScriptBytecodeAdapter.isCase((Object)string, (Object)PLATFORM_WEB)) {
            return new String[]{WEB_BUILT_IN_KEYWORD_PACKAGE};
        }
        if (ScriptBytecodeAdapter.isCase((Object)string, (Object)PLATFORM_MOBILE)) {
            return new String[]{MOBILE_BUILT_IN_KEYWORD_PACKAGE};
        }
        if (ScriptBytecodeAdapter.isCase((Object)string, (Object)PLATFORM_WEB_SERVICE)) {
            return new String[]{WEB_SERVICE_BUILT_IN_KEYWORD_PACKAGE};
        }
        if (ScriptBytecodeAdapter.isCase((Object)string, (Object)PLATFORM_WINDOWS)) {
            return new String[]{WINDOWS_BUILT_IN_KEYWORD_PACKAGE};
        }
        if (ScriptBytecodeAdapter.isCase((Object)string, (Object)PLATFORM_BUILT_IN)) {
            return new String[]{CORE_BUILT_IN_KEYWORD_PACKAGE};
        }
        return new String[0];
    }

    private static List<IKeyword> getActions(String platform, String keyword, String ... searchPackages) {
        if (cachePlatforms.containsKey(platform)) {
            Map cacheActions = (Map)ScriptBytecodeAdapter.castToType(cachePlatforms.get(platform), Map.class);
            if (cacheActions.containsKey(keyword)) {
                cacheActions.get(keyword);
            }
        }
        if (searchPackages == null || searchPackages.length == 0) {
            return ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        }
        ArrayList<IKeyword> actions = new ArrayList<IKeyword>();
        List<Class<?>> classes = KeywordLoader.listClasses(searchPackages);
        List<Class<?>> list = classes;
        Iterator<Class<?>> iterator = list != null ? list.iterator() : null;
        Class cls = null;
        Iterator<Class<?>> iterator2 = iterator;
        if (iterator2 != null) {
            while (iterator2.hasNext()) {
                cls = ShortTypeHandling.castToClass(iterator2.next());
                if (!IKeyword.class.isAssignableFrom(cls)) continue;
                Action act = cls.getAnnotation(Action.class);
                if (act == null || !act.value().equalsIgnoreCase(keyword)) continue;
                try {
                    actions.add((IKeyword)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.newInstance((Class)cls), IKeyword.class));
                }
                catch (Exception ex) {
                    throw (Throwable)new StepFailedException(MessageFormat.format(StringConstants.KEYWORD_EXECUTOR_ERROR_MSG, ex.getMessage()));
                }
            }
        }
        HashMap<String, ArrayList<IKeyword>> cacheActions = cachePlatforms.containsKey(platform) ? (Map)ScriptBytecodeAdapter.castToType(cachePlatforms.get(platform), Map.class) : new HashMap<String, ArrayList<IKeyword>>();
        cacheActions.put(keyword, actions);
        cachePlatforms.put(platform, cacheActions);
        return actions;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != KeywordExecutor.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "<$constructor$>";
        stringArray[1] = "<$constructor$>";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[2];
        KeywordExecutor.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(KeywordExecutor.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = KeywordExecutor.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

