/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.logging;

import com.kms.katalon.core.constants.CoreMessageConstants;
import com.kms.katalon.core.logging.LogLevel;
import com.kms.katalon.core.logging.XMLLoggerParser;
import com.kms.katalon.core.logging.XmlLogRecord;
import com.kms.katalon.core.logging.model.ILogRecord;
import com.kms.katalon.core.logging.model.MessageLogRecord;
import com.kms.katalon.core.logging.model.TestCaseLogRecord;
import com.kms.katalon.core.logging.model.TestStatus;
import com.kms.katalon.core.logging.model.TestStepLogRecord;
import com.kms.katalon.core.logging.model.TestSuiteLogRecord;
import com.kms.katalon.util.XmlInputFactoryProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Scanner;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.eclipse.core.runtime.IProgressMonitor;

public class TestSuiteXMLLogParser {
    private static final String XML_DESCRIPTOR_SUFFIX = "?>";
    private static final String XML_DESCRIPTOR_PREFIX = "<?xml";
    private static final String LOG_FILE_START_TAG = "<log>";
    private static final String LOG_FILE_END_TAG = "</log>";
    private static final String UTF_8 = "UTF-8";
    private TestSuiteLogRecord testSuiteLogRecord;
    private XmlLogRecord xmlLogRecord;

    public TestSuiteLogRecord readTestSuiteLogFromXMLFiles(String logFolder, IProgressMonitor progressMonitor) throws XMLStreamException, IOException {
        File[] xmlFiles = XMLLoggerParser.getSortedLogFile(logFolder);
        if (xmlFiles == null || xmlFiles.length == 0) {
            return null;
        }
        XMLInputFactory inputFactory = XmlInputFactoryProvider.newInstance();
        ArrayDeque<Object> stack = new ArrayDeque<Object>();
        progressMonitor.beginTask(CoreMessageConstants.MSG_INFO_PARSING_LOG_FILES, xmlFiles.length);
        File[] fileArray = xmlFiles;
        int n = xmlFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File xmlFile = fileArray[n2];
            try {
                this.processFile(logFolder, progressMonitor, inputFactory, stack, xmlFile);
            }
            catch (XMLStreamException xMLStreamException) {
                TestSuiteXMLLogParser.cleanUpXmlLogFile(xmlFile);
                this.processFile(logFolder, progressMonitor, inputFactory, stack, xmlFile);
            }
            ++n2;
        }
        while (stack.size() > 0) {
            Object object = stack.pollLast();
            if (!(object instanceof ILogRecord)) continue;
            TestSuiteXMLLogParser.processInterruptedLog((ILogRecord)object);
        }
        return this.testSuiteLogRecord;
    }

    private void processFile(String logFolder, IProgressMonitor progressMonitor, XMLInputFactory inputFactory, Deque<Object> stack, File xmlFile) throws IOException, XMLStreamException, FileNotFoundException {
        progressMonitor.subTask(MessageFormat.format(CoreMessageConstants.MSG_INFO_PARSING_X, xmlFile.getName()));
        if (progressMonitor.isCanceled()) {
            return;
        }
        XMLStreamReader reader = null;
        try {
            reader = inputFactory.createXMLStreamReader(new FileReader(xmlFile));
            block6: while (reader.hasNext()) {
                int eventType = reader.next();
                switch (eventType) {
                    case 1: {
                        String elementName = reader.getLocalName();
                        if (!elementName.equals("record")) continue block6;
                        this.xmlLogRecord = XMLLoggerParser.readRecord(reader);
                        String sourceMethodName = this.xmlLogRecord.getSourceMethodName();
                        if (LogLevel.START.toString().equals(this.xmlLogRecord.getLevel().getName())) {
                            if ("startSuite".equals(sourceMethodName)) {
                                this.testSuiteLogRecord = TestSuiteXMLLogParser.processStartTestSuiteLog(stack, logFolder, this.xmlLogRecord);
                                break;
                            }
                            if ("startTest".equals(sourceMethodName)) {
                                TestSuiteXMLLogParser.processStartTestCaseLog(stack, this.xmlLogRecord);
                                break;
                            }
                            if (!"startKeyword".equals(sourceMethodName)) break;
                            TestSuiteXMLLogParser.processStartKeywordLog(stack, this.xmlLogRecord);
                            break;
                        }
                        if (LogLevel.END.toString().equals(this.xmlLogRecord.getLevel().getName())) {
                            if (!"endKeyword".equals(sourceMethodName) && !"endTest".equals(sourceMethodName) && !"endSuite".equals(sourceMethodName)) continue block6;
                            TestSuiteXMLLogParser.processEndLog(stack, this.xmlLogRecord);
                            break;
                        }
                        if (LogLevel.RUN_DATA.toString().equals(this.xmlLogRecord.getLevel().getName())) {
                            this.testSuiteLogRecord.addRunData(this.xmlLogRecord.getProperties());
                            break;
                        }
                        Object object = stack.peekLast();
                        if (!(object instanceof ILogRecord)) break;
                        TestSuiteXMLLogParser.processStepMessageLog(this.xmlLogRecord, (ILogRecord)object);
                        break;
                    }
                }
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            progressMonitor.worked(1);
        }
    }

    private static void cleanUpXmlLogFile(File xmlFile) throws IOException {
        FileInputStream inputStream = null;
        Scanner sc = null;
        StringBuilder cleanContentBuilder = new StringBuilder();
        try {
            inputStream = new FileInputStream(xmlFile);
            sc = new Scanner((InputStream)inputStream, UTF_8);
            while (sc.hasNextLine()) {
                String line = sc.nextLine();
                if (TestSuiteXMLLogParser.isMalformXmlLine(cleanContentBuilder, line)) continue;
                if (line.startsWith(LOG_FILE_END_TAG)) {
                    line = line.replaceFirst(LOG_FILE_END_TAG, "");
                }
                cleanContentBuilder.append(line).append("\n");
            }
            if (sc.ioException() != null) {
                throw sc.ioException();
            }
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (sc != null) {
                sc.close();
            }
        }
        String cleanContent = cleanContentBuilder.toString();
        if (!cleanContent.endsWith(LOG_FILE_END_TAG)) {
            cleanContent = String.valueOf(cleanContent) + LOG_FILE_END_TAG;
        }
        FileUtils.writeStringToFile((File)xmlFile, (String)cleanContent, (String)UTF_8);
    }

    private static boolean isMalformXmlLine(StringBuilder cleanContentBuilder, String line) {
        return line.startsWith(XML_DESCRIPTOR_PREFIX) && line.endsWith(XML_DESCRIPTOR_SUFFIX) && cleanContentBuilder.lastIndexOf(XML_DESCRIPTOR_PREFIX) != -1 || line.equals(LOG_FILE_START_TAG) && cleanContentBuilder.lastIndexOf(LOG_FILE_START_TAG) != -1 || line.equals(LOG_FILE_END_TAG);
    }

    private static void processInterruptedLog(ILogRecord logRecord) {
        ILogRecord[] childRecords = logRecord.getChildRecords();
        if (childRecords != null && childRecords.length > 0) {
            ILogRecord lastLogRecord = childRecords[childRecords.length - 1];
            logRecord.setEndTime(lastLogRecord.getEndTime() != 0L ? lastLogRecord.getEndTime() : lastLogRecord.getStartTime());
        } else {
            logRecord.setEndTime(logRecord.getStartTime());
        }
        logRecord.setInterrupted(true);
    }

    private static void processStepMessageLog(XmlLogRecord xmlLogRecord, ILogRecord logRecord) {
        if (logRecord instanceof TestSuiteLogRecord) {
            return;
        }
        MessageLogRecord messageLogRecord = new MessageLogRecord();
        messageLogRecord.setStartTime(xmlLogRecord.getMillis());
        messageLogRecord.setMessage(xmlLogRecord.getMessage());
        if (xmlLogRecord.getProperties() != null && xmlLogRecord.getProperties().get("attachment") != null) {
            messageLogRecord.setAttachment(xmlLogRecord.getProperties().get("attachment"));
        }
        LogLevel logLevel = LogLevel.valueOf(xmlLogRecord.getLevel().toString());
        TestStatus testStatus = TestSuiteXMLLogParser.evalTestStatus(logRecord, logLevel);
        messageLogRecord.setStatus(testStatus);
        logRecord.addChildRecord(messageLogRecord);
    }

    private static void processEndLog(Deque<Object> stack, XmlLogRecord xmlLogRecord) {
        Object object = stack.pollLast();
        if (object != null && object instanceof ILogRecord) {
            ((ILogRecord)object).setEndTime(xmlLogRecord.getMillis());
            ((ILogRecord)object).setProperties(xmlLogRecord.getProperties());
        }
    }

    private static String getTestLogName(XmlLogRecord xmlLogRecord) {
        String testLogName = xmlLogRecord.getMessage();
        if (testLogName == null) {
            return "";
        }
        String startKeywordString = "Start action : ";
        if (testLogName.startsWith(startKeywordString)) {
            return testLogName.substring(startKeywordString.length(), testLogName.length());
        }
        return testLogName;
    }

    private static void processStartKeywordLog(Deque<Object> stack, XmlLogRecord xmlLogRecord) {
        TestStepLogRecord testStepLogRecord = new TestStepLogRecord(TestSuiteXMLLogParser.getTestLogName(xmlLogRecord));
        testStepLogRecord.setStartTime(xmlLogRecord.getMillis());
        testStepLogRecord.setDescription(xmlLogRecord.getProperties().containsKey("description") ? xmlLogRecord.getProperties().get("description") : "");
        try {
            testStepLogRecord.setIndex(Integer.valueOf(xmlLogRecord.getProperties().get("stepIndex")));
        }
        catch (NumberFormatException numberFormatException) {
            testStepLogRecord.setIndex(-1);
        }
        testStepLogRecord.setIgnoredIfFailed(Boolean.valueOf(xmlLogRecord.getProperties().get("isIgnoredIfFailed")));
        Object object = stack.peekLast();
        if (object instanceof TestCaseLogRecord || object instanceof TestStepLogRecord) {
            ((ILogRecord)object).addChildRecord(testStepLogRecord);
        }
        stack.add(testStepLogRecord);
    }

    private static void processStartTestCaseLog(Deque<Object> stack, XmlLogRecord xmlLogRecord) {
        TestCaseLogRecord testCaseLogRecord = new TestCaseLogRecord(xmlLogRecord.getProperties().containsKey("name") ? xmlLogRecord.getProperties().get("name") : TestSuiteXMLLogParser.getTestLogName(xmlLogRecord));
        testCaseLogRecord.setStartTime(xmlLogRecord.getMillis());
        testCaseLogRecord.setId(xmlLogRecord.getProperties().containsKey("id") ? xmlLogRecord.getProperties().get("id") : "");
        testCaseLogRecord.setSource(xmlLogRecord.getProperties().containsKey("source") ? xmlLogRecord.getProperties().get("source") : "");
        testCaseLogRecord.setDescription(xmlLogRecord.getProperties().containsKey("description") ? StringEscapeUtils.unescapeJava((String)xmlLogRecord.getProperties().get("description")) : "");
        testCaseLogRecord.setTag(xmlLogRecord.getProperties().containsKey("tag") ? StringEscapeUtils.unescapeJava((String)xmlLogRecord.getProperties().get("tag")) : "");
        testCaseLogRecord.setOptional(xmlLogRecord.getProperties().containsKey("isOptional") ? Boolean.valueOf(xmlLogRecord.getProperties().get("isOptional")) : false);
        testCaseLogRecord.setIterationVariableValue(xmlLogRecord.getProperties().containsKey("iteration") ? xmlLogRecord.getProperties().get("iteration") : "");
        Object object = stack.peekLast();
        if (object instanceof TestSuiteLogRecord || object instanceof TestStepLogRecord) {
            ((ILogRecord)object).addChildRecord(testCaseLogRecord);
        }
        stack.add(testCaseLogRecord);
    }

    private static TestSuiteLogRecord processStartTestSuiteLog(Deque<Object> stack, String logFolder, XmlLogRecord xmlLogRecord) {
        TestSuiteLogRecord testSuiteLogRecord = new TestSuiteLogRecord("", logFolder);
        testSuiteLogRecord.setStartTime(xmlLogRecord.getMillis());
        testSuiteLogRecord.setName(xmlLogRecord.getProperties().containsKey("name") ? xmlLogRecord.getProperties().get("name") : TestSuiteXMLLogParser.getTestLogName(xmlLogRecord));
        testSuiteLogRecord.setId(xmlLogRecord.getProperties().containsKey("id") ? xmlLogRecord.getProperties().get("id") : "");
        testSuiteLogRecord.setSource(xmlLogRecord.getProperties().containsKey("source") ? xmlLogRecord.getProperties().get("source") : "");
        testSuiteLogRecord.setDevicePlatform(xmlLogRecord.getProperties().containsKey("devicePlatform") ? xmlLogRecord.getProperties().get("devicePlatform") : "");
        testSuiteLogRecord.setDescription(xmlLogRecord.getProperties().containsKey("description") ? xmlLogRecord.getProperties().get("description") : "");
        stack.add(testSuiteLogRecord);
        return testSuiteLogRecord;
    }

    private static TestStatus evalTestStatus(ILogRecord logRecord, LogLevel level) {
        TestStatus testStatus = new TestStatus();
        testStatus.setStatusValue(TestStatus.TestStatusValue.valueOf(level.name()));
        return testStatus;
    }
}

