/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.logging;

import com.kms.katalon.core.configuration.RunConfiguration;
import com.kms.katalon.core.constants.CoreMessageConstants;
import com.kms.katalon.core.logging.CustomSocketLogFomatter;
import com.kms.katalon.core.logging.CustomXmlFormatter;
import com.kms.katalon.core.logging.KeywordLogger;
import com.kms.katalon.core.logging.LogLevel;
import com.kms.katalon.core.logging.SystemSocketHandler;
import com.kms.katalon.core.logging.XmlLogRecord;
import com.kms.katalon.core.util.TestCloudPropertyUtil;
import com.kms.katalon.core.util.internal.ExceptionsUtil;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;

class XmlKeywordLogger {
    private static final int MAXIMUM_LOG_FILES = 100;
    private static final int MAXIMUM_LOG_FILE_SIZE = 0xA00000;
    private Logger logger;
    private String pendingDescription = null;
    private Stack<KeywordLogger.KeywordStackElement> currentKeywordStack = null;
    private Stack<Stack<KeywordLogger.KeywordStackElement>> keywordStacksContainer = new Stack();
    private int nestedLevel;
    private static final ThreadLocal<XmlKeywordLogger> localXmlKeywordLoggerStorage = new ThreadLocal<XmlKeywordLogger>(){

        @Override
        protected XmlKeywordLogger initialValue() {
            return new XmlKeywordLogger();
        }
    };

    static XmlKeywordLogger getInstance() {
        return localXmlKeywordLoggerStorage.get();
    }

    private XmlKeywordLogger() {
    }

    private Logger getLogger() {
        if (this.logger == null) {
            this.logger = Logger.getLogger(XmlKeywordLogger.class.getName());
            this.logger.setUseParentHandlers(false);
        }
        if (this.isInRunningMode()) {
            String logFolder = this.getLogFolderPath();
            if (this.logger.getHandlers().length == 0 && StringUtils.isNotEmpty((String)logFolder)) {
                try {
                    FileHandler fileHandler = new FileHandler(String.valueOf(logFolder) + File.separator + "execution%g.log", 0xA00000, 100, true);
                    fileHandler.setEncoding("UTF-8");
                    fileHandler.setFormatter(new CustomXmlFormatter());
                    this.logger.addHandler(fileHandler);
                    SystemSocketHandler socketHandler = new SystemSocketHandler("127.0.0.1", this.getPort());
                    socketHandler.setEncoding("UTF-8");
                    socketHandler.setFormatter(new CustomSocketLogFomatter());
                    this.logger.addHandler(socketHandler);
                }
                catch (SecurityException e) {
                    System.err.println(MessageFormat.format(CoreMessageConstants.MSG_ERR_UNABLE_TO_CREATE_LOGGER, e.getMessage()));
                }
                catch (IOException e) {
                    System.err.println(MessageFormat.format(CoreMessageConstants.MSG_ERR_UNABLE_TO_CREATE_LOGGER, e.getMessage()));
                }
            }
        }
        return this.logger;
    }

    private boolean isInRunningMode() {
        return this.getPort() != 0;
    }

    void close() {
        Handler[] handlerArray = this.logger.getHandlers();
        int n = handlerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Handler handler = handlerArray[n2];
            handler.close();
            ++n2;
        }
    }

    static void cleanUp() {
    }

    String getLogFolderPath() {
        String logFilePath = RunConfiguration.getSettingFilePath();
        return logFilePath != null ? new File(logFilePath).getParentFile().getAbsolutePath() : null;
    }

    private int getPort() {
        return RunConfiguration.getPort();
    }

    void startSuite(String name, Map<String, String> attributes) {
        this.getLogger().log(new XmlLogRecord(LogLevel.START.getLevel(), "Start Test Suite : " + name, this.nestedLevel, attributes));
    }

    void startTestCaseBinding(String name) {
        this.getLogger().log(new XmlLogRecord(LogLevel.START.getLevel(), "Start Test Case Binding : " + name, this.nestedLevel));
    }

    void endSuite(String name, Map<String, String> attributes) {
        this.getLogger().log(new XmlLogRecord(LogLevel.END.getLevel(), "End Test Suite : " + name, this.nestedLevel, attributes));
    }

    void endTestCaseBinding(String name) {
        this.getLogger().log(new XmlLogRecord(LogLevel.END.getLevel(), "End Test Case Binding : " + name, this.nestedLevel));
    }

    void startTest(String name, Map<String, String> attributes, Stack<KeywordLogger.KeywordStackElement> keywordStack) {
        ++this.nestedLevel;
        this.getLogger().log(new XmlLogRecord(LogLevel.START.getLevel(), "Start Test Case : " + name, this.nestedLevel, attributes));
        this.setCurrentKeywordStack(keywordStack);
    }

    private void setCurrentKeywordStack(Stack<KeywordLogger.KeywordStackElement> newKeywordStack) {
        if (this.currentKeywordStack != null) {
            this.keywordStacksContainer.push(this.currentKeywordStack);
        }
        this.currentKeywordStack = newKeywordStack;
    }

    void endTest(String name, Map<String, String> attributes) {
        --this.nestedLevel;
        this.getLogger().log(new XmlLogRecord(LogLevel.END.getLevel(), "End Test Case : " + name, this.nestedLevel, attributes));
        this.restorePreviousKeywordStack();
    }

    private void restorePreviousKeywordStack() {
        this.currentKeywordStack = !this.keywordStacksContainer.isEmpty() ? this.keywordStacksContainer.pop() : null;
    }

    void startListenerKeyword(String name, Map<String, String> attributes, Stack<KeywordLogger.KeywordStackElement> keywordStack) {
        HashMap<String, String> modifiedAttr = new HashMap<String, String>(attributes != null ? attributes : Collections.emptyMap());
        modifiedAttr.put("isIgnoredIfFailed", Boolean.toString(true));
        this.startKeyword(name, "listener action", attributes, keywordStack);
    }

    void startKeyword(String name, String actionType, Map<String, String> attributes, Stack<KeywordLogger.KeywordStackElement> keywordStack) {
        if (attributes == null) {
            attributes = new HashMap<String, String>();
        }
        if (this.pendingDescription != null) {
            attributes.put("description", this.pendingDescription);
            this.pendingDescription = null;
        }
        this.getLogger().log(new XmlLogRecord(LogLevel.START.getLevel(), "Start " + actionType + " : " + name, this.nestedLevel, attributes));
        if (this.currentKeywordStack != null) {
            this.keywordStacksContainer.push(this.currentKeywordStack);
        }
        this.currentKeywordStack = keywordStack;
    }

    void startKeyword(String name, Map<String, String> attributes, Stack<KeywordLogger.KeywordStackElement> keywordStack) {
        if (attributes == null) {
            attributes = new HashMap<String, String>();
        }
        if (this.pendingDescription != null) {
            attributes.put("description", this.pendingDescription);
            this.pendingDescription = null;
        }
        this.getLogger().log(new XmlLogRecord(LogLevel.START.getLevel(), "Start action : " + name, this.nestedLevel, attributes));
        if (this.currentKeywordStack != null) {
            this.keywordStacksContainer.push(this.currentKeywordStack);
        }
        this.currentKeywordStack = keywordStack;
    }

    void startKeyword(String name, Map<String, String> attributes, int nestedLevel) {
        if (attributes == null) {
            attributes = new HashMap<String, String>();
        }
        if (this.pendingDescription != null) {
            attributes.put("description", this.pendingDescription);
            this.pendingDescription = null;
        }
        this.popKeywordFromStack(nestedLevel);
        name = TestCloudPropertyUtil.getInstance().hideTestCloudSensitiveName(name);
        this.getLogger().log(new XmlLogRecord(LogLevel.START.getLevel(), "Start action : " + name, nestedLevel, attributes));
        this.pushKeywordToStack(name, nestedLevel);
    }

    private void pushKeywordToStack(String keywordName, int nestedLevel) {
        if (this.currentKeywordStack != null) {
            this.currentKeywordStack.push(new KeywordLogger.KeywordStackElement(keywordName, nestedLevel));
        }
    }

    private void popKeywordFromStack(int nestedLevel) {
        while (this.currentKeywordStack != null && !this.currentKeywordStack.isEmpty() && this.currentKeywordStack.peek().getNestedLevel() >= nestedLevel) {
            KeywordLogger.KeywordStackElement keywordStackElement = this.currentKeywordStack.pop();
            this.endKeyword(keywordStackElement.getKeywordName(), null, keywordStackElement.getNestedLevel());
        }
    }

    void endKeyword(String name, Map<String, String> attributes, int nestedLevel) {
        this.getLogger().log(new XmlLogRecord(LogLevel.END.getLevel(), "End action : " + name, nestedLevel, attributes));
    }

    void endListenerKeyword(String name, Map<String, String> attributes, Stack<KeywordLogger.KeywordStackElement> keywordStack) {
        this.endKeyword(name, "listener action", attributes, keywordStack);
    }

    void endKeyword(String name, String keywordType, Map<String, String> attributes, Stack<KeywordLogger.KeywordStackElement> keywordStack) {
        this.getLogger().log(new XmlLogRecord(LogLevel.END.getLevel(), "End " + keywordType + " : " + name, this.nestedLevel, attributes));
        this.currentKeywordStack = this.currentKeywordStack == keywordStack && !this.keywordStacksContainer.isEmpty() ? this.keywordStacksContainer.pop() : null;
    }

    void endKeyword(String name, Map<String, String> attributes, Stack<KeywordLogger.KeywordStackElement> keywordStack) {
        this.endKeyword(name, "End action", attributes, keywordStack);
    }

    void logFailed(String message, Map<String, String> attributes) {
        this.logMessage(null, LogLevel.FAILED, message, attributes);
    }

    void logWarning(String message, Map<String, String> attributes) {
        this.logMessage(null, LogLevel.WARNING, message, attributes);
    }

    void logPassed(String message, Map<String, String> attributes) {
        this.logMessage(null, LogLevel.PASSED, message, attributes);
    }

    void logInfo(KeywordLogger keywordLogger, String message, Map<String, String> attributes) {
        this.logMessage(keywordLogger, LogLevel.INFO, message, attributes);
    }

    void logDebug(KeywordLogger keywordLogger, String message, Map<String, String> attributes) {
        this.logMessage(keywordLogger, LogLevel.DEBUG, message, attributes);
    }

    void logRunData(String dataKey, String dataValue) {
        HashMap<String, String> attributeMap = new HashMap<String, String>();
        attributeMap.put(dataKey, dataValue);
        this.logMessage(null, LogLevel.RUN_DATA, String.valueOf(dataKey) + " = " + dataValue, attributeMap);
    }

    void logError(String message, Map<String, String> attributes) {
        this.logMessage(null, LogLevel.ERROR, message, attributes);
    }

    void logMessage(KeywordLogger keywordLogger, LogLevel originalLevel, String message, Map<String, String> attributes) {
        if (message == null) {
            message = "";
        }
        Logger logger = this.getLogger();
        LogLevel level = LogLevel.DEBUG.equals((Object)originalLevel) ? LogLevel.INFO : originalLevel;
        if (logger != null) {
            XmlLogRecord xmlLogRecord = new XmlLogRecord(level.getLevel(), message, this.nestedLevel, attributes);
            if (this.shouldLog(keywordLogger, originalLevel)) {
                logger.log(xmlLogRecord);
            }
        }
    }

    private boolean shouldLog(KeywordLogger keywordLogger, LogLevel originalLevel) {
        if (keywordLogger == null) {
            return true;
        }
        if (LogLevel.INFO.equals((Object)originalLevel) && !keywordLogger.isInfoEnabled()) {
            return false;
        }
        return !LogLevel.DEBUG.equals((Object)originalLevel) || keywordLogger.isDebugEnabled();
    }

    void logMessage(LogLevel level, String message, Throwable thrown) {
        Logger logger = this.getLogger();
        Throwable rootCause = ExceptionUtils.getRootCause((Throwable)thrown);
        if (rootCause == null) {
            rootCause = thrown;
        }
        if (message == null) {
            message = "";
        }
        if (logger != null) {
            XmlLogRecord logRecord = new XmlLogRecord(level.getLevel(), message);
            Map<String, String> attributes = this.getAttributesFrom(thrown);
            logRecord.setThrown(thrown);
            logRecord.setProperties(attributes);
            logger.log(logRecord);
        }
    }

    void setPendingDescription(String stepDescription) {
        this.pendingDescription = stepDescription;
    }

    void logNotRun(String message, Map<String, String> attributes) {
        this.logMessage(null, LogLevel.NOT_RUN, message, attributes);
    }

    public Map<String, String> getAttributesFrom(Throwable throwable) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        Throwable rootCause = ExceptionUtils.getRootCause((Throwable)throwable);
        if (rootCause == null) {
            rootCause = throwable;
        }
        if (rootCause != null) {
            attributes.put("failed.exception.class", rootCause.getClass().getName());
            attributes.put("failed.exception.message", rootCause.getMessage());
            attributes.put("failed.exception.stacktrace", ExceptionsUtil.getStackTraceForThrowable(rootCause));
        }
        return attributes;
    }

    public void logSkipped(String message) {
        this.logMessage(null, LogLevel.SKIPPED, message, new HashMap<String, String>());
    }
}

