/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.logging.model;

import com.kms.katalon.core.logging.model.ILogRecord;
import com.kms.katalon.core.logging.model.MessageLogRecord;
import com.kms.katalon.core.logging.model.TestCaseLogRecord;
import com.kms.katalon.core.logging.model.TestStatus;
import com.kms.katalon.core.util.internal.DateUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractLogRecord
implements ILogRecord {
    protected static final String LINE_SEPARATOR = System.getProperty("line.separator");
    protected String type;
    protected String name;
    protected String id;
    protected String source;
    protected String message;
    protected String description;
    protected long startTime;
    protected long endTime;
    protected List<ILogRecord> childRecords;
    protected ILogRecord parentLogRecord;
    protected boolean interuppted;
    protected Map<String, String> properties;

    public AbstractLogRecord(String name) {
        this.setName(name);
        this.childRecords = new ArrayList<ILogRecord>();
        this.interuppted = false;
        this.type = "";
    }

    @Override
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    @Override
    public long getEndTime() {
        return this.endTime;
    }

    @Override
    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public void setSource(String source) {
        this.source = source;
    }

    @Override
    public TestStatus getStatus() {
        TestStatus testStatus = new TestStatus();
        if (this.isInterrupted()) {
            testStatus.setStatusValue(TestStatus.TestStatusValue.INCOMPLETE);
            return testStatus;
        }
        testStatus.setStatusValue(TestStatus.TestStatusValue.PASSED);
        if (this.childRecords == null || this.childRecords.size() == 0) {
            return testStatus;
        }
        this.setMessage(this.childRecords.get(this.childRecords.size() - 1).getMessage());
        int index = this.childRecords.size() - 1;
        while (index >= 0) {
            TestStatus.TestStatusValue logRecordStatusValue;
            ILogRecord messageRecord = this.childRecords.get(index);
            if (messageRecord instanceof MessageLogRecord && ((logRecordStatusValue = messageRecord.getStatus().getStatusValue()) == TestStatus.TestStatusValue.ERROR || logRecordStatusValue == TestStatus.TestStatusValue.FAILED || logRecordStatusValue == TestStatus.TestStatusValue.INCOMPLETE || logRecordStatusValue == TestStatus.TestStatusValue.PASSED || logRecordStatusValue == TestStatus.TestStatusValue.SKIPPED)) {
                testStatus.setStatusValue(logRecordStatusValue);
                this.setMessage(messageRecord.getMessage());
                return testStatus;
            }
            --index;
        }
        ILogRecord[] iLogRecordArray = this.getChildRecords();
        int n = iLogRecordArray.length;
        int n2 = 0;
        while (n2 < n) {
            TestStatus.TestStatusValue logRecordStatusValue;
            ILogRecord logRecord = iLogRecordArray[n2];
            if (!(logRecord instanceof TestCaseLogRecord && ((TestCaseLogRecord)logRecord).isOptional() || (logRecordStatusValue = logRecord.getStatus().getStatusValue()) != TestStatus.TestStatusValue.ERROR && logRecordStatusValue != TestStatus.TestStatusValue.FAILED && logRecordStatusValue != TestStatus.TestStatusValue.INCOMPLETE)) {
                testStatus.setStatusValue(logRecordStatusValue);
                this.setMessage(logRecord.getMessage());
                return testStatus;
            }
            ++n2;
        }
        return testStatus;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public boolean hasChildRecords() {
        return this.childRecords != null && this.childRecords.size() > 0;
    }

    @Override
    public ILogRecord[] getChildRecords() {
        return this.childRecords.toArray(new ILogRecord[0]);
    }

    @Override
    public void setChildRecords(ILogRecord[] childRecords) {
        this.childRecords = new ArrayList<ILogRecord>(Arrays.asList(childRecords));
    }

    @Override
    public void addChildRecord(ILogRecord childRecord) {
        this.childRecords.add(childRecord);
        childRecord.setParentLogRecord(this);
    }

    @Override
    public void removeChildRecord(ILogRecord childRecord) {
        this.childRecords.remove(childRecord);
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    public ILogRecord getParentLogRecord() {
        return this.parentLogRecord;
    }

    @Override
    public void setParentLogRecord(ILogRecord parentLogRecord) {
        this.parentLogRecord = parentLogRecord;
    }

    public String[] getAttachments() {
        return this.getAttachments(false);
    }

    public String[] getAttachments(boolean isInAbsolutePath) {
        ArrayList<String> attachments = new ArrayList<String>();
        ILogRecord[] childRecords = this.getChildRecords();
        if (childRecords != null) {
            ILogRecord[] iLogRecordArray = childRecords;
            int n = childRecords.length;
            int n2 = 0;
            while (n2 < n) {
                ILogRecord childRc = iLogRecordArray[n2];
                attachments.addAll(Arrays.asList(((AbstractLogRecord)childRc).getAttachments(isInAbsolutePath)));
                ++n2;
            }
        }
        String attachment = null;
        if (this instanceof MessageLogRecord) {
            attachment = ((MessageLogRecord)this).getAttachment(isInAbsolutePath);
        }
        if (!StringUtils.isBlank(attachment)) {
            attachments.add(attachment);
        }
        return attachments.toArray(new String[attachments.size()]);
    }

    @Override
    public boolean isInterrupted() {
        return this.interuppted;
    }

    @Override
    public void setInterrupted(boolean interrupted) {
        this.interuppted = interrupted;
    }

    public String[] getJsonExcludedFields() {
        return new String[]{"parentLogRecord"};
    }

    @Override
    public String getJUnitMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append(LINE_SEPARATOR);
        sb.append(DateUtil.getISOLocalDateTimeFormatted(this.getStartTime()));
        sb.append(" - ");
        if (!this.getType().isEmpty()) {
            sb.append("[" + this.getType() + "]");
        }
        sb.append("[" + this.getStatus().getStatusValue().name() + "]");
        sb.append(" - ");
        if (!this.getName().isEmpty()) {
            sb.append(String.valueOf(this.getName()) + ": ");
        }
        sb.append(this.getMessage());
        sb.append(LINE_SEPARATOR);
        return sb.toString();
    }

    @Override
    public String getSystemOutMsg() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getJUnitMessage());
        if (this.hasChildRecords()) {
            ILogRecord[] iLogRecordArray = this.getChildRecords();
            int n = iLogRecordArray.length;
            int n2 = 0;
            while (n2 < n) {
                ILogRecord item = iLogRecordArray[n2];
                sb.append(item.getSystemOutMsg());
                ++n2;
            }
        }
        return sb.toString();
    }

    @Override
    public String getSystemErrorMsg() {
        StringBuilder sb = new StringBuilder();
        if (this.getStatus().getStatusValue().isError()) {
            sb.append(this.getJUnitMessage());
        }
        sb.append(LINE_SEPARATOR);
        sb.append(this.getStatus().getStackTrace());
        if (this.hasChildRecords()) {
            ILogRecord[] iLogRecordArray = this.getChildRecords();
            int n = iLogRecordArray.length;
            int n2 = 0;
            while (n2 < n) {
                ILogRecord item = iLogRecordArray[n2];
                if (item.getStatus().getStatusValue().isError()) {
                    sb.append(item.getStatus().getStackTrace());
                    sb.append(LINE_SEPARATOR);
                }
                ++n2;
            }
        }
        sb.append(LINE_SEPARATOR);
        return sb.toString();
    }

    protected ILogRecord getParentLogRecordByType(ILogRecord parent, String type) {
        if (parent.getType().equals(type)) {
            return parent;
        }
        if (parent.getParentLogRecord() != null) {
            return this.getParentLogRecordByType(parent.getParentLogRecord(), type);
        }
        return null;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Override
    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public int hashCode() {
        return Objects.hash(this.description, this.endTime, this.id, this.interuppted, this.message, this.name, this.properties, this.source, this.startTime, this.type);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AbstractLogRecord)) {
            return false;
        }
        AbstractLogRecord other = (AbstractLogRecord)obj;
        return Objects.equals(this.description, other.description) && this.endTime == other.endTime && Objects.equals(this.id, other.id) && this.interuppted == other.interuppted && Objects.equals(this.message, other.message) && Objects.equals(this.name, other.name) && Objects.equals(this.properties, other.properties) && Objects.equals(this.source, other.source) && this.startTime == other.startTime && Objects.equals(this.type, other.type);
    }
}

