/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.main;

import com.kms.katalon.core.exception.KatalonRuntimeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.builder.AstBuilder;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.control.CompilePhase;

public class AnnotatedMethodCollector {
    private static final String FIELD_SKIPPED = "skipped";
    private ClassNode classNode;
    private Set<String> annotatedMethodNames;
    private Map<String, List<MethodNode>> methodCollector;

    public AnnotatedMethodCollector(Set<String> annotatedMethodNames) {
        this.annotatedMethodNames = annotatedMethodNames;
    }

    private ClassNode getMainClassNode(List<ASTNode> astNodes) {
        for (ASTNode childNode : astNodes) {
            if (!(childNode instanceof ClassNode) || !((ClassNode)childNode).isScript()) continue;
            return (ClassNode)childNode;
        }
        return null;
    }

    private List<MethodNode> collectMethodWithAnnotation(Class<?> annotationClass) {
        List methodList = this.classNode.getMethods();
        if (methodList == null) {
            return Collections.emptyList();
        }
        ArrayList<MethodNode> annotatedMethods = new ArrayList<MethodNode>();
        methodList.stream().forEach(method -> method.getAnnotations().stream().forEach(annotationNode -> {
            if (this.isAnnotationNodeName((AnnotationNode)annotationNode, annotationClass) && this.isAnnotationNotSkipped((AnnotationNode)annotationNode)) {
                annotatedMethods.add((MethodNode)method);
            }
        }));
        return annotatedMethods;
    }

    public boolean isAnnotationNodeName(AnnotationNode annotationNode, Class<?> annotationClass) {
        String annotationNodeName = annotationNode.getClassNode().getName();
        return annotationNodeName.equals(annotationClass.getName()) || annotationNodeName.equals(annotationClass.getSimpleName());
    }

    public boolean isAnnotationNotSkipped(AnnotationNode annotationNode) {
        Object value;
        Map fieldMembers = annotationNode.getMembers();
        if (!fieldMembers.containsKey(FIELD_SKIPPED)) {
            return true;
        }
        Expression skippedExprs = (Expression)fieldMembers.get(FIELD_SKIPPED);
        return !(skippedExprs instanceof ConstantExpression) || !((value = ((ConstantExpression)skippedExprs).getValue()) instanceof Boolean) || (Boolean)value == false;
    }

    public Map<String, List<MethodNode>> getMethodNodes(String scriptContent) throws IOException {
        if (this.methodCollector != null) {
            return this.methodCollector;
        }
        this.methodCollector = new HashMap<String, List<MethodNode>>();
        this.classNode = this.getMainClassNode(new AstBuilder().buildFromString(CompilePhase.CONVERSION, false, scriptContent));
        if (this.classNode == null) {
            return this.methodCollector;
        }
        this.annotatedMethodNames.stream().forEach(methodName -> {
            try {
                Class<?> clazz = Class.forName(methodName);
                this.methodCollector.put((String)methodName, this.collectMethodWithAnnotation(clazz));
            }
            catch (ClassNotFoundException e) {
                throw new KatalonRuntimeException(e);
            }
        });
        return this.methodCollector;
    }
}

