/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.main;

import com.kms.katalon.constants.GlobalStringConstants;
import com.kms.katalon.core.configuration.RunConfiguration;
import com.kms.katalon.core.constants.StringConstants;
import com.kms.katalon.core.context.internal.ExecutionEventManager;
import com.kms.katalon.core.context.internal.ExecutionListenerEvent;
import com.kms.katalon.core.context.internal.InternalTestCaseContext;
import com.kms.katalon.core.context.internal.InternalTestSuiteContext;
import com.kms.katalon.core.exception.KatalonRuntimeException;
import com.kms.katalon.core.logging.ErrorCollector;
import com.kms.katalon.core.main.CustomKeywordDelegatingMetaClass;
import com.kms.katalon.core.main.LogbackConfigurator;
import com.kms.katalon.core.main.RawTestBindingScriptExecutor;
import com.kms.katalon.core.main.RawTestScriptExecutor;
import com.kms.katalon.core.main.ScriptEngine;
import com.kms.katalon.core.main.TestCaseBindingExecutor;
import com.kms.katalon.core.main.TestCaseExecutor;
import com.kms.katalon.core.main.TestResult;
import com.kms.katalon.core.main.TestSuiteExecutor;
import com.kms.katalon.core.main.WSVerificationExecutor;
import com.kms.katalon.core.model.FailureHandling;
import com.kms.katalon.core.testcase.TestCaseBinding;
import groovy.lang.Binding;
import groovy.lang.GroovyClassLoader;
import groovy.lang.MetaClass;
import groovy.util.Node;
import groovy.util.NodeList;
import groovy.xml.XmlParser;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.runtime.InvokerHelper;

public class TestCaseMain {
    private static final int DELAY_TIME = 50;
    private static ScriptEngine engine;
    private static ExecutionEventManager eventManager;
    private static Map<String, Object> globalVariables;

    public static void beforeStart() throws IOException {
        LogbackConfigurator.init();
        GroovyClassLoader classLoader = new GroovyClassLoader(TestCaseMain.class.getClassLoader());
        engine = ScriptEngine.getDefault((ClassLoader)classLoader);
        TestCaseMain.loadInternalGlobalVariableClass(classLoader);
        boolean restrictCustomKeywords = (Boolean)RunConfiguration.getProperty("restrictCustomKeywords");
        if (!restrictCustomKeywords) {
            TestCaseMain.loadCustomKeywordsClass(classLoader);
            TestCaseMain.modifyCustomKeywordsClassAtRunTime(classLoader);
        }
        eventManager = ExecutionEventManager.getInstance();
    }

    private static void loadCustomKeywordsClass(GroovyClassLoader cl) {
        Class clazz = cl.parseClass("class CustomKeywords { }");
        InvokerHelper.metaRegistry.setMetaClass(clazz, (MetaClass)new CustomKeywordDelegatingMetaClass(clazz, cl));
    }

    private static void loadInternalGlobalVariableClass(GroovyClassLoader cl) {
        try {
            cl.loadClass("internal.GlobalVariable");
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                cl.parseClass(new File(RunConfiguration.getProjectDir(), StringConstants.INTERNAL_GLOBAL_VARIABLE_FILE_NAME));
            }
            catch (IOException | CompilationFailedException throwable) {}
        }
    }

    private static void modifyCustomKeywordsClassAtRunTime(GroovyClassLoader cl) {
        try {
            boolean isModified = false;
            ClassPool pool = ClassPool.getDefault();
            CtClass newCustomKeywordsClass = pool.get("CustomKeywords");
            if (newCustomKeywordsClass != null) {
                CtMethod[] methods;
                newCustomKeywordsClass.defrost();
                CtMethod[] ctMethodArray = methods = newCustomKeywordsClass.getDeclaredMethods();
                int n = methods.length;
                int n2 = 0;
                while (n2 < n) {
                    CtMethod method = ctMethodArray[n2];
                    if (method.getName().contains(".")) {
                        newCustomKeywordsClass.removeMethod(method);
                        isModified = true;
                    }
                    ++n2;
                }
                if (isModified) {
                    String path = String.valueOf(RunConfiguration.getProjectDir()) + File.separator + GlobalStringConstants.SYSTEM_FOLDER_NAME_BIN + File.separator + "lib";
                    newCustomKeywordsClass.writeFile(path);
                }
                Class<?> clazz = Class.forName("CustomKeywords");
                InvokerHelper.metaRegistry.setMetaClass(clazz, (MetaClass)new CustomKeywordDelegatingMetaClass(clazz, cl));
            }
        }
        catch (Exception exception) {}
    }

    public static TestResult runTestCase(String testCaseId, TestCaseBinding testCaseBinding, FailureHandling flowControl) throws InterruptedException {
        return TestCaseMain.runTestCase(testCaseId, testCaseBinding, flowControl, true, true);
    }

    public static TestResult runTestCase(String testCaseId, TestCaseBinding testCaseBinding, FailureHandling flowControl, boolean doCleanUp) throws InterruptedException {
        return TestCaseMain.runTestCase(testCaseId, testCaseBinding, flowControl, true, doCleanUp);
    }

    public static TestResult runTestCase(String testCaseId, TestCaseBinding testCaseBinding, FailureHandling flowControl, boolean isMain, boolean doCleanUp) throws InterruptedException {
        Thread.sleep(50L);
        InternalTestCaseContext testCaseContext = new InternalTestCaseContext(testCaseId);
        testCaseContext.setMainTestCase(isMain);
        return new TestCaseExecutor(testCaseBinding, engine, eventManager, testCaseContext, doCleanUp).execute(flowControl);
    }

    public static TestResult runWSVerificationScript(String verificationScript, FailureHandling flowControl, boolean doCleanUp) throws InterruptedException {
        Thread.sleep(50L);
        return new WSVerificationExecutor(verificationScript, engine, eventManager, doCleanUp).execute(flowControl);
    }

    public static TestResult runWSVerificationScript(TestCaseBinding testCaseBinding, String verificationScript, FailureHandling flowControl, boolean doCleanUp) throws InterruptedException {
        Thread.sleep(50L);
        return new WSVerificationExecutor(testCaseBinding, verificationScript, engine, eventManager, doCleanUp).execute(flowControl);
    }

    public static TestResult runTestCaseRawScript(String testScript, String testCaseId, TestCaseBinding testCaseBinding, FailureHandling flowControl) throws InterruptedException {
        Thread.sleep(50L);
        return new RawTestScriptExecutor(testScript, testCaseBinding, engine, eventManager, new InternalTestCaseContext(testCaseId)).execute(flowControl);
    }

    public static TestResult runFeatureFile(String featureFile) throws InterruptedException {
        Thread.sleep(50L);
        String verificationScript = MessageFormat.format("import com.kms.katalon.core.cucumber.keyword.CucumberBuiltinKeywords as CucumberKW\nCucumberKW.runFeatureFile(''{0}'')", featureFile);
        return new WSVerificationExecutor(null, verificationScript, engine, eventManager, true, true).execute(FailureHandling.STOP_ON_FAILURE);
    }

    public static TestResult runTestCaseRawScript(String testScript, String testCaseId, TestCaseBinding testCaseBinding, FailureHandling flowControl, boolean doCleanUp) throws InterruptedException {
        Thread.sleep(50L);
        return new RawTestScriptExecutor(testScript, testCaseBinding, engine, eventManager, new InternalTestCaseContext(testCaseId), doCleanUp).execute(flowControl);
    }

    public static void startTestSuite(String testSuiteId, Map<String, String> suiteProperties, File testCaseBindingFile) {
        TestSuiteExecutor testSuiteExecutor = new TestSuiteExecutor(testSuiteId, engine, eventManager);
        testSuiteExecutor.execute(suiteProperties, testCaseBindingFile);
    }

    public static void startTestCaseBinding(String testCaseId, File testCaseBindingFile) {
        TestCaseBindingExecutor testCaseBindingExecutor = new TestCaseBindingExecutor(testCaseId, engine, eventManager);
        testCaseBindingExecutor.execute(testCaseBindingFile);
    }

    public static void runTestCaseBindingRawScript(String testScript, String testCaseId, File testCaseBindingFile, FailureHandling flowControl, boolean doCleanUp) throws InterruptedException {
        Thread.sleep(50L);
        new RawTestBindingScriptExecutor(testScript, testCaseId, engine, eventManager, doCleanUp, flowControl).execute(testCaseBindingFile);
    }

    public static void invokeStartSuite(String testSuiteId) {
        InternalTestSuiteContext testSuiteContext = new InternalTestSuiteContext();
        testSuiteContext.setTestSuiteId(testSuiteId);
        eventManager.publicEvent(ExecutionListenerEvent.BEFORE_TEST_SUITE, new Object[]{testSuiteContext});
    }

    public static void invokeEndSuite(String testSuiteId) {
        InternalTestSuiteContext testSuiteContext = new InternalTestSuiteContext();
        testSuiteContext.setTestSuiteId(testSuiteId);
        eventManager.publicEvent(ExecutionListenerEvent.AFTER_TEST_SUITE, new Object[]{testSuiteContext});
    }

    public static Map<String, Object> getGlobalVariables(String profileName) {
        try {
            HashMap<String, Object> selectedVariables = new HashMap<String, Object>();
            Node rootNode = new XmlParser().parse(new File(RunConfiguration.getProjectDir(), "Profiles/" + profileName + ".glbl"));
            NodeList variableNodes = (NodeList)rootNode.get("GlobalVariableEntity");
            int index = 0;
            while (index < variableNodes.size()) {
                Node globalVariableNode = (Node)variableNodes.get(index);
                String variableName = ((Node)((NodeList)globalVariableNode.get("name")).get(0)).text();
                String defaultValue = ((Node)((NodeList)globalVariableNode.get("initValue")).get(0)).text();
                try {
                    selectedVariables.put(variableName, engine.runScriptWithoutLogging(defaultValue, new Binding()));
                }
                catch (Exception e) {
                    KatalonRuntimeException runtimeException = new KatalonRuntimeException(String.format("Could not evaluate default value for variable: %s of profile: %s. Details: %s", variableName, profileName, e.getMessage()), e);
                    ErrorCollector.getCollector().addError(runtimeException);
                }
                ++index;
            }
            return selectedVariables;
        }
        catch (Exception ex) {
            KatalonRuntimeException runtimeException = new KatalonRuntimeException(String.format("Could not evaluate variable of profile: %s. Details: %s", profileName, ex), ex);
            ErrorCollector.getCollector().addError(runtimeException);
            return Collections.emptyMap();
        }
    }

    private static void getGlobalVariableEntry(Object overrideProfile) {
        if (overrideProfile != null) {
            globalVariables.putAll(TestCaseMain.getGlobalVariables(String.valueOf(overrideProfile)));
        }
    }

    public static Map<String, Object> getParsedValues(Map<String, Object> rawMap, Map<String, Object> globalVariablesMap) {
        if (!rawMap.isEmpty()) {
            globalVariables = globalVariablesMap;
            TestCaseMain.getGlobalVariableEntry(rawMap.get("executionProfile"));
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : rawMap.entrySet()) {
            String variableName = entry.getKey();
            Object value = entry.getValue();
            String trimmed = String.valueOf(value).trim();
            if ((trimmed.startsWith("[") && trimmed.endsWith("]") || TestCaseMain.isGlobalVariable(variableName)) && (!TestCaseMain.isGlobalVariable(variableName) || TestCaseMain.getGlobalVariableClass(variableName) != String.class)) {
                try {
                    value = engine.runScriptWithoutLogging(trimmed, new Binding());
                }
                catch (Exception e) {
                    KatalonRuntimeException runtimeException = new KatalonRuntimeException(String.format("Could not evaluate overriding value for variable: %s", variableName, e.getMessage()), e);
                    ErrorCollector.getCollector().addError(runtimeException);
                }
            }
            result.put(variableName, value);
        }
        return result;
    }

    private static boolean isGlobalVariable(String key) {
        return globalVariables.get(key) != null;
    }

    private static Class<?> getGlobalVariableClass(String key) {
        return globalVariables.get(key).getClass();
    }

    public static void logGlobalVariableError(Exception e) {
        KatalonRuntimeException runtimeException = new KatalonRuntimeException(String.format("There was something wrong in GlobalVariable. Details: %s", e.getMessage()));
        ErrorCollector.getCollector().addError(runtimeException);
    }

    public static ScriptEngine getScriptEngine() {
        return engine;
    }
}

