/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.network;

import com.kms.katalon.core.network.HttpGetWithEntity;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.io.Charsets;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;

public class RequestBuilder<RequestType extends HttpRequestBase> {
    private RequestType request;

    public RequestBuilder(RequestType request) {
        this.request = request;
    }

    public static RequestBuilder<HttpPost> post() {
        return new RequestBuilder<HttpPost>(new HttpPost());
    }

    public static RequestBuilder<HttpGetWithEntity> get() {
        return new RequestBuilder<HttpGetWithEntity>(new HttpGetWithEntity());
    }

    public RequestBuilder<RequestType> uri(URIBuilder uriBuilder) throws URISyntaxException {
        this.request.setURI(uriBuilder.build());
        return this;
    }

    public RequestBuilder<RequestType> uri(URI uri) {
        this.request.setURI(uri);
        return this;
    }

    public RequestBuilder<RequestType> body(String body) {
        if (this.request instanceof HttpEntityEnclosingRequest) {
            ((HttpEntityEnclosingRequest)this.request).setEntity((HttpEntity)new StringEntity(body, Charsets.UTF_8));
        }
        return this;
    }

    public RequestType build() {
        return this.request;
    }
}

