/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.reporting;

import com.kms.katalon.core.logging.model.ILogRecord;
import com.kms.katalon.core.logging.model.TestCaseLogRecord;
import com.kms.katalon.core.logging.model.TestStatus;
import com.kms.katalon.core.logging.model.TestStepLogRecord;
import com.kms.katalon.core.reporting.JsModel;
import com.kms.katalon.core.reporting.JsModelProperty;
import com.kms.katalon.core.reporting.JsStepModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class JsTestModel
extends JsModel {
    private List<String> listStrings;
    private TestCaseLogRecord testLog;
    private JsModel tags;
    private JsModel status;
    private List<JsStepModel> steps;
    private TestStepLogRecord caller;

    public JsTestModel(TestCaseLogRecord testLog, List<String> listStrings) {
        this.testLog = testLog;
        this.listStrings = listStrings;
        this.init();
    }

    public JsTestModel(TestCaseLogRecord testLog, List<String> listStrings, TestStepLogRecord caller) {
        this(testLog, listStrings);
        this.caller = caller;
    }

    private void init() {
        this.props.add(new JsModelProperty("name", this.testLog.getName(), this.listStrings));
        this.props.add(new JsModelProperty("timeout", "0", null));
        this.props.add(new JsModelProperty("isCritical", "0", null));
        this.props.add(new JsModelProperty("document", StringUtils.defaultString((String)this.testLog.getDescription()), this.listStrings));
        this.props.add(new JsModelProperty("tag", StringUtils.defaultString((String)this.testLog.getTag()), this.listStrings));
        this.props.add(new JsModelProperty("retriedTimes", this.getRetriedTimes(this.testLog), this.listStrings));
        this.tags = new JsModel();
        this.initStatus();
        this.steps = new ArrayList<JsStepModel>();
        ILogRecord[] iLogRecordArray = this.testLog.getChildRecords();
        int n = iLogRecordArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILogRecord logRecord = iLogRecordArray[n2];
            if (logRecord instanceof TestStepLogRecord) {
                this.steps.add(new JsStepModel((TestStepLogRecord)logRecord, this.listStrings, this.caller == null ? "" : this.caller.getName()));
            }
            ++n2;
        }
    }

    private String getRetriedTimes(TestCaseLogRecord logRecord) {
        Map<String, String> properties = logRecord.getProperties();
        if (properties != null && properties.containsKey("currentRetryCount")) {
            return properties.get("currentRetryCount");
        }
        return "0";
    }

    private void initStatus() {
        this.status = new JsModel();
        TestStatus testStatusEntity = this.testLog.getStatus();
        TestStatus.TestStatusValue testStat = testStatusEntity.getStatusValue();
        String statVal = String.valueOf(testStat.ordinal());
        String errMsg = this.testLog.getMessage() == null ? "" : this.testLog.getMessage();
        long startTime = this.testLog.getStartTime();
        long elapsedTime = this.testLog.getEndTime() - startTime;
        this.status.props.add(new JsModelProperty("status", statVal, null));
        this.status.props.add(new JsModelProperty("startTime", String.valueOf(startTime), null));
        this.status.props.add(new JsModelProperty("elapsedTime", String.valueOf(elapsedTime), null));
        if (testStat == TestStatus.TestStatusValue.FAILED || testStat == TestStatus.TestStatusValue.ERROR) {
            this.status.props.add(errMsg.equals("") ? new JsModelProperty("errMessage", "0", null) : new JsModelProperty("errMessage", errMsg, this.listStrings));
        }
    }

    @Override
    public StringBuilder toArrayString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (JsModelProperty prop : this.props) {
            sb.append(prop.getPropertyValue());
            sb.append(",");
        }
        sb.append((CharSequence)this.tags.toArrayString());
        sb.append(",");
        sb.append((CharSequence)this.status.toArrayString());
        sb.append(",");
        sb.append("[");
        int i = 0;
        while (i < this.steps.size()) {
            sb.append((CharSequence)this.steps.get(i).toArrayString());
            if (i < this.steps.size() - 1) {
                sb.append(",");
            }
            ++i;
        }
        sb.append("]");
        sb.append("]");
        return sb;
    }

    public List<JsStepModel> getSteps() {
        return this.steps;
    }
}

