/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.setting;

import com.kms.katalon.core.setting.PropertySettingStoreUtil;
import com.kms.katalon.util.CryptoUtil;
import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Collection;

public class BundleSettingStore {
    private String bundleId;
    private String parentSettingFolder;
    private String projectDir;

    public BundleSettingStore(String projectDir, String bundleId, boolean isExternal) {
        this.bundleId = bundleId;
        this.projectDir = projectDir;
        this.parentSettingFolder = PropertySettingStoreUtil.INTERNAL_SETTING_ROOT_FOLDER_NAME;
        if (isExternal) {
            this.parentSettingFolder = PropertySettingStoreUtil.EXTERNAL_SETTING_ROOT_FOLDER_NAME;
        }
    }

    protected File getPropertyFile() throws IOException {
        File file = new File(this.projectDir, String.valueOf(this.parentSettingFolder) + File.separator + this.bundleId + ".properties");
        if (!file.exists()) {
            file.createNewFile();
        }
        return file;
    }

    public void setProperty(String key, int value) throws IOException {
        PropertySettingStoreUtil.addNewProperty(key, PropertySettingStoreUtil.getRawValue(value), this.getPropertyFile());
    }

    public void setProperty(String key, long value) throws IOException {
        PropertySettingStoreUtil.addNewProperty(key, PropertySettingStoreUtil.getRawValue(value), this.getPropertyFile());
    }

    public void setProperty(String key, String value) throws IOException {
        PropertySettingStoreUtil.addNewProperty(key, PropertySettingStoreUtil.getRawValue(value), this.getPropertyFile());
    }

    public void setProperty(String key, boolean value) throws IOException {
        PropertySettingStoreUtil.addNewProperty(key, PropertySettingStoreUtil.getRawValue(value), this.getPropertyFile());
    }

    private Object getValue(String key, Class<?> castType, Object defaultValueIfNotDefined) throws IOException {
        Object storedValue = PropertySettingStoreUtil.getValue(PropertySettingStoreUtil.getPropertyValue(key, this.getPropertyFile()));
        if (castType != null && castType.isInstance(storedValue)) {
            return storedValue;
        }
        return defaultValueIfNotDefined;
    }

    public boolean getBoolean(String key, boolean defaultValue) throws IOException {
        return (Boolean)this.getValue(key, Boolean.class, defaultValue);
    }

    public int getInt(String key, int defaultValue) throws IOException {
        return (Integer)this.getValue(key, Integer.class, defaultValue);
    }

    public String getString(String key, String defaultValue) throws IOException {
        return (String)this.getValue(key, String.class, defaultValue);
    }

    public String getStringProperty(String key, String defaultValue, boolean shouldDecrypt) throws GeneralSecurityException, IOException {
        String storedValue = this.getString(key, defaultValue);
        return shouldDecrypt ? CryptoUtil.decode((CryptoUtil.CrytoInfo)CryptoUtil.getDefault((String)storedValue)) : storedValue;
    }

    public void setStringProperty(String key, String rawValue, boolean shouldEncrypt) throws GeneralSecurityException, IOException {
        String storedValue = shouldEncrypt ? CryptoUtil.encode((CryptoUtil.CrytoInfo)CryptoUtil.getDefault((String)rawValue)) : rawValue;
        this.setProperty(key, storedValue);
    }

    public void removeProperties(Collection<String> keys) throws IOException {
        PropertySettingStoreUtil.removeAll(keys, this.getPropertyFile());
    }
}

